/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.graphical.view2code.generation;

import java.util.Optional;
import org.mule.tooling.dfl.dFL.As;
import org.mule.tooling.dfl.dFL.DFLFactory;
import org.mule.tooling.dfl.dFL.Expression;
import org.mule.tooling.dfl.dFL.IntersectionTypeExpression;
import org.mule.tooling.dfl.dFL.TypeExpression;
import org.mule.tooling.dfl.dFL.TypeReference;
import org.mule.tooling.dfl.ui.DFLExtendedActivator;
import org.mule.tooling.dfl.ui.contentassist.model.types.DFLTypeFactory;
import org.mule.tooling.dfl.ui.graphical.util.MappingNode;
import org.mule.tooling.dfl.ui.graphical.view2code.generation.IGraphicalAction;

public abstract class AbstractGraphicalAction
implements IGraphicalAction {
    public Expression castingExpression(Expression expression, MappingNode sourceMappingNode, MappingNode targetMappingNode) {
        Optional<Object> primitiveType = Optional.empty();
        if (targetMappingNode.isString() && !sourceMappingNode.isString()) {
            primitiveType = Optional.of(DFLTypeFactory.STRING.getName());
        } else if (targetMappingNode.isNumber() && !sourceMappingNode.isNumber()) {
            primitiveType = Optional.of(DFLTypeFactory.NUMBER.getName());
        } else if (targetMappingNode.isBoolean() && !sourceMappingNode.isBoolean()) {
            primitiveType = Optional.of(DFLTypeFactory.BOOLEAN.getName());
        } else if (targetMappingNode.isDate() && !sourceMappingNode.isDate()) {
            primitiveType = Optional.of(DFLTypeFactory.DATE.getName());
        } else if (targetMappingNode.isDateTime() && !sourceMappingNode.isDateTime()) {
            primitiveType = Optional.of(DFLTypeFactory.DATETIME.getName());
        } else if (this.convertUntypedToTyped(sourceMappingNode, targetMappingNode).booleanValue()) {
            if (targetMappingNode.isNumber()) {
                primitiveType = Optional.of(DFLTypeFactory.NUMBER.getName());
            } else if (targetMappingNode.isBoolean()) {
                primitiveType = Optional.of(DFLTypeFactory.BOOLEAN.getName());
            }
        }
        return !sourceMappingNode.isVirtual() && primitiveType.isPresent() ? this.createAsExpression(expression, (String)primitiveType.get()) : expression;
    }

    private Boolean convertUntypedToTyped(MappingNode sourceMappingNode, MappingNode targetMappingNode) {
        Boolean autoCastFromUntypedToTypedValue = DFLExtendedActivator.getInstance().getPreferenceStore().getBoolean("dataweave.auto_cast.from_untyped_to_typed_value");
        if (autoCastFromUntypedToTypedValue.booleanValue() && MappingNode.isUntyped(sourceMappingNode) && !MappingNode.isUntyped(targetMappingNode)) {
            return true;
        }
        return false;
    }

    private Expression createAsExpression(Expression expression, String primitiveType) {
        As asExpression = DFLFactory.eINSTANCE.createAs();
        TypeExpression type = DFLFactory.eINSTANCE.createTypeExpression();
        TypeReference simpleType = DFLFactory.eINSTANCE.createTypeReference();
        IntersectionTypeExpression intersectionType = DFLFactory.eINSTANCE.createIntersectionTypeExpression();
        asExpression.setElement(expression);
        simpleType.setFullQualifiedName(primitiveType);
        intersectionType.getTypes().add((Object)simpleType);
        type.getTypes().add((Object)intersectionType);
        asExpression.setType(type);
        return asExpression;
    }
}

