/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.graphical.view2code.appliers;

import org.mule.tooling.dfl.dFL.As;
import org.mule.tooling.dfl.dFL.BinaryFunction;
import org.mule.tooling.dfl.dFL.ClojureOperator;
import org.mule.tooling.dfl.dFL.ClojureOperatorOrOrExpression;
import org.mule.tooling.dfl.dFL.Content;
import org.mule.tooling.dfl.dFL.Expression;
import org.mule.tooling.dfl.ui.contentassist.model.IDFLType;
import org.mule.tooling.dfl.ui.graphical.view2code.MappingUtils;

public class FactoryAppliers {
    public static AsApplier getAsApplier(Content content, Expression rootExpression, IDFLType type) {
        if (MappingUtils.isObject(type)) {
            return new ObjectAsApplier(content);
        }
        if (MappingUtils.isArrayOfObject(type) && rootExpression instanceof BinaryFunction) {
            return new MapAsApplier(content);
        }
        return null;
    }

    public static abstract class AsApplier {
        protected Content content;

        public AsApplier(Content content) {
            this.content = content;
        }

        public abstract void initialize();

        public abstract void apply(As var1);

        public abstract Expression getExpression();
    }

    private static final class MapAsApplier
    extends AsApplier {
        private ClojureOperatorOrOrExpression function;

        public MapAsApplier(Content content) {
            super(content);
        }

        @Override
        public void initialize() {
            Expression expression = this.content.getElement();
            BinaryFunction map = (BinaryFunction)expression;
            this.function = map.getFunction();
        }

        @Override
        public void apply(As expression) {
            Expression orExpression = this.function.getOrExpression();
            if (orExpression != null) {
                this.function.setOrExpression((Expression)expression);
            } else {
                ClojureOperator clojureOperator = this.function.getClojureOperator();
                clojureOperator.setExpression((Expression)expression);
            }
        }

        @Override
        public Expression getExpression() {
            Expression orExpression = this.function.getOrExpression();
            if (orExpression != null) {
                return orExpression;
            }
            ClojureOperator clojureOperator = this.function.getClojureOperator();
            return clojureOperator.getExpression();
        }
    }

    private static final class ObjectAsApplier
    extends AsApplier {
        private Expression expression;

        public ObjectAsApplier(Content content) {
            super(content);
        }

        @Override
        public void initialize() {
            this.expression = this.content.getElement();
            this.content.setElement(null);
        }

        @Override
        public void apply(As expression) {
            this.content.setElement((Expression)expression);
        }

        @Override
        public Expression getExpression() {
            return this.expression;
        }
    }
}

