/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.graphical.view2code.actions;

import org.eclipse.xtext.resource.XtextResource;
import org.mule.tooling.dfl.ui.DFLExtendedActivator;
import org.mule.tooling.dfl.ui.graphical.util.MappingNode;
import org.mule.tooling.dfl.ui.graphical.util.StructureManager;
import org.mule.tooling.dfl.ui.graphical.view2code.actions.FieldAutoAssignment;
import org.mule.tooling.dfl.ui.input.IMetaDataProvider;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeNode;

public class FieldDeepAutoAssignment
extends FieldAutoAssignment {
    private int currentLevel;

    public FieldDeepAutoAssignment(MappingNode sourceMappingNode, MappingNode targetMappingNode, IMetaDataProvider inputMetadataProvider, IMetaDataProvider outputMetadataProvider) {
        this(sourceMappingNode, targetMappingNode, inputMetadataProvider, outputMetadataProvider, 1);
    }

    public FieldDeepAutoAssignment(MappingNode sourceMappingNode, MappingNode targetMappingNode, IMetaDataProvider inputMetadataProvider, IMetaDataProvider outputMetadataProvider, int currentLevel) {
        super(sourceMappingNode, targetMappingNode, inputMetadataProvider, outputMetadataProvider);
        this.currentLevel = currentLevel;
    }

    @Override
    protected boolean apply(XtextResource state, MappingNode sourceMappingNode, MappingNode targetMappingNode, IMetaDataProvider inputMetadataProvider, IMetaDataProvider outputMetadataProvider) throws Exception {
        boolean result = true;
        if (this.checkAutoMappingLevel() && sourceMappingNode.isObject() && targetMappingNode.isObject()) {
            GraphicalTreeNode<?> targetNode;
            GraphicalTreeNode<?> sourceNode = sourceMappingNode.getNode().get();
            result = StructureManager.compareObjects(sourceNode, targetNode = targetMappingNode.getNode().get()) ? super.apply(state, sourceMappingNode, targetMappingNode, inputMetadataProvider, outputMetadataProvider) : new FieldDeepAutoAssignment(sourceMappingNode, targetMappingNode, inputMetadataProvider, outputMetadataProvider, ++this.currentLevel).execute(state);
        } else if (this.checkAutoMappingLevel() && sourceMappingNode.isComplexList() && targetMappingNode.isComplexList()) {
            result = super.apply(state, sourceMappingNode, targetMappingNode, inputMetadataProvider, outputMetadataProvider);
            result &= new FieldDeepAutoAssignment(sourceMappingNode, targetMappingNode, inputMetadataProvider, outputMetadataProvider, ++this.currentLevel).execute(state);
        } else {
            result = super.apply(state, sourceMappingNode, targetMappingNode, inputMetadataProvider, outputMetadataProvider);
        }
        return result;
    }

    private boolean checkAutoMappingLevel() {
        int autoMappingLevel;
        int n = autoMappingLevel = DFLExtendedActivator.getInstance() != null ? DFLExtendedActivator.getInstance().getPreferenceStore().getInt("dataweave.automapping.max.level") : 1;
        return this.currentLevel <= autoMappingLevel;
    }

    @Override
    public String getDescription() {
        return "Auto-assign each inner field including nested objects";
    }
}

