/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.graphical.view2code.actions;

import java.util.List;
import java.util.Optional;
import javax.xml.namespace.QName;
import org.eclipse.xtext.resource.XtextResource;
import org.mule.metadata.api.model.AttributeFieldType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.tooling.dfl.dFL.Content;
import org.mule.tooling.dfl.dFL.DFLFactory;
import org.mule.tooling.dfl.dFL.Document;
import org.mule.tooling.dfl.dFL.Expression;
import org.mule.tooling.dfl.ui.graphical.references.properties.NodeSegmentProperty;
import org.mule.tooling.dfl.ui.graphical.util.MappingNode;
import org.mule.tooling.dfl.ui.graphical.view2code.MappingApplier;
import org.mule.tooling.dfl.ui.graphical.view2code.MappingTargetFinder;
import org.mule.tooling.dfl.ui.graphical.view2code.TargetInformation;
import org.mule.tooling.dfl.ui.graphical.view2code.actions.ITargetAction;
import org.mule.tooling.dfl.ui.input.IMetaDataProvider;
import org.mule.tooling.ui.modules.core.metadata.MetadataTypeHelper;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeNode;

public class FieldAutoAssignment
implements ITargetAction {
    protected MappingNode sourceMappingNode;
    protected MappingNode targetMappingNode;
    protected IMetaDataProvider inputMetadataProvider;
    protected IMetaDataProvider outputMetadataProvider;

    public FieldAutoAssignment(MappingNode sourceMappingNode, MappingNode targetMappingNode, IMetaDataProvider inputMetadataProvider, IMetaDataProvider outputMetadataProvider) {
        this.sourceMappingNode = sourceMappingNode;
        this.targetMappingNode = targetMappingNode;
        this.inputMetadataProvider = inputMetadataProvider;
        this.outputMetadataProvider = outputMetadataProvider;
    }

    @Override
    public boolean execute(XtextResource state) throws Exception {
        boolean result = true;
        Optional<NodeSegmentProperty> sourceSegmentProperty = this.sourceMappingNode.getReference().getSegments().getLast().getProperty(NodeSegmentProperty.class);
        Optional<NodeSegmentProperty> targetSegmentProperty = this.targetMappingNode.getReference().getSegments().getLast().getProperty(NodeSegmentProperty.class);
        NodeSegmentProperty sourceNodeSegmentProperty = sourceSegmentProperty.get();
        NodeSegmentProperty targetNodeNodeSegmentProperty = targetSegmentProperty.get();
        GraphicalTreeNode<?> sourceNode = sourceNodeSegmentProperty.getNode();
        GraphicalTreeNode<?> targetNode = targetNodeNodeSegmentProperty.getNode();
        GraphicalTreeNode[] sourceChildren = sourceNode.getChildren(sourceNode.getLevel() + 1);
        GraphicalTreeNode[] targetChildren = targetNode.getChildren(targetNode.getLevel() + 1);
        GraphicalTreeNode[] graphicalTreeNodeArray = sourceChildren;
        int n = sourceChildren.length;
        int n2 = 0;
        while (n2 < n) {
            GraphicalTreeNode sourceElement = graphicalTreeNodeArray[n2];
            GraphicalTreeNode[] graphicalTreeNodeArray2 = targetChildren;
            int n3 = targetChildren.length;
            int n4 = 0;
            while (n4 < n3) {
                QName targetQName;
                GraphicalTreeNode targetElement = graphicalTreeNodeArray2[n4];
                QName sourceQName = this.getQName(sourceElement.getModel());
                if (sourceQName.equals(targetQName = this.getQName(targetElement.getModel()))) {
                    MappingNode newSourceMappingNode = new MappingNode(sourceElement);
                    MappingNode newTargetMappingNode = new MappingNode(targetElement);
                    result &= this.apply(state, newSourceMappingNode, newTargetMappingNode, this.inputMetadataProvider, this.outputMetadataProvider);
                }
                ++n4;
            }
            ++n2;
        }
        return result;
    }

    protected QName getQName(Object sourceModel) {
        QName sourceQName = null;
        if (sourceModel instanceof ObjectFieldType) {
            ObjectFieldType sourceField = (ObjectFieldType)sourceModel;
            sourceQName = MetadataTypeHelper.toQName((ObjectFieldType)sourceField);
        } else if (sourceModel instanceof AttributeFieldType) {
            AttributeFieldType sourceField = (AttributeFieldType)sourceModel;
            sourceQName = MetadataTypeHelper.toQName((AttributeFieldType)sourceField);
        }
        return sourceQName;
    }

    protected boolean apply(XtextResource state, MappingNode sourceMappingNode, MappingNode targetMappingNode, IMetaDataProvider inputMetadataProvider, IMetaDataProvider outputMetadataProvider) throws Exception {
        MappingTargetFinder mappingTargetFinder = new MappingTargetFinder(sourceMappingNode, targetMappingNode);
        List<TargetInformation> targets = mappingTargetFinder.find(state);
        MappingApplier mappingApplier = new MappingApplier(sourceMappingNode, targetMappingNode, inputMetadataProvider, outputMetadataProvider);
        if (targets.isEmpty()) {
            Document document = (Document)state.getContents().get(0);
            Content content = document.getBody().getContent();
            content.setElement((Expression)DFLFactory.eINSTANCE.createMultipleKeyValuePairObj());
            targets = mappingTargetFinder.find(state);
        }
        TargetInformation newTargetInformation = targets.get(0);
        return mappingApplier.apply(state, newTargetInformation);
    }

    @Override
    public String getDescription() {
        return "Auto-assign each inner field excluding nested objects";
    }
}

