/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.graphical.view2code.actions;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.mule.tooling.dfl.ui.graphical.events.AutoMappingActivationEvent;
import org.mule.tooling.dfl.ui.graphical.util.MappingNode;
import org.mule.tooling.dfl.ui.graphical.util.StructureManager;
import org.mule.tooling.dfl.ui.graphical.view2code.TargetInformation;
import org.mule.tooling.dfl.ui.graphical.view2code.actions.DirectAssignment;
import org.mule.tooling.dfl.ui.graphical.view2code.actions.FieldDeepAutoAssignment;
import org.mule.tooling.dfl.ui.graphical.view2code.actions.ITargetAction;
import org.mule.tooling.dfl.ui.graphical.view2code.actions.ListFieldAutoAssignment;
import org.mule.tooling.dfl.ui.input.IMetaDataProvider;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeNode;
import org.mule.tooling.utils.eventbus.IEvent;
import org.mule.tooling.utils.eventbus.IEventBus;

public final class ActionManager {
    private ActionManager() {
    }

    public static List<ITargetAction> buildActions(MappingNode sourceMappingNode, MappingNode targetMappingNode, IMetaDataProvider inputMetadataProvider, IMetaDataProvider outputMetadataProvider, TargetInformation targetInformation, IEventBus eventBus, boolean isAutomap) {
        ArrayList actions = Lists.newArrayList();
        if (sourceMappingNode.isObject() && targetMappingNode.isObject()) {
            GraphicalTreeNode<?> sourceNode = sourceMappingNode.getNode().get();
            GraphicalTreeNode<?> targetNode = targetMappingNode.getNode().get();
            if (!isAutomap && StructureManager.compareObjects(sourceNode, targetNode)) {
                actions.add(new DirectAssignment(sourceMappingNode, targetMappingNode, inputMetadataProvider, outputMetadataProvider, targetInformation));
                eventBus.fireEvent((IEvent)new AutoMappingActivationEvent(sourceMappingNode, targetMappingNode));
            } else {
                actions.add(new FieldDeepAutoAssignment(sourceMappingNode, targetMappingNode, inputMetadataProvider, outputMetadataProvider));
            }
        } else if (sourceMappingNode.isList() && targetMappingNode.isList()) {
            actions.add(new ListFieldAutoAssignment(sourceMappingNode, targetMappingNode, inputMetadataProvider, outputMetadataProvider, targetInformation));
        } else {
            actions.add(new DirectAssignment(sourceMappingNode, targetMappingNode, inputMetadataProvider, outputMetadataProvider, targetInformation));
        }
        return actions;
    }
}

