/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.graphical.view2code;

import java.util.List;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.dfl.ui.graphical.util.MappingNode;
import org.mule.tooling.dfl.ui.graphical.view2code.ActionChooser;
import org.mule.tooling.dfl.ui.graphical.view2code.MappingApplier;
import org.mule.tooling.dfl.ui.graphical.view2code.MappingTargetFinder;
import org.mule.tooling.dfl.ui.graphical.view2code.MappingUtils;
import org.mule.tooling.dfl.ui.graphical.view2code.TargetChooser;
import org.mule.tooling.dfl.ui.graphical.view2code.TargetInformation;
import org.mule.tooling.dfl.ui.graphical.view2code.actions.ActionManager;
import org.mule.tooling.dfl.ui.graphical.view2code.actions.ITargetAction;
import org.mule.tooling.dfl.ui.input.IMetaDataProvider;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeNode;
import org.mule.tooling.utils.eventbus.EventBus;
import org.mule.tooling.utils.eventbus.IEventBus;

public class ViewToCodeUnitOfWork
implements IUnitOfWork<Boolean, XtextResource> {
    private GraphicalTreeNode<?> sourceNode;
    private GraphicalTreeNode<?> targetNode;
    private IMetaDataProvider inputMetadataProvider;
    private IMetaDataProvider outputMetadataProvider;
    private EventBus eventBus;
    private boolean isAutomap;
    private IMuleProject project;
    private boolean updateOutputHeader;

    public ViewToCodeUnitOfWork(GraphicalTreeNode<?> sourceNode, GraphicalTreeNode<?> targetNode, IMetaDataProvider inputMetadataProvider, IMetaDataProvider outputMetadataProvider, EventBus eventBus, IMuleProject project) {
        this(sourceNode, targetNode, inputMetadataProvider, outputMetadataProvider, eventBus, project, false, false);
    }

    public ViewToCodeUnitOfWork(GraphicalTreeNode<?> sourceNode, GraphicalTreeNode<?> targetNode, IMetaDataProvider inputMetadataProvider, IMetaDataProvider outputMetadataProvider, EventBus eventBus, IMuleProject project, boolean isAutomap, boolean updateOutputHeader) {
        this.sourceNode = sourceNode;
        this.targetNode = targetNode;
        this.inputMetadataProvider = inputMetadataProvider;
        this.outputMetadataProvider = outputMetadataProvider;
        this.eventBus = eventBus;
        this.project = project;
        this.isAutomap = isAutomap;
        this.updateOutputHeader = updateOutputHeader;
    }

    public Boolean exec(XtextResource state) throws Exception {
        boolean result = false;
        MappingNode sourceMappingNode = new MappingNode(this.sourceNode);
        MappingNode targetMappingNode = new MappingNode(this.targetNode);
        MappingUtils.autogenerateMapOperationsIfNecessary(state, sourceMappingNode, targetMappingNode, this.inputMetadataProvider, this.outputMetadataProvider);
        MappingUtils.configureOutputType(targetMappingNode, state, this.project);
        MappingTargetFinder mappingTargetFinder = new MappingTargetFinder(sourceMappingNode, targetMappingNode);
        List<TargetInformation> targets = mappingTargetFinder.find(state);
        if (!this.isAutomap && MappingUtils.checkOverridingRoot(targetMappingNode, state) || mappingTargetFinder.isWillOverwrite()) {
            MessageBox alert = new MessageBox(Display.getDefault().getActiveShell(), 296);
            alert.setText("Warning");
            alert.setMessage("This mapping will override the current script. Continue anyway?");
            if (alert.open() != 32) {
                return Boolean.FALSE;
            }
        }
        if (!targets.isEmpty()) {
            if (targets.size() > 1) {
                TargetChooser dialog = new TargetChooser(Display.getCurrent().getActiveShell(), targets);
                int open = dialog.open();
                if (open == 0) {
                    result = true;
                    targets = dialog.getSelectedTargets();
                    for (TargetInformation targetInformation : targets) {
                        MappingApplier mappingApplier = new MappingApplier(sourceMappingNode, targetMappingNode, this.inputMetadataProvider, this.outputMetadataProvider);
                        result &= mappingApplier.apply(state, targetInformation);
                    }
                }
            } else {
                ActionChooser dialog;
                int open;
                TargetInformation targetInformation = targets.get(0);
                List<ITargetAction> actions = ActionManager.buildActions(sourceMappingNode, targetMappingNode, this.inputMetadataProvider, this.outputMetadataProvider, targetInformation, (IEventBus)this.eventBus, this.isAutomap);
                if (actions.size() == 1) {
                    result = actions.get(0).execute(state);
                } else if (actions.size() > 1 && (open = (dialog = new ActionChooser(Display.getCurrent().getActiveShell(), actions)).open()) == 0) {
                    result = dialog.getSelectedAction().execute(state);
                }
            }
        }
        return result;
    }
}

