/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.graphical.view2code;

import java.util.Optional;
import javax.xml.namespace.QName;
import org.eclipse.emf.ecore.EObject;
import org.mule.tooling.dfl.dFL.ObjectElement;
import org.mule.tooling.dfl.ui.graphical.references.ISegment;
import org.mule.tooling.dfl.ui.graphical.view2code.KeyValuePairContainer;
import org.mule.tooling.dfl.ui.graphical.view2code.KeyValuePairContainerFinder;
import org.mule.tooling.dfl.ui.graphical.view2code.TargetContainer;
import org.mule.tooling.dfl.ui.graphical.view2code.TargetFinderContext;

public class TargetInformation {
    private TargetContainer targetContainer;
    private TargetFinderContext targetContext;
    private Optional<KeyValuePairContainer> existingKeyValuePair = Optional.empty();

    public TargetInformation(TargetContainer targetContainer, TargetFinderContext targetContext) {
        this.targetContext = targetContext;
        this.targetContainer = targetContainer;
    }

    public TargetFinderContext getTargetContext() {
        return this.targetContext;
    }

    public TargetContainer getTargetContainer() {
        return this.targetContainer;
    }

    public Optional<KeyValuePairContainer> getExistingKeyValuePair() {
        if (!this.existingKeyValuePair.isPresent()) {
            this.resolveKeyValuePairTarget();
        }
        return this.existingKeyValuePair;
    }

    private void resolveKeyValuePairTarget() {
        ISegment currentSegment = this.targetContext.getCurrentSegment();
        if (currentSegment != null) {
            QName qName = currentSegment.getQName();
            KeyValuePairContainerFinder finder = new KeyValuePairContainerFinder(qName);
            for (ObjectElement objectElement : this.targetContainer.getElements()) {
                if (this.existingKeyValuePair.isPresent()) continue;
                this.existingKeyValuePair = finder.doSwitch((EObject)objectElement);
            }
        }
    }
}

