/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.graphical.view2code;

import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Optional;
import org.mule.tooling.dfl.ui.graphical.model.GraphicalEvaluationContext;
import org.mule.tooling.dfl.ui.graphical.references.ISegment;
import org.mule.tooling.dfl.ui.graphical.references.SegmentUtils;
import org.mule.tooling.dfl.ui.graphical.references.TreeReference;
import org.mule.tooling.dfl.ui.graphical.references.properties.AttributeSegmentProperty;
import org.mule.tooling.dfl.ui.graphical.util.MappingNode;

public class TargetFinderContext
extends GraphicalEvaluationContext {
    private LinkedList<ISegment> trace;
    private LinkedList<ISegment> segments;
    private boolean lastLevelReached;

    private TargetFinderContext() {
    }

    public TargetFinderContext(MappingNode node) {
        TreeReference reference = node.getReference();
        this.segments = reference.getSegments();
        this.segments.removeFirst();
        this.trace = new LinkedList();
    }

    public ISegment getCurrentSegment() {
        return this.segments.peek();
    }

    public void nextSegment() {
        ISegment segment = this.segments.removeFirst();
        this.trace.add(segment);
    }

    public boolean isAttribute() {
        Optional<AttributeSegmentProperty> maybeAttributeProperty = !this.segments.isEmpty() ? this.segments.getLast().getProperty(AttributeSegmentProperty.class) : Optional.empty();
        return maybeAttributeProperty.map(AttributeSegmentProperty::isAttribute).orElse(false);
    }

    public boolean isTextElement() {
        return !this.segments.isEmpty() ? SegmentUtils.isTextElement(this.segments.getLast()) : false;
    }

    public boolean isLastSegment() {
        return this.segments.size() <= 1 || this.segments.size() == 2 && this.segments.getLast().getProperty(AttributeSegmentProperty.class).get().isAttribute();
    }

    public boolean hasNextSegment() {
        return !this.segments.isEmpty();
    }

    public LinkedList<ISegment> getTrace() {
        return this.trace;
    }

    public void setLastLevelReached(boolean lastLevelReached) {
        this.lastLevelReached = lastLevelReached;
    }

    public boolean isLastLevelReached() {
        return this.lastLevelReached;
    }

    public TargetFinderContext deepClone() {
        TargetFinderContext contextCloned = new TargetFinderContext();
        contextCloned.level = this.level;
        contextCloned.lastLevelReached = this.lastLevelReached;
        contextCloned.trace = new LinkedList<ISegment>(this.trace);
        contextCloned.frames = new ArrayDeque(this.frames);
        contextCloned.segments = new LinkedList<ISegment>(this.segments);
        contextCloned.namespaces = new HashMap(this.namespaces);
        return contextCloned;
    }
}

