/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.graphical.view2code;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.mule.tooling.dfl.dFL.Array;
import org.mule.tooling.dfl.dFL.ArrayElement;
import org.mule.tooling.dfl.dFL.As;
import org.mule.tooling.dfl.dFL.BinaryFunction;
import org.mule.tooling.dfl.dFL.Body;
import org.mule.tooling.dfl.dFL.ClojureOperator;
import org.mule.tooling.dfl.dFL.ClojureOperatorOrOrExpression;
import org.mule.tooling.dfl.dFL.Content;
import org.mule.tooling.dfl.dFL.DefaultValueExpression;
import org.mule.tooling.dfl.dFL.Directive;
import org.mule.tooling.dfl.dFL.Document;
import org.mule.tooling.dfl.dFL.EnclosedExpression;
import org.mule.tooling.dfl.dFL.EnclosedObjectElement;
import org.mule.tooling.dfl.dFL.Expression;
import org.mule.tooling.dfl.dFL.Header;
import org.mule.tooling.dfl.dFL.KeyValuePair;
import org.mule.tooling.dfl.dFL.LambdaLiteral;
import org.mule.tooling.dfl.dFL.MultipleKeyValuePairObj;
import org.mule.tooling.dfl.dFL.NamespaceDirective;
import org.mule.tooling.dfl.dFL.ObjectElement;
import org.mule.tooling.dfl.dFL.ObjectElements;
import org.mule.tooling.dfl.dFL.ObjectPattern;
import org.mule.tooling.dfl.dFL.SingleKeyValuePairObj;
import org.mule.tooling.dfl.dFL.Using;
import org.mule.tooling.dfl.dFL.VariableReference;
import org.mule.tooling.dfl.dFL.util.DFLSwitch;
import org.mule.tooling.dfl.ui.graphical.model.GraphicalEvaluationContext;
import org.mule.tooling.dfl.ui.graphical.references.AbstractReference;
import org.mule.tooling.dfl.ui.graphical.references.CodeReference;
import org.mule.tooling.dfl.ui.graphical.references.ISegment;
import org.mule.tooling.dfl.ui.graphical.util.GraphicalToolHelper;
import org.mule.tooling.dfl.ui.graphical.view2code.MappingTargetFinder;
import org.mule.tooling.dfl.ui.graphical.view2code.MultipleTargetContainer;
import org.mule.tooling.dfl.ui.graphical.view2code.TargetContainer;
import org.mule.tooling.dfl.ui.graphical.view2code.TargetFinderContext;
import org.mule.tooling.dfl.ui.graphical.view2code.generation.DflFactoryUtils;

public class TargetFinder
extends DFLSwitch<Optional<? extends TargetContainer>> {
    private TargetFinderContext context;
    private MappingTargetFinder mappingTargetFinder;

    public TargetFinder(TargetFinderContext context, MappingTargetFinder mappingTargetFinder) {
        this.context = context;
        this.mappingTargetFinder = mappingTargetFinder;
    }

    public Optional<? extends TargetContainer> caseDocument(Document object) {
        Object result = Optional.empty();
        Body body = object.getBody();
        if (body != null) {
            result = this.doSwitch((EObject)body);
        }
        return result;
    }

    public Optional<? extends TargetContainer> caseDefaultValueExpression(DefaultValueExpression object) {
        Object element = this.doSwitch((EObject)object.getElement());
        if (((Optional)element).isPresent()) {
            return element;
        }
        return this.doSwitch((EObject)object.getDefault());
    }

    public Optional<? extends TargetContainer> caseBody(Body object) {
        Header header = object.getHeader();
        if (header != null) {
            this.doSwitch((EObject)header);
        }
        return this.doSwitch((EObject)object.getContent());
    }

    public Optional<? extends TargetContainer> caseHeader(Header object) {
        if (object != null) {
            EList directives = object.getDirectives();
            for (Directive directive : directives) {
                this.doSwitch((EObject)directive);
            }
        }
        return (Optional)super.caseHeader(object);
    }

    public Optional<? extends TargetContainer> caseNamespaceDirective(NamespaceDirective object) {
        String prefix = object.getName();
        String value = object.getValue();
        this.context.addNamespace(prefix, value);
        return (Optional)super.caseNamespaceDirective(object);
    }

    public Optional<? extends TargetContainer> caseContent(Content object) {
        Expression expression;
        Object result = Optional.of(new TargetContainer((EObject)object, this.calculateContextVariables(), this.context.dumpContext()));
        if (this.context.hasNextSegment() && (expression = object.getElement()) != null) {
            Object nextResult = this.doSwitch((EObject)expression);
            if (nextResult != null && ((Optional)nextResult).isPresent()) {
                result = nextResult;
            } else {
                this.mappingTargetFinder.setWillOverwrite(true);
            }
        }
        return result;
    }

    public Optional<? extends TargetContainer> caseSingleKeyValuePairObj(SingleKeyValuePairObj object) {
        return this.doSwitch((EObject)object.getObjectElement());
    }

    public Optional<? extends TargetContainer> caseMultipleKeyValuePairObj(MultipleKeyValuePairObj object) {
        this.context.startScope();
        Optional<TargetContainer> result = Optional.of(new TargetContainer((EObject)object, this.calculateContextVariables(), this.context.dumpContext()));
        boolean lastSegment = this.context.isLastSegment();
        this.context.setLastLevelReached(lastSegment);
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        ObjectPattern pattern = object.getPattern();
        if (pattern instanceof ObjectElements) {
            for (ObjectElement objectElement : ((ObjectElements)pattern).getObjectElements()) {
                if (!lastSegment) {
                    Object tempResult = this.doSwitch((EObject)objectElement);
                    if (!((Optional)tempResult).isPresent()) continue;
                    result = tempResult;
                    break;
                }
                if (!(objectElement instanceof EnclosedObjectElement)) continue;
                expressions.add(((EnclosedObjectElement)objectElement).getExpression());
            }
        }
        if (!expressions.isEmpty()) {
            for (Expression expression : expressions) {
                TargetFinderContext contextCloned;
                TargetFinder targetFinder;
                Object maybeTargetContainer;
                if (!this.context.isAttribute() && !this.context.isTextElement() || !((Optional)(maybeTargetContainer = (targetFinder = new TargetFinder(contextCloned = this.context.deepClone(), this.mappingTargetFinder)).doSwitch((EObject)expression))).isPresent()) continue;
                TargetContainer targetContainer = (TargetContainer)((Optional)maybeTargetContainer).get();
                if (result.isPresent() && ((TargetContainer)result.get()).getStaticContext().getFrameCount() > 0) {
                    HashMap<String, AbstractReference> contentVariablesUnion = new HashMap<String, AbstractReference>(((TargetContainer)result.get()).getContextVariables());
                    contentVariablesUnion.putAll(targetContainer.getContextVariables());
                    GraphicalEvaluationContext staticContenxtUnion = result.get().getStaticContext().dumpContext();
                    for (Map.Entry<String, EObject> entry : targetContainer.getStaticContext().getVariables().entrySet()) {
                        staticContenxtUnion.addVariable(entry.getKey(), entry.getValue());
                    }
                    result = Optional.of(new TargetContainer((EObject)object, contentVariablesUnion, staticContenxtUnion));
                    continue;
                }
                result = Optional.of(new TargetContainer((EObject)object, targetContainer.getContextVariables(), targetContainer.getStaticContext()));
            }
        }
        this.context.endScope();
        return result;
    }

    public Optional<? extends TargetContainer> caseKeyValuePair(KeyValuePair object) {
        Object result = Optional.empty();
        ISegment currentSegment = this.context.getCurrentSegment();
        if (currentSegment != null && GraphicalToolHelper.compareKey(object.getKey(), currentSegment.getQName())) {
            this.context.nextSegment();
            result = this.doSwitch((EObject)object.getValue());
        }
        return result;
    }

    public Optional<? extends TargetContainer> caseEnclosedExpression(EnclosedExpression object) {
        return this.doSwitch((EObject)object.getExpression());
    }

    public Optional<? extends TargetContainer> caseEnclosedObjectElement(EnclosedObjectElement object) {
        if (object.getValue() == null && object.getAttributes() == null && object.getCondition() == null) {
            return this.doSwitch((EObject)object.getExpression());
        }
        if (object.getExpression() != null && object.getCondition() != null && object.getValue() == null) {
            return this.doSwitch((EObject)object.getExpression());
        }
        return (Optional)super.caseEnclosedObjectElement(object);
    }

    public Optional<? extends TargetContainer> caseBinaryFunction(BinaryFunction object) {
        ClojureOperatorOrOrExpression function;
        block20: {
            function = object.getFunction();
            if (function == null) {
                return Optional.empty();
            }
            if (!(object.getFunctionName() instanceof VariableReference)) break block20;
            String variableName = ((VariableReference)object.getFunctionName()).getReference();
            if (variableName == null) {
                return Optional.empty();
            }
            switch (variableName) {
                case "++": {
                    MultipleTargetContainer multipleContainerWrapper = new MultipleTargetContainer((EObject)object, this.calculateContextVariables(), this.context.dumpContext());
                    Expression left = object.getElement();
                    TargetFinderContext contextBackup = this.context.deepClone();
                    Object leftResult = this.doSwitch((EObject)left);
                    this.context = contextBackup;
                    Object rightResult = Optional.empty();
                    if (function.getOrExpression() != null) {
                        Expression right = function.getOrExpression();
                        rightResult = this.doSwitch((EObject)right);
                    } else {
                        ClojureOperator right = function.getClojureOperator();
                        rightResult = this.doSwitch((EObject)right);
                    }
                    if (((Optional)leftResult).isPresent()) {
                        multipleContainerWrapper.addContainer((TargetContainer)((Optional)leftResult).get());
                    }
                    if (((Optional)rightResult).isPresent()) {
                        multipleContainerWrapper.addContainer((TargetContainer)((Optional)rightResult).get());
                    }
                    return Optional.of(multipleContainerWrapper);
                }
                case "map": {
                    this.context.startFrame();
                    Object result = this.doSwitch((EObject)function);
                    this.context.endFrame();
                    return result;
                }
                case "write": {
                    return this.doSwitch((EObject)object.getElement());
                }
            }
        }
        this.context.startFrame();
        this.context.handleLambdaParameters(function);
        this.context.endFrame();
        if (function.getOrExpression() != null) {
            return this.doSwitch((EObject)function.getOrExpression());
        }
        return this.doSwitch((EObject)function.getClojureOperator());
    }

    public Optional<? extends TargetContainer> caseClojureOperatorOrOrExpression(ClojureOperatorOrOrExpression object) {
        this.context.handleLambdaParameters(object);
        if (object.getOrExpression() != null) {
            return this.doSwitch((EObject)object.getOrExpression());
        }
        return this.doSwitch((EObject)object.getClojureOperator());
    }

    public Optional<? extends TargetContainer> caseLambdaLiteral(LambdaLiteral object) {
        this.context.handleLambdaParameters(object);
        return this.doSwitch((EObject)object.getExpression());
    }

    public Optional<? extends TargetContainer> caseClojureOperator(ClojureOperator object) {
        return this.doSwitch((EObject)object.getExpression());
    }

    public Optional<? extends TargetContainer> caseUsing(Using object) {
        this.context.startFrame();
        this.context.handleVariableDefinitions(object);
        Object result = this.doSwitch((EObject)object.getExpression());
        this.context.endFrame();
        return result;
    }

    public Optional<? extends TargetContainer> caseArray(Array object) {
        Object result = Optional.empty();
        DflFactoryUtils.ArrayWrapper wrapper = DflFactoryUtils.from(object);
        for (ArrayElement arrayElement : wrapper.getElements()) {
            result = this.doSwitch((EObject)arrayElement);
        }
        return result;
    }

    public Optional<? extends TargetContainer> caseAs(As object) {
        return this.doSwitch((EObject)object.getElement());
    }

    public Optional<? extends TargetContainer> doSwitch(EObject eObject) {
        if (eObject == null) {
            return Optional.empty();
        }
        Optional doSwitch = (Optional)super.doSwitch(eObject);
        if (doSwitch == null) {
            return Optional.empty();
        }
        return doSwitch;
    }

    private Map<String, AbstractReference> calculateContextVariables() {
        Map<String, EObject> variables = this.context.getVariables();
        HashMap<String, AbstractReference> canonicalVariables = new HashMap<String, AbstractReference>();
        for (Map.Entry<String, EObject> entry : variables.entrySet()) {
            CodeReference reference = CodeReference.of(this.context, entry.getValue());
            canonicalVariables.put(entry.getKey(), reference);
        }
        return canonicalVariables;
    }
}

