/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.graphical.view2code;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.mule.metadata.api.model.AttributeFieldType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.tooling.dfl.dFL.Content;
import org.mule.tooling.dfl.dFL.DFLFactory;
import org.mule.tooling.dfl.dFL.EnclosedObjectElement;
import org.mule.tooling.dfl.dFL.Expression;
import org.mule.tooling.dfl.dFL.KeyValuePair;
import org.mule.tooling.dfl.dFL.MultipleKeyValuePairObj;
import org.mule.tooling.dfl.dFL.ObjectElement;
import org.mule.tooling.dfl.dFL.ObjectElements;
import org.mule.tooling.dfl.dFL.ObjectPattern;
import org.mule.tooling.dfl.dFL.SingleKeyValuePairObj;
import org.mule.tooling.dfl.ui.graphical.model.GraphicalEvaluationContext;
import org.mule.tooling.dfl.ui.graphical.references.AbstractReference;
import org.mule.tooling.dfl.ui.graphical.references.ISegment;
import org.mule.tooling.dfl.ui.graphical.references.properties.PreviousNodesProperty;
import org.mule.tooling.dfl.ui.graphical.util.GraphicalToolHelper;
import org.mule.tooling.ui.modules.core.metadata.MetadataTypeHelper;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeNode;

public class TargetContainer {
    private List<String> inputs;
    private EObject objectContainer;
    private GraphicalEvaluationContext staticContext;
    private Map<String, AbstractReference> contextVariables;

    public TargetContainer(EObject objectContainer) {
        this(objectContainer, new HashMap<String, AbstractReference>(), GraphicalEvaluationContext.empty());
    }

    public TargetContainer(EObject objectContainer, Map<String, AbstractReference> contextVariables, GraphicalEvaluationContext staticContext) {
        this.objectContainer = objectContainer;
        this.contextVariables = contextVariables;
        this.staticContext = staticContext;
        this.inputs = Lists.newArrayList((Object[])new String[]{"payload"});
    }

    public EObject getObjectContainer() {
        return this.objectContainer;
    }

    public List<String> getInputs() {
        return this.inputs;
    }

    public GraphicalEvaluationContext getStaticContext() {
        return this.staticContext;
    }

    public Map<String, AbstractReference> getContextVariables() {
        return this.contextVariables;
    }

    public void addObject(EObject object, ISegment segment) {
        if (this.objectContainer instanceof MultipleKeyValuePairObj) {
            MultipleKeyValuePairObj multipleKeyValuePairObj = (MultipleKeyValuePairObj)this.objectContainer;
            ObjectPattern pattern = multipleKeyValuePairObj.getPattern();
            if (pattern == null) {
                pattern = DFLFactory.eINSTANCE.createObjectElements();
                multipleKeyValuePairObj.setPattern(pattern);
            }
            if (pattern instanceof ObjectElements) {
                EList elements = ((ObjectElements)pattern).getObjectElements();
                if (segment != null) {
                    if (elements.isEmpty()) {
                        if (object instanceof ObjectElement) {
                            elements.add((Object)((ObjectElement)object));
                        } else {
                            EnclosedObjectElement enclosedObjectElement = DFLFactory.eINSTANCE.createEnclosedObjectElement();
                            enclosedObjectElement.setExpression((Expression)object);
                            elements.add((Object)enclosedObjectElement);
                        }
                    } else {
                        int elementIndex = this.calculateIndex((EList<ObjectElement>)elements, segment);
                        if (object instanceof ObjectElement) {
                            elements.add(elementIndex, (Object)((ObjectElement)object));
                        } else {
                            EnclosedObjectElement enclosedObjectElement = DFLFactory.eINSTANCE.createEnclosedObjectElement();
                            enclosedObjectElement.setExpression((Expression)object);
                            elements.add(elementIndex, (Object)enclosedObjectElement);
                        }
                    }
                }
            }
        } else if (this.objectContainer instanceof SingleKeyValuePairObj && object instanceof KeyValuePair) {
            ((SingleKeyValuePairObj)this.objectContainer).setObjectElement((KeyValuePair)object);
        } else if (this.objectContainer instanceof Content) {
            if (object instanceof Expression) {
                ((Content)this.objectContainer).setElement((Expression)object);
            } else {
                MultipleKeyValuePairObj newObjectContainer = DFLFactory.eINSTANCE.createMultipleKeyValuePairObj();
                ((Content)this.objectContainer).setElement((Expression)newObjectContainer);
                ObjectElements objectElements = DFLFactory.eINSTANCE.createObjectElements();
                objectElements.getObjectElements().add((Object)((ObjectElement)object));
                newObjectContainer.setPattern((ObjectPattern)objectElements);
                this.objectContainer = newObjectContainer;
            }
        }
    }

    public Iterable<ObjectElement> getElements() {
        ArrayList elements = Lists.newArrayList();
        if (this.objectContainer instanceof MultipleKeyValuePairObj) {
            ObjectPattern pattern = ((MultipleKeyValuePairObj)this.objectContainer).getPattern();
            if (pattern instanceof ObjectElements) {
                elements = ((ObjectElements)pattern).getObjectElements();
            }
        } else if (this.objectContainer instanceof SingleKeyValuePairObj) {
            elements = Lists.newArrayList((Object[])new ObjectElement[]{((SingleKeyValuePairObj)this.objectContainer).getObjectElement()});
        }
        return elements;
    }

    private int calculateIndex(EList<ObjectElement> elements, ISegment segment) {
        Optional<PreviousNodesProperty> property = segment.getProperty(PreviousNodesProperty.class);
        if (property.isPresent()) {
            boolean findPreviousSibling = false;
            PreviousNodesProperty previousNodesProperty = property.get();
            GraphicalTreeNode<?>[] previousSiblingNodes = previousNodesProperty.getPreviousNodes();
            int index = previousSiblingNodes.length - 1;
            while (index >= 0) {
                int elementIndex = 0;
                GraphicalTreeNode<?> node = previousSiblingNodes[index];
                while (elementIndex < elements.size() && !findPreviousSibling) {
                    ObjectElement objectElement = (ObjectElement)elements.get(elementIndex);
                    if (objectElement instanceof KeyValuePair) {
                        Object field = node.getModel();
                        KeyValuePair keyValuePair = (KeyValuePair)objectElement;
                        if (field instanceof ObjectFieldType) {
                            if (GraphicalToolHelper.compareKey(keyValuePair.getKey(), MetadataTypeHelper.toQName((ObjectFieldType)((ObjectFieldType)field)))) {
                                findPreviousSibling = true;
                            }
                        } else if (field instanceof AttributeFieldType && GraphicalToolHelper.compareKey(keyValuePair.getKey(), MetadataTypeHelper.toQName((AttributeFieldType)((AttributeFieldType)field)))) {
                            findPreviousSibling = true;
                        }
                    }
                    ++elementIndex;
                }
                if (findPreviousSibling) {
                    return elementIndex;
                }
                --index;
            }
        }
        return 0;
    }
}

