/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.graphical.view2code;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.mule.tooling.dfl.dFL.BinaryFunction;
import org.mule.tooling.dfl.dFL.Content;
import org.mule.tooling.dfl.dFL.Expression;
import org.mule.tooling.dfl.ui.graphical.view2code.TargetInformation;
import org.mule.tooling.dfl.ui.graphical.view2code.generation.DflFactoryUtils;

public class TargetChooser
extends Dialog {
    private List<Button> contexts;
    private List<TargetInformation> targets;
    private List<TargetInformation> selectedTargets = Lists.newArrayList();

    protected TargetChooser(Shell parentShell, List<TargetInformation> targets) {
        super(parentShell);
        this.targets = targets;
        this.contexts = new ArrayList<Button>(targets.size());
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Context selection");
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayoutFactory.fillDefaults().numColumns(1).margins(5, 10).applyTo(container);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)container);
        int index = 0;
        for (TargetInformation targetInformation : this.targets) {
            Group group = new Group(container, 4);
            GridLayoutFactory.fillDefaults().applyTo((Composite)group);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)group);
            Button option = new Button((Composite)group, 32);
            option.setData((Object)index);
            option.setText("Apply in " + this.findSource(targetInformation.getTargetContainer().getObjectContainer()));
            this.contexts.add(option);
            ++index;
        }
        Group group = new Group(container, 4);
        GridLayoutFactory.fillDefaults().applyTo((Composite)group);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)group);
        Button option = new Button((Composite)group, 32);
        option.setData((Object)this.targets.size());
        option.setText("Apply in all contexts");
        option.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button button = (Button)event.getSource();
                boolean selection = button.getSelection();
                for (Button option : TargetChooser.this.contexts) {
                    option.setSelection(selection);
                }
            }
        });
        return container;
    }

    protected void okPressed() {
        this.saveSelectedTargets();
        if (this.selectedTargets.isEmpty()) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Empty selection", (String)"You need to select at least one context");
        } else {
            super.okPressed();
        }
    }

    public List<TargetInformation> getSelectedTargets() {
        return this.selectedTargets;
    }

    private void saveSelectedTargets() {
        for (Button button : this.contexts) {
            if (!button.getSelection()) continue;
            this.selectedTargets.add(this.targets.get((Integer)button.getData()));
        }
    }

    private String findSource(EObject currentObject) {
        BinaryFunction lambda;
        Expression element;
        ICompositeNode node;
        String result = "";
        if (currentObject instanceof Content) {
            return result;
        }
        if (!DflFactoryUtils.isFunctionNamed(currentObject, "map")) {
            result = this.findSource(currentObject.eContainer());
        } else if (DflFactoryUtils.isFunctionNamed(currentObject, "map") && (node = NodeModelUtils.getNode((EObject)(element = (lambda = (BinaryFunction)currentObject).getElement()))) != null) {
            result = node.getText();
        }
        return result;
    }
}

