/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.graphical.view2code;

import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.xml.namespace.QName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.resource.XtextResource;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.dfl.dFL.ArrayElement;
import org.mule.tooling.dfl.dFL.BinaryFunction;
import org.mule.tooling.dfl.dFL.Body;
import org.mule.tooling.dfl.dFL.Content;
import org.mule.tooling.dfl.dFL.DFLFactory;
import org.mule.tooling.dfl.dFL.Document;
import org.mule.tooling.dfl.dFL.Expression;
import org.mule.tooling.dfl.dFL.Header;
import org.mule.tooling.dfl.dFL.Key;
import org.mule.tooling.dfl.dFL.KeyExpression;
import org.mule.tooling.dfl.dFL.KeyValuePair;
import org.mule.tooling.dfl.dFL.MultipleKeyValuePairObj;
import org.mule.tooling.dfl.dFL.ObjectElement;
import org.mule.tooling.dfl.dFL.ObjectElements;
import org.mule.tooling.dfl.dFL.ObjectPattern;
import org.mule.tooling.dfl.dFL.OutputDirective;
import org.mule.tooling.dfl.dFL.QuotedStringLiteral;
import org.mule.tooling.dfl.dFL.StringLiteral;
import org.mule.tooling.dfl.dFL.VariableReference;
import org.mule.tooling.dfl.ui.contentassist.DFLModelTypeResolverImpl;
import org.mule.tooling.dfl.ui.contentassist.model.IDFLComponentAware;
import org.mule.tooling.dfl.ui.contentassist.model.IDFLType;
import org.mule.tooling.dfl.ui.graphical.references.ISegment;
import org.mule.tooling.dfl.ui.graphical.references.properties.ModelSegmentProperty;
import org.mule.tooling.dfl.ui.graphical.references.properties.NodeSegmentProperty;
import org.mule.tooling.dfl.ui.graphical.util.GraphicalToolHelper;
import org.mule.tooling.dfl.ui.graphical.util.MappingNode;
import org.mule.tooling.dfl.ui.graphical.view2code.MapLambdaFinder;
import org.mule.tooling.dfl.ui.graphical.view2code.MappingApplier;
import org.mule.tooling.dfl.ui.graphical.view2code.MappingTargetFinder;
import org.mule.tooling.dfl.ui.graphical.view2code.TargetContainer;
import org.mule.tooling.dfl.ui.graphical.view2code.TargetFinderContext;
import org.mule.tooling.dfl.ui.graphical.view2code.TargetInformation;
import org.mule.tooling.dfl.ui.graphical.view2code.generation.DflFactoryUtils;
import org.mule.tooling.dfl.ui.input.IMetaDataProvider;
import org.mule.tooling.dfl.ui.module.IWeaveUIModule;
import org.mule.tooling.dfl.ui.module.MultipartModule;
import org.mule.tooling.dfl.ui.module.WeaveUIModuleManager;
import org.mule.tooling.dfl.ui.module.XmlUIModule;
import org.mule.tooling.dfl.ui.scafflod.ScaffoldingHelper;
import org.mule.tooling.dfl.util.DFLModelHelper;
import org.mule.tooling.metadata.utils.MetadataUtils;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeNode;

public class MappingUtils {
    public static boolean checkOverridingRoot(MappingNode targetMappingNode, XtextResource state) {
        Document document;
        if (targetMappingNode.isRoot() && !state.getContents().isEmpty() && (document = (Document)state.getContents().get(0)).getBody() != null) {
            Content content = document.getBody().getContent();
            Expression expression = content.getElement();
            if (expression instanceof MultipleKeyValuePairObj) {
                MultipleKeyValuePairObj root = (MultipleKeyValuePairObj)expression;
                ObjectPattern pattern = root.getPattern();
                if (pattern instanceof ObjectElements) {
                    return ((ObjectElements)pattern).getObjectElements().size() > 0;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    public static void configureOutputType(MappingNode targetMappingNode, XtextResource state, IMuleProject project) {
        MappingUtils.configureOutputType(targetMappingNode.getRootModel(), state, project);
    }

    public static void configureOutputType(MetadataType metadataType, XtextResource state, IMuleProject project) {
        Document document;
        EList contents = state.getContents();
        if (contents.isEmpty()) {
            document = ScaffoldingHelper.buildDocument();
            contents.add((Object)document);
        }
        document = (Document)contents.get(0);
        Optional lastOutputDirective = DFLModelHelper.getLastOutputDirective((Document)document);
        IWeaveUIModule weaveUiModule = WeaveUIModuleManager.getModuleByMetaDataModel(metadataType);
        if (!lastOutputDirective.isPresent()) {
            Body body = ScaffoldingHelper.buildBody(document);
            ScaffoldingHelper.buildContent(body);
            Header header = ScaffoldingHelper.buildHeader(body);
            OutputDirective outputDirective = ScaffoldingHelper.buildOutputDirective(header, weaveUiModule);
            ScaffoldingHelper.addOptions(outputDirective, weaveUiModule.getValuesForOptions(metadataType, DFLFactory.eINSTANCE.createOptions(), project));
            ScaffoldingHelper.buildHeaderSeparator(body);
        } else {
            OutputDirective outputDirective = (OutputDirective)lastOutputDirective.get();
            outputDirective.setMimeType(weaveUiModule.getMimeTypes().get(0));
            ScaffoldingHelper.addOptions(outputDirective, weaveUiModule.getValuesForOptions(metadataType, outputDirective.getOptions(), project));
        }
    }

    public static void autogenerateMapOperationsIfNecessary(XtextResource state, MappingNode sourceMappingNode, MappingNode targetMappingNode, IMetaDataProvider inputMetadataProvider, IMetaDataProvider outputMetadataProvider) throws Exception {
        int targetPreviousListsSize;
        LinkedList<ISegment> sourcePreviousLists = sourceMappingNode.getReference().getPreviousLists();
        LinkedList<ISegment> targetPreviousLists = targetMappingNode.getReference().getPreviousLists();
        int sourcePreviousListsSize = sourceMappingNode.isList() && sourceMappingNode.isComplexList() ? sourcePreviousLists.size() - 1 : sourcePreviousLists.size();
        int n = targetPreviousListsSize = targetMappingNode.isList() && !targetMappingNode.isTextElement() ? targetPreviousLists.size() - 1 : targetPreviousLists.size();
        if (sourcePreviousListsSize == targetPreviousListsSize) {
            int index = 0;
            while (index < sourcePreviousListsSize) {
                GraphicalTreeNode<?> targetNode;
                MappingNode newTargetMappingNode;
                ISegment sourceListSegment = sourcePreviousLists.get(index);
                ISegment targetListSegment = targetPreviousLists.get(index);
                GraphicalTreeNode<?> sourceNode = sourceListSegment.getProperty(NodeSegmentProperty.class).get().getNode();
                MappingNode newSourceMappingNode = new MappingNode(sourceNode);
                MappingTargetFinder mappingTargetFinder = new MappingTargetFinder(newSourceMappingNode, newTargetMappingNode = new MappingNode(targetNode = targetListSegment.getProperty(NodeSegmentProperty.class).get().getNode()));
                List<TargetInformation> targets = mappingTargetFinder.find(state);
                if (targets.size() == 1) {
                    TargetInformation targetInformation = targets.get(0);
                    TargetContainer targetContainer = targetInformation.getTargetContainer();
                    EObject objectContainer = targetContainer.getObjectContainer();
                    MapLambdaFinder mapLambdaFinder = new MapLambdaFinder(targetContainer.getStaticContext(), newSourceMappingNode);
                    BinaryFunction mapLambda = (BinaryFunction)mapLambdaFinder.doSwitch(objectContainer);
                    if (mapLambda == null) {
                        MappingApplier mappingApplier = new MappingApplier(newSourceMappingNode, newTargetMappingNode, inputMetadataProvider, outputMetadataProvider);
                        mappingApplier.apply(state, targetInformation);
                    }
                }
                ++index;
            }
        }
    }

    public static TargetInformation expandNodeIfNecessary(TargetInformation targetInformation, Document document) {
        TargetContainer currentTargetContainer = targetInformation.getTargetContainer();
        TargetFinderContext currentTargetContext = targetInformation.getTargetContext();
        Optional outputDirective = DFLModelHelper.getLastOutputDirective((Document)document);
        boolean isXml = MappingUtils.isOutputDefinedAsXml(outputDirective);
        LinkedList<ISegment> trace = currentTargetContext.getTrace();
        if (!(trace.isEmpty() || currentTargetContext.isLastSegment() && currentTargetContext.isLastLevelReached())) {
            ISegment lastSegment = trace.getLast();
            for (ObjectElement objectElement : currentTargetContainer.getElements()) {
                KeyValuePair keyValuePair;
                if (!(objectElement instanceof KeyValuePair) || !GraphicalToolHelper.compareKey((keyValuePair = (KeyValuePair)objectElement).getKey(), lastSegment.getQName())) continue;
                MultipleKeyValuePairObj newMultipleKeyValuePairObj = DFLFactory.eINSTANCE.createMultipleKeyValuePairObj();
                if (!isXml && lastSegment.getProperty(ModelSegmentProperty.class).get().getModel() instanceof ArrayType) {
                    DflFactoryUtils.ArrayWrapper newArray = DflFactoryUtils.createArray();
                    newArray.add((ArrayElement)newMultipleKeyValuePairObj);
                    keyValuePair.setValue((Expression)newArray.get());
                } else {
                    keyValuePair.setValue((Expression)newMultipleKeyValuePairObj);
                }
                currentTargetContainer = new TargetContainer((EObject)newMultipleKeyValuePairObj, currentTargetContainer.getContextVariables(), currentTargetContainer.getStaticContext());
                targetInformation = new TargetInformation(currentTargetContainer, currentTargetContext);
            }
        }
        return targetInformation;
    }

    public static TargetInformation buildTargetOutputStructure(TargetInformation targetInformation, Document document) {
        TargetContainer currentTargetContainer = targetInformation.getTargetContainer();
        TargetFinderContext currentTargetContext = targetInformation.getTargetContext();
        Optional outputDirective = DFLModelHelper.getLastOutputDirective((Document)document);
        boolean isXml = MappingUtils.isOutputDefinedAsXml(outputDirective);
        boolean isMixed = outputDirective.isPresent() && new MultipartModule().getMetadataFormat().stream().map(MetadataFormat::getValidMimeTypes).anyMatch(mts -> mts.contains(((OutputDirective)outputDirective.get()).getMimeType()));
        Optional<MetadataFormat> lastMetadataFormat = MappingUtils.findRootMetadataFormat(currentTargetContext);
        while (!currentTargetContext.isLastSegment()) {
            ISegment currentSegment = currentTargetContext.getCurrentSegment();
            Optional<ModelSegmentProperty> modelProperty = currentSegment.getProperty(ModelSegmentProperty.class);
            MetadataType currentModel = modelProperty.get().getModel();
            KeyValuePair keyValuePair = DFLFactory.eINSTANCE.createKeyValuePair();
            Key key = DFLFactory.eINSTANCE.createKey();
            StringLiteral keyLiteral = DFLFactory.eINSTANCE.createStringLiteral();
            QName qName = currentSegment.getQName();
            qName = ScaffoldingHelper.defineNamespace(document, qName);
            DFLModelHelper.assignNamespace((Key)key, (QName)qName);
            keyLiteral.setValue(DFLModelHelper.quoteIfNecessary((String)qName.getLocalPart()));
            key.setValue((KeyExpression)keyLiteral);
            keyValuePair.setKey(key);
            MultipleKeyValuePairObj object = DFLFactory.eINSTANCE.createMultipleKeyValuePairObj();
            Expression value = Optional.of(object).map(MappingUtils.wrapInArrayIfNecessary(isXml, currentModel)).map(MappingUtils.writeToMetadataFormatIfDifferentFromCurrent(isMixed, lastMetadataFormat, currentModel)).get();
            keyValuePair.setValue(value);
            if (MappingUtils.isCurrentMetadataFormatDifferentFromLast(lastMetadataFormat, currentModel) && MappingUtils.shouldWriteMimeType(isMixed, currentModel)) {
                lastMetadataFormat = Optional.ofNullable(currentModel.getMetadataFormat());
            }
            currentTargetContainer.addObject((EObject)keyValuePair, currentSegment);
            currentTargetContainer = new TargetContainer((EObject)object, currentTargetContainer.getContextVariables(), currentTargetContainer.getStaticContext());
            currentTargetContext.nextSegment();
        }
        return new TargetInformation(currentTargetContainer, currentTargetContext);
    }

    private static Function<Expression, Expression> writeToMetadataFormatIfDifferentFromCurrent(boolean isMixed, Optional<MetadataFormat> lastMetadataFormat, MetadataType currentModel) {
        return value -> {
            Expression result;
            if (MappingUtils.isCurrentMetadataFormatDifferentFromLast(lastMetadataFormat, currentModel) && MappingUtils.shouldWriteMimeType(isMixed, currentModel)) {
                String mimeTypeString = (String)currentModel.getMetadataFormat().getValidMimeTypes().iterator().next();
                QuotedStringLiteral mimeType = DflFactoryUtils.createStringLiteral(mimeTypeString);
                DflFactoryUtils.BinaryFunctionWrapper writeFunction = DflFactoryUtils.newWrappedBinaryFunction("write");
                writeFunction.setLeft((Expression)value);
                writeFunction.setRight((Expression)mimeType);
                result = writeFunction.get();
            } else {
                result = value;
            }
            return result;
        };
    }

    private static boolean shouldWriteMimeType(boolean isMixed, MetadataType currentModel) {
        return isMixed || MetadataUtils.getImplementationClass((MetadataType)currentModel) != null;
    }

    private static boolean isCurrentMetadataFormatDifferentFromLast(Optional<MetadataFormat> lastMetadataFormat, MetadataType currentModel) {
        return lastMetadataFormat.isPresent() && currentModel != null && !lastMetadataFormat.get().equals((Object)currentModel.getMetadataFormat());
    }

    private static Function<Expression, Expression> wrapInArrayIfNecessary(boolean isXml, MetadataType currentModel) {
        return object -> {
            Expression value;
            if (!isXml && currentModel instanceof ArrayType) {
                DflFactoryUtils.ArrayWrapper array = DflFactoryUtils.createArray();
                array.add((ArrayElement)object);
                value = array.get();
            } else {
                value = object;
            }
            return value;
        };
    }

    private static Optional<MetadataFormat> findRootMetadataFormat(TargetFinderContext currentTargetContext) {
        ISegment currentSegment = currentTargetContext.getCurrentSegment();
        if (currentSegment == null) {
            return Optional.empty();
        }
        return currentSegment.getProperty(NodeSegmentProperty.class).map(MappingUtils::findRootNode).map(GraphicalTreeNode::getModel).filter(MetadataType.class::isInstance).map(MetadataType.class::cast).map(MetadataType::getMetadataFormat);
    }

    private static GraphicalTreeNode<?> findRootNode(NodeSegmentProperty segment) {
        GraphicalTreeNode current = segment.getNode();
        while (current.getParent() != null) {
            current = current.getParent();
        }
        return current;
    }

    public static boolean compareSegments(List<ISegment> firstSegments, List<ISegment> secondSegments) {
        if (firstSegments.size() != secondSegments.size()) {
            return false;
        }
        boolean equals = true;
        int segmentIndex = 0;
        while (segmentIndex < firstSegments.size() && equals) {
            ISegment variableSegment = firstSegments.get(segmentIndex);
            ISegment canonicalSegment = secondSegments.get(segmentIndex);
            if (!variableSegment.getQName().equals(canonicalSegment.getQName())) {
                equals = false;
            }
            ++segmentIndex;
        }
        return equals;
    }

    public static void encloseContentInArray(Document document, IMetaDataProvider metadataProvider) {
        Content content = document.getBody().getContent();
        Expression expression = content.getElement();
        DFLModelTypeResolverImpl typeResolver = DFLModelTypeResolverImpl.create((EObject)expression, metadataProvider);
        IDFLType dflType = typeResolver.getReturnType((EObject)expression);
        if (!dflType.isArray()) {
            DflFactoryUtils.ArrayWrapper array = DflFactoryUtils.createArray();
            array.add((ArrayElement)expression);
            content.setElement((Expression)array.get());
        }
    }

    public static boolean isSameJavaClass(MetadataType sourceModel, MetadataType targetModel) {
        if (sourceModel == null || targetModel == null) {
            return false;
        }
        Optional sourceClassInformation = sourceModel.getAnnotation(ClassInformationAnnotation.class);
        Optional targetClassInformation = targetModel.getAnnotation(ClassInformationAnnotation.class);
        if (!sourceClassInformation.isPresent() || !targetClassInformation.isPresent()) {
            return false;
        }
        return ((ClassInformationAnnotation)sourceClassInformation.get()).getClassname().equals(((ClassInformationAnnotation)targetClassInformation.get()).getClassname());
    }

    public static boolean isOutputDefinedAsXml(Optional<OutputDirective> outputDirective) {
        return outputDirective.isPresent() && new XmlUIModule().getMimeTypes().contains(outputDirective.get().getMimeType());
    }

    public static boolean isObject(IDFLType type) {
        return type.isObject();
    }

    public static boolean isArrayOfObject(IDFLType type) {
        if (type instanceof IDFLComponentAware) {
            IDFLType elementType = ((IDFLComponentAware)((Object)type)).getType();
            return type.isArray() && elementType.isObject();
        }
        return false;
    }

    public static Optional<Object> getClassProperty(IDFLType type) {
        if (MappingUtils.isObject(type)) {
            return type.getSchemaValue("class");
        }
        if (MappingUtils.isArrayOfObject(type)) {
            IDFLComponentAware array = (IDFLComponentAware)((Object)type);
            return MappingUtils.getClassProperty(array.getType());
        }
        return Optional.empty();
    }

    public static boolean isPayloadReference(Expression expression) {
        if (expression instanceof VariableReference) {
            VariableReference variableReference = (VariableReference)expression;
            return "payload".equals(variableReference.getReference());
        }
        return false;
    }
}

