/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.graphical.view2code;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.resource.XtextResource;
import org.mule.tooling.dfl.dFL.Document;
import org.mule.tooling.dfl.ui.graphical.references.AbstractReference;
import org.mule.tooling.dfl.ui.graphical.references.ISegment;
import org.mule.tooling.dfl.ui.graphical.references.TreeReference;
import org.mule.tooling.dfl.ui.graphical.util.MappingNode;
import org.mule.tooling.dfl.ui.graphical.view2code.MappingUtils;
import org.mule.tooling.dfl.ui.graphical.view2code.MultipleTargetContainer;
import org.mule.tooling.dfl.ui.graphical.view2code.TargetContainer;
import org.mule.tooling.dfl.ui.graphical.view2code.TargetFinder;
import org.mule.tooling.dfl.ui.graphical.view2code.TargetFinderContext;
import org.mule.tooling.dfl.ui.graphical.view2code.TargetInformation;

public class MappingTargetFinder {
    private MappingNode sourceMappingNode;
    private MappingNode targetMappingNode;
    private boolean willOverwrite = false;

    public MappingTargetFinder(MappingNode targetMappingNode) {
        this(null, targetMappingNode);
    }

    public MappingTargetFinder(MappingNode sourceMappingNode, MappingNode targetMappingNode) {
        this.sourceMappingNode = sourceMappingNode;
        this.targetMappingNode = targetMappingNode;
    }

    public List<TargetInformation> find(XtextResource state) throws Exception {
        ArrayList listOfTargetInformation = Lists.newArrayList();
        if (!state.getContents().isEmpty()) {
            Document document = (Document)state.getContents().get(0);
            TargetFinderContext targetContext = new TargetFinderContext(this.targetMappingNode);
            TargetFinder targetFinder = new TargetFinder(targetContext, this);
            Object targetContainer = targetFinder.doSwitch((EObject)document);
            List<Object> targetContainers = Lists.newArrayList();
            if (((Optional)targetContainer).isPresent()) {
                if (((Optional)targetContainer).get() instanceof MultipleTargetContainer) {
                    targetContainers = this.findTargetContainer(Optional.ofNullable(this.sourceMappingNode), (TargetContainer)((Optional)targetContainer).get());
                    if (targetContainers.isEmpty()) {
                        targetContainers = this.flattenTargetContainers((TargetContainer)((Optional)targetContainer).get());
                    }
                } else {
                    targetContainers.add((TargetContainer)((Optional)targetContainer).get());
                }
            }
            for (TargetContainer targetContainer2 : targetContainers) {
                listOfTargetInformation.add(new TargetInformation(targetContainer2, targetContext));
            }
        }
        return listOfTargetInformation;
    }

    private List<TargetContainer> findTargetContainer(Optional<MappingNode> optionalSourceMappingNode, TargetContainer targetContainer) {
        ArrayList result = Lists.newArrayList();
        if (targetContainer instanceof MultipleTargetContainer) {
            List<Object> tempResult = Lists.newArrayList();
            List<TargetContainer> containers = ((MultipleTargetContainer)targetContainer).getContainers();
            for (TargetContainer currentContainerWrapper : containers) {
                tempResult = this.findTargetContainer(optionalSourceMappingNode, currentContainerWrapper);
                result.addAll(tempResult);
            }
        } else if (optionalSourceMappingNode.isPresent()) {
            TreeReference treeReference = optionalSourceMappingNode.get().getReference();
            LinkedList<ISegment> segments = treeReference.getSegments();
            segments.removeLast();
            Map<String, AbstractReference> contextVariables = targetContainer.getContextVariables();
            for (Map.Entry<String, AbstractReference> entry : contextVariables.entrySet()) {
                LinkedList<ISegment> variableSegments = entry.getValue().getSegments();
                if (!MappingUtils.compareSegments(variableSegments, segments)) continue;
                result.add(targetContainer);
            }
        } else {
            result.add(targetContainer);
        }
        return result;
    }

    private List<TargetContainer> flattenTargetContainers(TargetContainer targetContainer) {
        ArrayList result = Lists.newArrayList();
        if (targetContainer instanceof MultipleTargetContainer) {
            List<Object> tempResult = Lists.newArrayList();
            List<TargetContainer> containers = ((MultipleTargetContainer)targetContainer).getContainers();
            for (TargetContainer currentContainerWrapper : containers) {
                tempResult = this.flattenTargetContainers(currentContainerWrapper);
                result.addAll(tempResult);
            }
        } else {
            result.add(targetContainer);
        }
        return result;
    }

    public boolean isWillOverwrite() {
        return this.willOverwrite;
    }

    public void setWillOverwrite(boolean willOverwrite) {
        this.willOverwrite = willOverwrite;
    }
}

