/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.graphical.view2code;

import java.util.Optional;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.resource.XtextResource;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.tooling.dfl.dFL.As;
import org.mule.tooling.dfl.dFL.Content;
import org.mule.tooling.dfl.dFL.DFLFactory;
import org.mule.tooling.dfl.dFL.Document;
import org.mule.tooling.dfl.dFL.Expression;
import org.mule.tooling.dfl.dFL.IntersectionTypeExpression;
import org.mule.tooling.dfl.dFL.QuotedStringLiteral;
import org.mule.tooling.dfl.dFL.Schema;
import org.mule.tooling.dfl.dFL.SchemaElement;
import org.mule.tooling.dfl.dFL.SimpleSchemaElement;
import org.mule.tooling.dfl.dFL.TypeExpression;
import org.mule.tooling.dfl.dFL.TypeReference;
import org.mule.tooling.dfl.ui.contentassist.DFLModelTypeResolverImpl;
import org.mule.tooling.dfl.ui.contentassist.model.IDFLType;
import org.mule.tooling.dfl.ui.contentassist.model.types.DFLTypeFactory;
import org.mule.tooling.dfl.ui.graphical.util.MappingNode;
import org.mule.tooling.dfl.ui.graphical.view2code.MappingInformation;
import org.mule.tooling.dfl.ui.graphical.view2code.MappingUtils;
import org.mule.tooling.dfl.ui.graphical.view2code.TargetInformation;
import org.mule.tooling.dfl.ui.graphical.view2code.appliers.FactoryAppliers;
import org.mule.tooling.dfl.ui.graphical.view2code.generation.ActionHandler;
import org.mule.tooling.dfl.ui.input.IMetaDataProvider;
import org.mule.tooling.ui.modules.core.metadata.MetadataTypeHelper;

public class MappingApplier {
    private MappingNode sourceMappingNode;
    private MappingNode targetMappingNode;
    private IMetaDataProvider inputMetadataProvider;
    private IMetaDataProvider outputMetadataProvider;

    public MappingApplier(MappingNode sourceMappingNode, MappingNode targetMappingNode, IMetaDataProvider inputMetadataProvider, IMetaDataProvider outputMetadataProvider) {
        this.sourceMappingNode = sourceMappingNode;
        this.targetMappingNode = targetMappingNode;
        this.inputMetadataProvider = inputMetadataProvider;
        this.outputMetadataProvider = outputMetadataProvider;
    }

    public boolean apply(XtextResource state, TargetInformation targetInformation) {
        Content content;
        Expression rootExpression;
        DFLModelTypeResolverImpl typeResolver;
        IDFLType dflType;
        Document document = (Document)state.getContents().get(0);
        targetInformation = MappingUtils.expandNodeIfNecessary(targetInformation, document);
        targetInformation = MappingUtils.buildTargetOutputStructure(targetInformation, document);
        ActionHandler.handle(state, new MappingInformation(this.sourceMappingNode, this.targetMappingNode, targetInformation));
        MetadataType sourceModel = this.sourceMappingNode.getRootModel();
        MetadataType sourceResolvedModel = MetadataTypeHelper.resolveModel((MetadataType)sourceModel);
        MetadataType targetType = this.targetMappingNode.getRootModel();
        MetadataType targetResolvedModel = MetadataTypeHelper.resolveModel((MetadataType)targetType);
        if (MetadataFormat.JAVA.equals((Object)targetResolvedModel.getMetadataFormat()) && (MappingUtils.isObject(dflType = (typeResolver = DFLModelTypeResolverImpl.create((EObject)(rootExpression = (content = document.getBody().getContent()).getElement()), this.inputMetadataProvider)).getReturnType((EObject)rootExpression)) || MappingUtils.isArrayOfObject(dflType))) {
            FactoryAppliers.AsApplier applier;
            boolean isJavaPojo;
            Optional<Object> classValue = MappingUtils.getClassProperty(dflType);
            boolean isPayloadReference = MappingUtils.isPayloadReference(rootExpression);
            boolean isSameJavaClass = MappingUtils.isSameJavaClass(sourceResolvedModel, targetResolvedModel);
            boolean bl = isJavaPojo = targetResolvedModel.getAnnotation(ClassInformationAnnotation.class).isPresent() && !((ClassInformationAnnotation)targetResolvedModel.getAnnotation(ClassInformationAnnotation.class).get()).isMap();
            if (!classValue.isPresent() && isJavaPojo && (!isSameJavaClass || isSameJavaClass && !isPayloadReference) && (applier = FactoryAppliers.getAsApplier(content, rootExpression, dflType)) != null) {
                applier.initialize();
                As as = DFLFactory.eINSTANCE.createAs();
                TypeExpression type = DFLFactory.eINSTANCE.createTypeExpression();
                TypeReference simpleType = DFLFactory.eINSTANCE.createTypeReference();
                Schema schema = DFLFactory.eINSTANCE.createSchema();
                SimpleSchemaElement schemaElement = DFLFactory.eINSTANCE.createSimpleSchemaElement();
                QuotedStringLiteral classLiteral = DFLFactory.eINSTANCE.createQuotedStringLiteral();
                targetResolvedModel.getAnnotation(ClassInformationAnnotation.class).ifPresent(arg_0 -> MappingApplier.lambda$0(classLiteral, (SchemaElement)schemaElement, schema, simpleType, type, as, applier, arg_0));
            }
        }
        if (targetType instanceof ArrayType && this.isValidElement(targetResolvedModel)) {
            MappingUtils.encloseContentInArray(document, this.inputMetadataProvider);
        }
        return true;
    }

    private boolean isValidElement(MetadataType metadataType) {
        return !metadataType.getMetadataFormat().equals((Object)MetadataFormat.XML);
    }

    private static /* synthetic */ void lambda$0(QuotedStringLiteral quotedStringLiteral, SchemaElement schemaElement, Schema schema, TypeReference typeReference, TypeExpression typeExpression, As as, FactoryAppliers.AsApplier asApplier, ClassInformationAnnotation typeIdAnnotation) {
        String className = typeIdAnnotation.getClassname();
        quotedStringLiteral.setValue("\"" + className + "\"");
        schemaElement.setName("class");
        schemaElement.setValue((Expression)quotedStringLiteral);
        schema.getElements().add((Object)schemaElement);
        typeReference.setFullQualifiedName(DFLTypeFactory.ANY_OBJECT.getName());
        typeReference.setSchema(schema);
        IntersectionTypeExpression intersectionType = DFLFactory.eINSTANCE.createIntersectionTypeExpression();
        intersectionType.getTypes().add((Object)typeReference);
        typeExpression.getTypes().add((Object)intersectionType);
        as.setElement(asApplier.getExpression());
        as.setType(typeExpression);
        asApplier.apply(as);
    }
}

