/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.graphical.view2code;

import java.util.LinkedList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.mule.tooling.dfl.dFL.BinaryFunction;
import org.mule.tooling.dfl.dFL.ClojureOperator;
import org.mule.tooling.dfl.dFL.ClojureOperatorOrOrExpression;
import org.mule.tooling.dfl.dFL.Content;
import org.mule.tooling.dfl.dFL.EnclosedExpression;
import org.mule.tooling.dfl.dFL.EnclosedObjectElement;
import org.mule.tooling.dfl.dFL.Expression;
import org.mule.tooling.dfl.dFL.KeyValuePair;
import org.mule.tooling.dfl.dFL.MultipleKeyValuePairObj;
import org.mule.tooling.dfl.dFL.ObjectElement;
import org.mule.tooling.dfl.dFL.ObjectElements;
import org.mule.tooling.dfl.dFL.ObjectPattern;
import org.mule.tooling.dfl.dFL.SingleKeyValuePairObj;
import org.mule.tooling.dfl.dFL.VariableReference;
import org.mule.tooling.dfl.dFL.util.DFLSwitch;
import org.mule.tooling.dfl.ui.graphical.model.GraphicalEvaluationContext;
import org.mule.tooling.dfl.ui.graphical.references.CodeReference;
import org.mule.tooling.dfl.ui.graphical.references.ISegment;
import org.mule.tooling.dfl.ui.graphical.util.MappingNode;
import org.mule.tooling.dfl.ui.graphical.view2code.MappingUtils;

public class MapLambdaFinder
extends DFLSwitch<BinaryFunction> {
    private MappingNode mappingNode;
    private GraphicalEvaluationContext context;

    public MapLambdaFinder(GraphicalEvaluationContext context, MappingNode mappingNode) {
        this.context = context;
        this.mappingNode = mappingNode;
    }

    public BinaryFunction caseContent(Content object) {
        Expression expression = object.getElement();
        BinaryFunction mapLamba = null;
        if (expression != null) {
            mapLamba = (BinaryFunction)this.doSwitch((EObject)expression);
        }
        return mapLamba;
    }

    public BinaryFunction caseMultipleKeyValuePairObj(MultipleKeyValuePairObj object) {
        BinaryFunction mapLamba = null;
        ObjectPattern pattern = object.getPattern();
        if (pattern instanceof ObjectElements) {
            EList elements = ((ObjectElements)pattern).getObjectElements();
            for (ObjectElement objectElement : elements) {
                if (mapLamba != null) continue;
                mapLamba = (BinaryFunction)this.doSwitch((EObject)objectElement);
            }
        }
        return mapLamba;
    }

    public BinaryFunction caseKeyValuePair(KeyValuePair object) {
        return (BinaryFunction)this.doSwitch((EObject)object.getValue());
    }

    public BinaryFunction caseSingleKeyValuePairObj(SingleKeyValuePairObj object) {
        return (BinaryFunction)this.doSwitch((EObject)object.getObjectElement());
    }

    public BinaryFunction caseBinaryFunction(BinaryFunction object) {
        block15: {
            String variableName;
            if (!(object.getFunctionName() instanceof VariableReference)) break block15;
            switch (variableName = ((VariableReference)object.getFunctionName()).getReference()) {
                case "++": {
                    BinaryFunction mapLamba;
                    Expression left = object.getElement();
                    ClojureOperatorOrOrExpression function = object.getFunction();
                    if (function.getOrExpression() != null) {
                        Expression right = function.getOrExpression();
                        mapLamba = (BinaryFunction)this.doSwitch((EObject)left);
                        if (mapLamba == null) {
                            mapLamba = (BinaryFunction)this.doSwitch((EObject)right);
                        }
                    } else {
                        ClojureOperator right = function.getClojureOperator();
                        mapLamba = (BinaryFunction)this.doSwitch((EObject)left);
                        if (mapLamba == null) {
                            mapLamba = (BinaryFunction)this.doSwitch((EObject)right);
                        }
                    }
                    return mapLamba;
                }
                case "map": {
                    BinaryFunction mapLamba = null;
                    CodeReference codeReference = CodeReference.of(this.context, (EObject)object.getElement());
                    LinkedList<ISegment> sourceSegments = this.mappingNode.getReference().getSegments();
                    LinkedList<ISegment> codeSegments = codeReference.getSegments();
                    boolean isSourceBeingUseInMap = MappingUtils.compareSegments(sourceSegments, codeSegments);
                    if (isSourceBeingUseInMap) {
                        mapLamba = object;
                    }
                    return mapLamba;
                }
            }
        }
        return (BinaryFunction)super.caseBinaryFunction(object);
    }

    public BinaryFunction caseEnclosedExpression(EnclosedExpression object) {
        if (object.getExpression() instanceof Expression) {
            return (BinaryFunction)this.doSwitch((EObject)object.getExpression());
        }
        return null;
    }

    public BinaryFunction caseEnclosedObjectElement(EnclosedObjectElement object) {
        if (object.getExpression() instanceof Expression) {
            return (BinaryFunction)this.doSwitch((EObject)object.getExpression());
        }
        return null;
    }
}

