/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.graphical.view2code;

import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.mule.tooling.dfl.ui.graphical.view2code.actions.ITargetAction;

public class ActionChooser
extends Dialog {
    private Button selectedRadioButton;
    private List<ITargetAction> actions;
    private ITargetAction selectedAction;

    protected ActionChooser(Shell parentShell, List<ITargetAction> actions) {
        super(parentShell);
        this.actions = actions;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Action selection");
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayoutFactory.fillDefaults().numColumns(1).margins(5, 10).applyTo(container);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)container);
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ActionChooser.this.selectedRadioButton = (Button)event.widget;
            }
        };
        int index = 0;
        Group group = new Group(container, 4);
        for (ITargetAction actions : this.actions) {
            GridLayoutFactory.fillDefaults().applyTo((Composite)group);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)group);
            Button radioButton = new Button((Composite)group, 16);
            radioButton.setData((Object)index);
            radioButton.setText(actions.getDescription());
            radioButton.addSelectionListener((SelectionListener)selectionListener);
            if (index == 0) {
                radioButton.setSelection(true);
                this.selectedRadioButton = radioButton;
            }
            ++index;
        }
        return container;
    }

    protected void okPressed() {
        if (this.selectedRadioButton == null) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Empty selection", (String)"You need to select one action");
        } else {
            this.selectedAction = this.actions.get((Integer)this.selectedRadioButton.getData());
            super.okPressed();
        }
    }

    public ITargetAction getSelectedAction() {
        return this.selectedAction;
    }
}

