/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.graphical.util;

import java.util.List;
import java.util.Optional;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.mule.tooling.dfl.ui.graphical.model.ITreeGraphicalMapping;
import org.mule.tooling.dfl.ui.graphical.model.containers.LambdaMappingInfo;
import org.mule.tooling.metadata.utils.MetadataUtils;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeNode;

public final class TreeViewerHelper {
    private TreeViewerHelper() {
    }

    public static Optional<GraphicalTreeNode<?>> getSelectedNode(ISelectionProvider viewer) {
        IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
        if (selection.getFirstElement() instanceof GraphicalTreeNode) {
            GraphicalTreeNode node = (GraphicalTreeNode)selection.getFirstElement();
            return Optional.of(node);
        }
        return Optional.empty();
    }

    public static int getInitialYAxisFromItem(TreeViewer treeViewer, TreeItem treeItem, Rectangle treeClientArea) {
        Tree tree = treeViewer.getTree();
        return treeItem.getBounds((int)0).y - treeClientArea.y + tree.getHeaderHeight();
    }

    public static int getMiddleYAxisFromItem(TreeViewer treeViewer, TreeItem treeItem, int treeItemHeight, Rectangle treeClientArea) {
        Tree tree = treeViewer.getTree();
        return (int)((double)TreeViewerHelper.getInitialYAxisFromItem(treeViewer, treeItem, treeClientArea) + (double)treeItemHeight * 0.5 + (double)(2 * tree.getGridLineWidth()));
    }

    public static int calculateHeight(TreeItem item, int itemHeight) {
        int contextSize = itemHeight;
        if (item.getExpanded()) {
            TreeItem[] treeItemArray = item.getItems();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem child = treeItemArray[n2];
                contextSize += TreeViewerHelper.calculateHeight(child, itemHeight);
                ++n2;
            }
        }
        return contextSize;
    }

    public static TreeItem[] resolvePayloadItems(TreeItem payloadItem) {
        return payloadItem.getItems();
    }

    public static Optional<TreeItem> findSelectedContext(TreeItem[] selection, List<ITreeGraphicalMapping> mappingsList) {
        TreeItem shortestItem = null;
        int shortestPath = Integer.MAX_VALUE;
        for (ITreeGraphicalMapping mapping : mappingsList) {
            if (!(mapping.getSourceElement() instanceof LambdaMappingInfo)) continue;
            TreeItem item = mapping.getLeftItem().getTreeItem();
            int currentPath = 0;
            if (selection == null || selection.length == 0) continue;
            TreeItem currentItem = selection[0];
            while (currentItem != null && !currentItem.equals(item)) {
                currentItem = currentItem.getParentItem();
                ++currentPath;
            }
            if (shortestPath <= currentPath || currentItem == null || !currentItem.equals(item)) continue;
            shortestItem = item;
            shortestPath = currentPath;
        }
        return Optional.ofNullable(shortestItem);
    }

    public static boolean checkXMLType(TreeItem item) {
        GraphicalTreeNode node;
        boolean isXML = false;
        if (item != null && item.getData() instanceof GraphicalTreeNode && MetadataUtils.isXmlMetadata((Object)(node = (GraphicalTreeNode)item.getData()).getModel())) {
            isXML = true;
        }
        return isXML;
    }

    public static int calculateInitialSegment(TreeItem item) {
        GraphicalTreeNode node;
        int initialSegment = 0;
        if (item != null && item.getData() instanceof GraphicalTreeNode && MetadataUtils.isXmlMetadata((Object)(node = (GraphicalTreeNode)item.getData()).getModel())) {
            initialSegment = 1;
        }
        return initialSegment;
    }

    public static boolean isVisible(TreeItem item) {
        return item.getParentItem() == null || item.getParentItem().getExpanded();
    }

    public static boolean isContained(TreeItem root, TreeItem item) {
        boolean result = false;
        if (root != null) {
            result = root.equals(item);
            TreeItem[] treeItemArray = root.getItems();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem currentItem = treeItemArray[n2];
                result |= TreeViewerHelper.isContained(currentItem, item);
                ++n2;
            }
        }
        return result;
    }

    public static Font getFont(Tree tree, int style) {
        Display display = Display.getCurrent();
        FontDescriptor fontDescriptor = FontDescriptor.createFrom((Font)tree.getFont());
        return fontDescriptor.setStyle(style).createFont((Device)display);
    }

    public static TreeItem getNearestVisibleParentItem(TreeItem treeItem) {
        TreeItem candidate = treeItem;
        TreeItem currentItem = treeItem;
        while (currentItem.getParentItem() != null) {
            if (!currentItem.getParentItem().getExpanded()) {
                candidate = currentItem.getParentItem();
            }
            currentItem = currentItem.getParentItem();
        }
        return candidate;
    }
}

