/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.graphical.util;

import java.util.Collection;
import javax.xml.namespace.QName;
import org.mule.metadata.api.model.AttributeFieldType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.SimpleType;
import org.mule.tooling.dfl.ui.graphical.view2code.MappingUtils;
import org.mule.tooling.dfl.ui.metadata.RecursionHandler;
import org.mule.tooling.dfl.ui.metadata.RecursiveField;
import org.mule.tooling.ui.modules.core.metadata.MetadataTypeHelper;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeNode;

public class StructureManager {
    public static boolean compareObjects(GraphicalTreeNode<?> source, GraphicalTreeNode<?> target) {
        MetadataType sourceModel = StructureManager.getModel(source);
        MetadataType targetModel = StructureManager.getModel(target);
        RecursionHandler sourceRecursionHandler = new RecursionHandler();
        RecursionHandler targetRecursionHandler = new RecursionHandler();
        return StructureManager.compareStructures(sourceModel, targetModel, sourceRecursionHandler, targetRecursionHandler);
    }

    protected static MetadataType getModel(GraphicalTreeNode<?> source) {
        Object model = source.getModel();
        return model instanceof ObjectFieldType ? ((ObjectFieldType)model).getValue() : (MetadataType)model;
    }

    protected static boolean isXml(MetadataType targetModel) {
        return MetadataFormat.XML.equals((Object)targetModel.getMetadataFormat());
    }

    public static int calculateHash(MetadataType metadataType) {
        RecursionHandler recursionHandler = new RecursionHandler();
        return StructureManager.calculateHash(metadataType, recursionHandler);
    }

    public static int calculateHash(MetadataType metadataType, RecursionHandler recursionHandler) {
        int hashValue = 1;
        if (metadataType instanceof ObjectType) {
            Collection fields = ((ObjectType)metadataType).getFields();
            int numberOfFields = fields.size();
            hashValue = 31 * hashValue + numberOfFields;
            for (ObjectFieldType objectFieldType : fields) {
                int innerHashValue;
                MetadataType objectFieldMetadataType;
                QName qName = MetadataTypeHelper.toQName((ObjectFieldType)objectFieldType);
                RecursiveField recursiveField = recursionHandler.newField(qName, objectFieldMetadataType = objectFieldType.getValue());
                if (recursionHandler.isRecursiveStructured(recursiveField)) continue;
                recursionHandler.add(recursiveField);
                if (recursionHandler.getMetadataTypeHash(objectFieldMetadataType) != null) {
                    innerHashValue = recursionHandler.getMetadataTypeHash(objectFieldMetadataType);
                } else {
                    innerHashValue = StructureManager.calculateHash((MetadataType)objectFieldType, recursionHandler);
                    if (!(objectFieldMetadataType instanceof SimpleType)) {
                        recursionHandler.store(objectFieldMetadataType, innerHashValue);
                    }
                }
                hashValue = 31 * hashValue + innerHashValue;
                recursionHandler.remove(recursiveField);
            }
        } else if (metadataType instanceof ObjectFieldType) {
            ObjectFieldType objectFieldType = (ObjectFieldType)metadataType;
            QName fieldName = MetadataTypeHelper.toQName((ObjectFieldType)objectFieldType);
            hashValue = 31 * hashValue + (fieldName == null ? 0 : fieldName.hashCode());
            MetadataType objectFieldMetadataType = objectFieldType.getValue();
            int innerHashValue = StructureManager.calculateHash(objectFieldMetadataType, recursionHandler);
            hashValue = 31 * hashValue + innerHashValue;
            return hashValue;
        }
        return hashValue;
    }

    public static boolean compareStructures(MetadataType sourceType, MetadataType targetType, RecursionHandler sourceRecursionHandler, RecursionHandler targetRecursionHandler) {
        boolean sameStructure = false;
        if (MetadataFormat.JAVA.equals((Object)sourceType.getMetadataFormat()) && MetadataFormat.JAVA.equals((Object)targetType.getMetadataFormat())) {
            sameStructure = MappingUtils.isSameJavaClass(sourceType, targetType);
        } else if (sourceType instanceof ObjectType && targetType instanceof ObjectType) {
            Collection sourceFields = ((ObjectType)sourceType).getFields();
            Collection targetFields = ((ObjectType)targetType).getFields();
            boolean bl = sameStructure = sourceFields.size() == targetFields.size();
            if (sameStructure) {
                for (ObjectFieldType sourceField : sourceFields) {
                    MetadataType sourceMetaDataModel;
                    QName sourceQName = MetadataTypeHelper.toQName((ObjectFieldType)sourceField);
                    RecursiveField sourceRecursiveField = sourceRecursionHandler.newField(sourceQName, sourceMetaDataModel = sourceField.getValue());
                    if (sourceRecursionHandler.isRecursiveStructured(sourceRecursiveField)) continue;
                    sourceRecursionHandler.add(sourceRecursiveField);
                    boolean isEqual = false;
                    for (ObjectFieldType targetField : targetFields) {
                        MetadataType targetMetaDataModel;
                        QName targetQName = MetadataTypeHelper.toQName((ObjectFieldType)targetField);
                        RecursiveField targetRecursiveField = targetRecursionHandler.newField(targetQName, targetMetaDataModel = targetField.getValue());
                        if (targetRecursionHandler.isRecursiveStructured(targetRecursiveField)) continue;
                        targetRecursionHandler.add(targetRecursiveField);
                        isEqual = sourceMetaDataModel == targetMetaDataModel ? true : StructureManager.compareStructures((MetadataType)sourceField, (MetadataType)targetField, sourceRecursionHandler, targetRecursionHandler);
                        targetRecursionHandler.remove(targetRecursiveField);
                        if (isEqual) break;
                    }
                    sourceRecursionHandler.remove(sourceRecursiveField);
                    if (isEqual) continue;
                    sameStructure = false;
                    break;
                }
            }
        } else if (sourceType instanceof SimpleType && targetType instanceof SimpleType) {
            sameStructure = sourceType.getClass().equals(targetType.getClass());
        } else if (sourceType instanceof ObjectFieldType && targetType instanceof ObjectFieldType) {
            ObjectFieldType sourceField = (ObjectFieldType)sourceType;
            ObjectFieldType targetField = (ObjectFieldType)targetType;
            QName sourceQName = MetadataTypeHelper.toQName((ObjectFieldType)sourceField);
            QName targetQName = MetadataTypeHelper.toQName((ObjectFieldType)targetField);
            MetadataType sourceFieldModel = sourceField.getValue();
            MetadataType targetFieldModel = targetField.getValue();
            sameStructure = sourceQName.equals(targetQName) && StructureManager.compareStructures(sourceFieldModel, targetFieldModel, sourceRecursionHandler, targetRecursionHandler);
        } else if (sourceType instanceof AttributeFieldType && targetType instanceof AttributeFieldType) {
            AttributeFieldType sourceField = (AttributeFieldType)sourceType;
            AttributeFieldType targetField = (AttributeFieldType)targetType;
            QName sourceQName = MetadataTypeHelper.toQName((AttributeFieldType)sourceField);
            QName targetQName = MetadataTypeHelper.toQName((AttributeFieldType)targetField);
            MetadataType sourceFieldModel = sourceField.getValue();
            MetadataType targetFieldModel = targetField.getValue();
            sameStructure = sourceQName.equals(targetQName) && StructureManager.compareStructures(sourceFieldModel, targetFieldModel, sourceRecursionHandler, targetRecursionHandler);
        }
        return sameStructure;
    }
}

