/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.graphical.util;

import java.util.Collection;
import java.util.Optional;
import org.mule.metadata.MetadataFormats;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.BooleanType;
import org.mule.metadata.api.model.DateTimeType;
import org.mule.metadata.api.model.DateType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.NumberType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.StringType;
import org.mule.tooling.client.metadata.MetadataFactory;
import org.mule.tooling.dfl.ui.graphical.references.SegmentUtils;
import org.mule.tooling.dfl.ui.graphical.references.TreeReference;
import org.mule.tooling.dfl.ui.graphical.references.properties.FieldSegmentProperty;
import org.mule.tooling.dfl.ui.graphical.references.properties.ModelSegmentProperty;
import org.mule.tooling.dfl.ui.graphical.references.properties.XMLRepeatedElementProperty;
import org.mule.tooling.ui.modules.core.metadata.MetadataTypeHelper;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeNode;

public class MappingNode {
    protected GraphicalTreeNode<?> node;
    protected final boolean isRoot;
    protected final TreeReference reference;
    protected final RootInformation rootInformation;

    public MappingNode(GraphicalTreeNode<?> node) {
        this.isRoot = node.getParent() == null;
        this.reference = TreeReference.of(node);
        this.rootInformation = new RootInformation(this.reference);
        this.node = node;
    }

    protected MappingNode(TreeReference reference, boolean isRoot, RootInformation rootInformation) {
        this.isRoot = isRoot;
        this.reference = reference;
        this.rootInformation = rootInformation;
    }

    public TreeReference getReference() {
        return this.reference;
    }

    public MetadataType getMetadataType() {
        return this.reference.getMetadataType();
    }

    public boolean isVirtual() {
        return false;
    }

    public boolean is(MetadataType dataType) {
        return this.reference.getMetadataType().getClass().isAssignableFrom(dataType.getClass());
    }

    public boolean isObject() {
        return this.reference.getMetadataType() instanceof ObjectType && !this.isRepeatedKeyValuePair();
    }

    public boolean isRepeatedObject() {
        return this.reference.getMetadataType() instanceof ObjectType && this.isRepeatedKeyValuePair();
    }

    private boolean isRepeatedKeyValuePair() {
        return this.reference.getSegments().getLast().getProperty(XMLRepeatedElementProperty.class).isPresent();
    }

    public static boolean isRepeatedKeyValuePair(MetadataType dataType) {
        return dataType instanceof ObjectFieldType && ((ObjectFieldType)dataType).isRepeated();
    }

    public boolean isString() {
        return this.reference.getMetadataType() instanceof StringType;
    }

    public boolean isNumber() {
        return this.reference.getMetadataType() instanceof NumberType;
    }

    public boolean isBoolean() {
        return this.reference.getMetadataType() instanceof BooleanType;
    }

    public boolean isDate() {
        return this.reference.getMetadataType() instanceof DateType;
    }

    public boolean isDateTime() {
        return this.reference.getMetadataType() instanceof DateTimeType;
    }

    public boolean isList() {
        return this.reference.getMetadataType() instanceof ArrayType || this.isRepeatedKeyValuePair();
    }

    public boolean isTextElement() {
        return SegmentUtils.isTextElement(this.reference.getSegments().getLast());
    }

    public boolean isComplexList() {
        boolean isComplexList = false;
        if (this.isList()) {
            isComplexList = this.hasChildren();
        }
        return isComplexList;
    }

    public boolean hasChildren() {
        return this.numberOfChildren() > 0;
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public Optional<GraphicalTreeNode<?>> getNode() {
        return Optional.ofNullable(this.node);
    }

    public MetadataType getRootModel() {
        return this.getRootInformation().getModel();
    }

    public boolean matchRoot(MetadataFormat dataType) {
        return dataType.equals((Object)this.getRootInformation().getModel().getMetadataFormat());
    }

    private RootInformation getRootInformation() {
        return this.rootInformation;
    }

    private MetadataType resolveModel() {
        Optional<ModelSegmentProperty> modelProperty = this.reference.getSegments().getLast().getProperty(ModelSegmentProperty.class);
        return MetadataTypeHelper.resolveModel((MetadataType)modelProperty.get().getModel());
    }

    private int numberOfChildren() {
        int numberOfChildren = 0;
        MetadataType elementModel = this.resolveModel();
        if (elementModel instanceof ObjectType) {
            Collection fields = ((ObjectType)elementModel).getFields();
            for (ObjectFieldType field : fields) {
                if ("text()".equals(field.getKey().getName().getLocalPart())) continue;
                ++numberOfChildren;
            }
        }
        return numberOfChildren;
    }

    public boolean isRequired() {
        return this.getReference().getSegments().stream().map(s -> s.getProperty(FieldSegmentProperty.class)).filter(Optional::isPresent).map(Optional::get).allMatch(FieldSegmentProperty::isRequired);
    }

    public static boolean isUntyped(MappingNode mappingNode) {
        return mappingNode.matchRoot(MetadataFormats.XML) || mappingNode.matchRoot(MetadataFormats.CSV);
    }

    private static final class RootInformation {
        private MetadataType metadataType = MetadataFactory.undefined();

        public RootInformation(TreeReference reference) {
            Optional<ModelSegmentProperty> modelProperty = reference.getSegments().getFirst().getProperty(ModelSegmentProperty.class);
            if (modelProperty.isPresent()) {
                this.metadataType = modelProperty.get().getModel();
            }
        }

        public MetadataType getModel() {
            return this.metadataType;
        }
    }
}

