/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.graphical.util;

import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.tooling.dfl.ui.graphical.util.TreeViewerHelper;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeNode;

public class GraphicalTreeItem {
    private TreeItem treeItem;
    private boolean isReachable;
    private boolean lazyComputation;
    private GraphicalTreeNode<?> node;
    private static final GraphicalTreeItem EMPTY = new EmptyGraphicalTreeItem();
    public static final GraphicalTreeItem NULL = new EmptyGraphicalTreeItem();

    private GraphicalTreeItem() {
    }

    public TreeItem getTreeItem() {
        return this.treeItem;
    }

    public GraphicalTreeNode<?> getNode() {
        return this.node;
    }

    public int getInitialYAxis(Rectangle treeClientArea) {
        Tree tree = this.treeItem.getParent();
        return this.treeItem.getBounds((int)0).y - treeClientArea.y + tree.getHeaderHeight();
    }

    public int getMiddleYAxis(int leftItemHeight, Rectangle treeClientArea) {
        return this.getMiddleYAxis(this.getInitialYAxis(treeClientArea), leftItemHeight);
    }

    public int getMiddleYAxis(int initialYAxis, int leftItemHeight) {
        Tree tree = this.treeItem.getParent();
        return (int)((double)initialYAxis + (double)leftItemHeight * 0.5 + (double)(2 * tree.getGridLineWidth()));
    }

    public void findTextXmlNode() {
        TreeItem[] items;
        TreeItem[] treeItemArray = items = this.treeItem.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            ObjectFieldType field;
            GraphicalTreeNode node;
            TreeItem childItem = treeItemArray[n2];
            if (childItem.getData() instanceof GraphicalTreeNode && (node = (GraphicalTreeNode)childItem.getData()).getModel() instanceof ObjectFieldType && "text()".equals((field = (ObjectFieldType)node.getModel()).getKey().getName().getLocalPart())) {
                this.treeItem = childItem;
            }
            ++n2;
        }
    }

    public boolean isReachable() {
        return this.isReachable;
    }

    public boolean isDisposed() {
        return this.treeItem.isDisposed();
    }

    public boolean isNodeAssigned(GraphicalTreeNode<?> node) {
        return this.treeItem.getData() == node;
    }

    public void computeVisibleItem() {
        if (!this.lazyComputation) {
            TreeItem prevTreeItem = this.treeItem;
            this.treeItem = TreeViewerHelper.getNearestVisibleParentItem(this.treeItem);
            this.isReachable = this.isReachable && prevTreeItem == this.treeItem;
            this.lazyComputation = true;
        }
    }

    public static GraphicalTreeItem of(TreeItem treeItem, GraphicalTreeNode<?> node, boolean isReachable) {
        GraphicalTreeItem graphicalTreeItem = new GraphicalTreeItem();
        graphicalTreeItem.node = node;
        graphicalTreeItem.treeItem = treeItem;
        graphicalTreeItem.isReachable = isReachable;
        return graphicalTreeItem;
    }

    public static GraphicalTreeItem empty() {
        return EMPTY;
    }

    private static final class EmptyGraphicalTreeItem
    extends GraphicalTreeItem {
        @Override
        public boolean isDisposed() {
            return true;
        }

        @Override
        public TreeItem getTreeItem() {
            return null;
        }
    }
}

