/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.graphical.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import javax.xml.namespace.QName;
import org.eclipse.swt.widgets.TreeItem;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.AttributeFieldType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.SimpleType;
import org.mule.tooling.dfl.dFL.Key;
import org.mule.tooling.dfl.ui.graphical.model.containers.IMappingInfo;
import org.mule.tooling.dfl.ui.graphical.model.containers.IMappingReference;
import org.mule.tooling.dfl.ui.graphical.references.AbstractReference;
import org.mule.tooling.dfl.ui.graphical.references.ISegment;
import org.mule.tooling.dfl.ui.graphical.util.GraphicalTreeItem;
import org.mule.tooling.dfl.ui.graphical.util.Inflector;
import org.mule.tooling.dfl.ui.graphical.util.TreeViewerHelper;
import org.mule.tooling.dfl.ui.graphical.view2code.TargetContainer;
import org.mule.tooling.dfl.ui.graphical.view2code.TargetInformation;
import org.mule.tooling.dfl.ui.input.CustomResourceTreeViewer;
import org.mule.tooling.dfl.util.DFLModelHelper;
import org.mule.tooling.ui.modules.core.metadata.MetadataTypeHelper;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeNode;

public final class GraphicalToolHelper {
    private static final String VARIABLE_PREFIX_FOR_INVALID_NAMES = "v";
    private static final QName PAYLOAD = new QName("payload");
    private static final QName ATTRIBUTES = new QName("attributes");
    private static final QName VARS = new QName("vars");

    private GraphicalToolHelper() {
    }

    public static String resolveVariableName(TargetInformation targetInformation, AbstractReference reference) {
        String lastSegmentName = reference.getSegments().getLast().getQName().getLocalPart();
        lastSegmentName = DFLModelHelper.removeSpecialCharacters((String)lastSegmentName);
        lastSegmentName = Inflector.INSTANCE.lowerCamelCase(lastSegmentName, new char[0]);
        Object variableName = Inflector.INSTANCE.singularize(lastSegmentName = DFLModelHelper.removeQuotes((String)lastSegmentName));
        if (DFLModelHelper.requiresQuotes((String)variableName)) {
            variableName = VARIABLE_PREFIX_FOR_INVALID_NAMES + (String)variableName;
        }
        return GraphicalToolHelper.checkVariableName(targetInformation, (String)variableName);
    }

    public static boolean compareNode(GraphicalTreeNode<?> node, QName qName) {
        boolean matchElement = false;
        if (node != null) {
            matchElement = GraphicalToolHelper.checkNode(node, qName);
        }
        return matchElement;
    }

    public static boolean compareKey(Key key, QName qName) {
        return DFLModelHelper.toQName((Key)key).equals(qName);
    }

    public static TreeItem findRootItem(TreeItem[] items, IMappingInfo mappingContainer) {
        ISegment firstSegment;
        QName qName;
        AbstractReference reference;
        LinkedList<ISegment> segments;
        TreeItem result = items[0];
        Optional<? extends AbstractReference> mappingReference = mappingContainer.getReference();
        if (mappingReference.isPresent() && !(segments = (reference = mappingReference.get()).getSegments()).isEmpty() && (VARS.equals(qName = (firstSegment = segments.getFirst()).getQName()) || ATTRIBUTES.equals(qName))) {
            result = GraphicalToolHelper.findTreeItem(items, segments);
        }
        return result;
    }

    public static boolean isPayloadReference(IMappingReference mappingContainer) {
        AbstractReference reference;
        LinkedList<ISegment> segments;
        boolean isPayloadReference = true;
        Optional<? extends AbstractReference> mappingReference = mappingContainer.getReference();
        if (mappingReference.isPresent() && !(segments = (reference = mappingReference.get()).getSegments()).isEmpty()) {
            ISegment currentSegment = segments.getFirst();
            QName qName = currentSegment.getQName();
            isPayloadReference = PAYLOAD.equals(qName);
        }
        return isPayloadReference;
    }

    public static boolean checkXMLType(IMappingReference mappingContainer, TreeItem[] items) {
        ISegment currentSegment;
        QName qName;
        AbstractReference reference;
        LinkedList<ISegment> segments;
        TreeItem payloadItem = items[0];
        boolean result = TreeViewerHelper.checkXMLType(payloadItem);
        Optional<? extends AbstractReference> mappingReference = mappingContainer.getReference();
        if (mappingReference.isPresent() && !(segments = (reference = mappingReference.get()).getSegments()).isEmpty() && (VARS.equals(qName = (currentSegment = segments.getFirst()).getQName()) || ATTRIBUTES.equals(qName))) {
            result = false;
            segments.removeFirst();
            if (!segments.isEmpty()) {
                TreeItem variableItem = null;
                TreeItem[] treeItemArray = items;
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem treeItem = treeItemArray[n2];
                    if (GraphicalToolHelper.compareNode((GraphicalTreeNode)treeItem.getData(), qName)) {
                        variableItem = treeItem;
                    }
                    ++n2;
                }
                if (variableItem != null) {
                    currentSegment = segments.getFirst();
                    qName = currentSegment.getQName();
                    treeItemArray = variableItem.getItems();
                    n = treeItemArray.length;
                    n2 = 0;
                    while (n2 < n) {
                        TreeItem currentItem = treeItemArray[n2];
                        GraphicalTreeNode node = (GraphicalTreeNode)currentItem.getData();
                        boolean matchElement = GraphicalToolHelper.compareNode(node, qName);
                        if (matchElement) {
                            result = TreeViewerHelper.checkXMLType(currentItem);
                        }
                        ++n2;
                    }
                }
            }
        }
        return result;
    }

    public static TreeItem findTreeItem(IMappingReference element, TreeItem[] items) {
        return GraphicalToolHelper.findTreeItem(element, items, 0);
    }

    public static TreeItem findTreeItem(IMappingReference element, TreeItem[] items, int currentSegment) {
        AbstractReference abstractReference;
        LinkedList<ISegment> segments;
        TreeItem treeItem = null;
        Optional<? extends AbstractReference> reference = element.getReference();
        if (reference.isPresent() && !(segments = (abstractReference = reference.get()).getSegments()).isEmpty()) {
            if (currentSegment > 0) {
                segments = new LinkedList(segments.subList(currentSegment, segments.size()));
            }
            treeItem = GraphicalToolHelper.findTreeItem(items, segments);
        }
        return treeItem;
    }

    public static GraphicalTreeItem findGraphicalTreeItem(IMappingReference element, CustomResourceTreeViewer treeViewer, TreeItem[] items) {
        return GraphicalToolHelper.findGraphicalTreeItem(element, treeViewer, items, 0);
    }

    public static GraphicalTreeItem findGraphicalTreeItem(IMappingReference element, CustomResourceTreeViewer treeViewer, TreeItem[] items, int currentSegment) {
        AbstractReference abstractReference;
        LinkedList<ISegment> segments;
        GraphicalTreeItem graphicalTreeItem = GraphicalTreeItem.empty();
        Optional<? extends AbstractReference> reference = element.getReference();
        if (reference.isPresent() && !(segments = (abstractReference = reference.get()).getSegments()).isEmpty()) {
            if (currentSegment > 0) {
                segments = new LinkedList(segments.subList(currentSegment, segments.size()));
            }
            graphicalTreeItem = GraphicalToolHelper.findGraphicalTreeItem(treeViewer, items, segments);
        }
        return graphicalTreeItem;
    }

    public static TreeItem findTextNode(TreeItem item, boolean isXML) {
        TreeItem result = item;
        if (item != null && isXML) {
            TreeItem[] items;
            TreeItem[] treeItemArray = items = item.getItems();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                AttributeFieldType field;
                GraphicalTreeNode node;
                TreeItem treeItem = treeItemArray[n2];
                if (treeItem.getData() instanceof GraphicalTreeNode && (node = (GraphicalTreeNode)treeItem.getData()).getModel() instanceof AttributeFieldType && "text()".equals((field = (AttributeFieldType)node.getModel()).getKey().getName().getLocalPart())) {
                    result = treeItem;
                }
                ++n2;
            }
        }
        return result;
    }

    public static QName toQName(GraphicalTreeNode<?> node) {
        return new QName(node.getId() != null ? node.getId() : node.getLabel());
    }

    private static TreeItem findTreeItem(TreeItem[] items, LinkedList<ISegment> segments) {
        TreeItem treeItem = null;
        if (!segments.isEmpty()) {
            ISegment segment = segments.getFirst();
            QName qName = new QName(segment.toString());
            TreeItem[] treeItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem currentTreeItem = treeItemArray[n2];
                if (treeItem == null) {
                    GraphicalTreeNode node = (GraphicalTreeNode)currentTreeItem.getData();
                    boolean matchElement = GraphicalToolHelper.compareNode(node, qName);
                    if (matchElement && segments.size() - 1 > 0) {
                        segments.removeFirst();
                        treeItem = GraphicalToolHelper.findTreeItem(currentTreeItem.getItems(), segments);
                    } else if (matchElement) {
                        treeItem = currentTreeItem;
                    }
                }
                ++n2;
            }
        }
        return treeItem;
    }

    private static GraphicalTreeItem findGraphicalTreeItem(CustomResourceTreeViewer treeViewer, TreeItem[] items, LinkedList<ISegment> segments) {
        GraphicalTreeItem graphicalTreeItem = GraphicalTreeItem.empty();
        if (!segments.isEmpty()) {
            ISegment segment = segments.getFirst();
            QName qName = new QName(segment.toString());
            TreeItem[] treeItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                boolean isDummy;
                TreeItem currentTreeItem = treeItemArray[n2];
                boolean bl = isDummy = currentTreeItem.getData() == null;
                if (isDummy) {
                    Object[] children;
                    TreeItem parentTreeItem = currentTreeItem.getParentItem();
                    GraphicalTreeNode parentNode = (GraphicalTreeNode)parentTreeItem.getData();
                    Object[] objectArray = children = treeViewer.getRawChildren(parentNode);
                    int n3 = children.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Object childNode = objectArray[n4];
                        GraphicalTreeNode currentNode = (GraphicalTreeNode)childNode;
                        if (graphicalTreeItem.isDisposed()) {
                            boolean matchElement = GraphicalToolHelper.compareNode(currentNode, qName);
                            if (matchElement && segments.size() - 1 > 0) {
                                segments.removeFirst();
                                Object[] childrenByNode = treeViewer.getRawChildren(currentNode);
                                graphicalTreeItem = GraphicalToolHelper.findGraphicalTreeItem(treeViewer, parentTreeItem, (GraphicalTreeNode[])childrenByNode, segments);
                            } else if (matchElement) {
                                graphicalTreeItem = GraphicalTreeItem.of(parentTreeItem, currentNode, false);
                            }
                        }
                        ++n4;
                    }
                } else if (graphicalTreeItem.isDisposed()) {
                    GraphicalTreeNode node = (GraphicalTreeNode)currentTreeItem.getData();
                    boolean matchElement = GraphicalToolHelper.compareNode(node, qName);
                    if (matchElement && segments.size() - 1 > 0) {
                        segments.removeFirst();
                        graphicalTreeItem = GraphicalToolHelper.findGraphicalTreeItem(treeViewer, currentTreeItem.getItems(), segments);
                    } else if (matchElement) {
                        graphicalTreeItem = GraphicalTreeItem.of(currentTreeItem, node, true);
                    }
                }
                ++n2;
            }
        }
        return graphicalTreeItem;
    }

    private static GraphicalTreeItem findGraphicalTreeItem(CustomResourceTreeViewer treeViewer, TreeItem parent, GraphicalTreeNode<?>[] nodes, LinkedList<ISegment> segments) {
        GraphicalTreeItem graphicalTreeItem = GraphicalTreeItem.empty();
        if (!segments.isEmpty()) {
            ISegment segment = segments.getFirst();
            QName qName = new QName(segment.toString());
            GraphicalTreeNode<?>[] graphicalTreeNodeArray = nodes;
            int n = nodes.length;
            int n2 = 0;
            while (n2 < n) {
                GraphicalTreeNode<?> currentNode = graphicalTreeNodeArray[n2];
                if (graphicalTreeItem.isDisposed()) {
                    GraphicalTreeNode<?> node = currentNode;
                    boolean matchElement = GraphicalToolHelper.compareNode(node, qName);
                    if (matchElement && segments.size() - 1 > 0) {
                        segments.removeFirst();
                        Object[] childrenByNode = treeViewer.getRawChildren(currentNode);
                        graphicalTreeItem = GraphicalToolHelper.findGraphicalTreeItem(treeViewer, parent, (GraphicalTreeNode[])childrenByNode, segments);
                    } else if (matchElement) {
                        graphicalTreeItem = GraphicalTreeItem.of(parent, node, false);
                    }
                }
                ++n2;
            }
        }
        return graphicalTreeItem;
    }

    private static String checkVariableName(TargetInformation targetInformation, String variableName) {
        TargetContainer targetContainer = targetInformation.getTargetContainer();
        ArrayList existingNames = Lists.newArrayList(targetContainer.getContextVariables().keySet());
        existingNames.addAll(targetContainer.getInputs());
        return DFLModelHelper.verifyName((List)existingNames, (String)variableName);
    }

    private static boolean checkNode(GraphicalTreeNode<?> node, QName qName) {
        boolean matchElement = false;
        String data = qName.getLocalPart();
        Object model = GraphicalToolHelper.findModel(node.getModel());
        data = DFLModelHelper.removeQuotes((String)data);
        if (model instanceof AttributeFieldType) {
            AttributeFieldType field = (AttributeFieldType)node.getModel();
            QName fieldQName = MetadataTypeHelper.toQName((AttributeFieldType)field);
            String fieldName = DFLModelHelper.removeQuotes((String)fieldQName.getLocalPart());
            matchElement = ("@" + fieldName).equals(data);
        } else if (model instanceof ObjectFieldType) {
            ObjectFieldType field = (ObjectFieldType)node.getModel();
            QName fieldQName = MetadataTypeHelper.toQName((ObjectFieldType)field);
            String fieldName = DFLModelHelper.removeQuotes((String)fieldQName.getLocalPart());
            matchElement = fieldName.equals(data);
        } else if (model instanceof ObjectType | model instanceof SimpleType) {
            matchElement = node.getId() != null ? node.getId().equalsIgnoreCase(data) : node.getLabel().equalsIgnoreCase(data);
        }
        return matchElement;
    }

    private static Object findModel(Object model) {
        if (model instanceof ArrayType) {
            return GraphicalToolHelper.findModel(((ArrayType)model).getType());
        }
        return model;
    }
}

