/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.graphical.references.properties;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.mule.tooling.dfl.ui.graphical.references.properties.ISegmentProperty;
import org.mule.tooling.dfl.ui.graphical.references.properties.RepeatedPropertyException;

public class SegmentPropertyManager<P extends ISegmentProperty> {
    private List<P> properties;

    public SegmentPropertyManager() {
        this(Lists.newArrayList());
    }

    public SegmentPropertyManager(List<P> properties) {
        this.setProperties(properties);
    }

    public boolean hasProperty(Class<? extends ISegmentProperty> segmentProperty) {
        return this.getProperty(segmentProperty).isPresent();
    }

    public <T extends ISegmentProperty> Optional<T> getProperty(Class<T> segmentPropertyClass) {
        ISegmentProperty property = null;
        for (ISegmentProperty fc : this.properties) {
            if (!segmentPropertyClass.equals(fc.getClass()) || property != null) continue;
            property = fc;
        }
        return Optional.ofNullable(property);
    }

    public boolean addProperty(P property) {
        Optional<?> alreadyDefinedProperty;
        Class<?> segmentPropertyClass = property.getClass();
        if (this.hasProperty(segmentPropertyClass) && (alreadyDefinedProperty = this.getProperty(segmentPropertyClass)).isPresent()) {
            this.removeProperty((ISegmentProperty)alreadyDefinedProperty.get());
        }
        return this.properties.add(property);
    }

    public boolean removeProperty(P property) {
        if (this.properties.contains(property)) {
            return this.properties.remove(property);
        }
        return false;
    }

    public List<P> getProperties() {
        return Collections.unmodifiableList(this.properties);
    }

    private void setProperties(List<P> properties) {
        if (this.hasRepeatedProperties(properties)) {
            throw new RepeatedPropertyException("Properties must no be repeated");
        }
        this.properties = new ArrayList<P>(properties);
    }

    private boolean hasRepeatedProperties(List<P> properties) {
        HashSet clazzes = new HashSet();
        for (ISegmentProperty fc : properties) {
            clazzes.add(fc.getClass());
        }
        return clazzes.size() != properties.size();
    }
}

