/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.graphical.references;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Optional;
import javax.xml.namespace.QName;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.AttributeFieldType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.tooling.client.metadata.MetadataFactory;
import org.mule.tooling.dfl.ui.graphical.references.AbstractReference;
import org.mule.tooling.dfl.ui.graphical.references.ISegment;
import org.mule.tooling.dfl.ui.graphical.references.TreeSegment;
import org.mule.tooling.dfl.ui.graphical.references.properties.AttributeSegmentProperty;
import org.mule.tooling.dfl.ui.graphical.references.properties.FieldSegmentProperty;
import org.mule.tooling.dfl.ui.graphical.references.properties.ListProperty;
import org.mule.tooling.dfl.ui.graphical.references.properties.ModelSegmentProperty;
import org.mule.tooling.dfl.ui.graphical.references.properties.NodeSegmentProperty;
import org.mule.tooling.dfl.ui.graphical.references.properties.PreviousNodesProperty;
import org.mule.tooling.dfl.ui.graphical.references.properties.XMLRepeatedElementProperty;
import org.mule.tooling.dfl.ui.graphical.util.GraphicalToolHelper;
import org.mule.tooling.dfl.ui.graphical.util.MappingNode;
import org.mule.tooling.ui.modules.core.metadata.MetadataTypeHelper;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeNode;

public class TreeReference
extends AbstractReference {
    protected TreeReference() {
    }

    @Override
    public QName getQName() {
        return this.getLastSegment().getQName();
    }

    public Optional<ISegment> getAttributeSegment() {
        ISegment lastSegment = (ISegment)this.segments.getLast();
        Optional<ISegment> attributeSegment = Optional.empty();
        Optional<AttributeSegmentProperty> attributeProperty = lastSegment.getProperty(AttributeSegmentProperty.class);
        if (attributeProperty.isPresent() && attributeProperty.get().isAttribute()) {
            attributeSegment = Optional.of(lastSegment);
        }
        return attributeSegment;
    }

    public MetadataType getMetadataType() {
        ISegment lastSegment = (ISegment)this.segments.getLast();
        Optional<ModelSegmentProperty> modelProperty = lastSegment.getProperty(ModelSegmentProperty.class);
        return modelProperty.map(modelProp -> modelProp.getModel()).orElse(MetadataFactory.undefined());
    }

    public LinkedList<ISegment> getPreviousLists() {
        LinkedList segments = Lists.newLinkedList();
        for (ISegment segment : this.segments) {
            Optional<ModelSegmentProperty> optionalModelSegmentProperty = segment.getProperty(ModelSegmentProperty.class);
            if (!optionalModelSegmentProperty.isPresent()) continue;
            ModelSegmentProperty modelSegmentProperty = optionalModelSegmentProperty.get();
            MetadataType dataType = modelSegmentProperty.getModel();
            Optional<FieldSegmentProperty> fieldSegmentProperty = segment.getProperty(FieldSegmentProperty.class);
            if (!(dataType instanceof ArrayType) && (!fieldSegmentProperty.isPresent() || !fieldSegmentProperty.get().isList())) continue;
            segments.add(segment);
        }
        return segments;
    }

    private ISegment getLastSegment() {
        ISegment lastSegment = (ISegment)this.segments.getLast();
        Optional<AttributeSegmentProperty> attributeProperty = lastSegment.getProperty(AttributeSegmentProperty.class);
        if (attributeProperty.isPresent() && attributeProperty.get().isAttribute()) {
            lastSegment = (ISegment)this.segments.get(this.segments.size() - 2);
        }
        return lastSegment;
    }

    public static TreeReference of(GraphicalTreeNode<?> node) {
        TreeReference reference = new TreeReference();
        TreeReference.buildSegments(node, reference);
        return reference;
    }

    private static void buildSegments(GraphicalTreeNode<?> node, TreeReference reference) {
        if (node != null) {
            boolean hasParent;
            boolean bl = hasParent = node.getParent() != null;
            if (hasParent) {
                TreeReference.handleNode(reference, node);
                TreeReference.calculateSiblingModel(node, reference);
                TreeReference.buildSegments(node.getParent(), reference);
            } else {
                TreeReference.handleNode(reference, node);
                if (node.getModel() instanceof MetadataType && MetadataFormat.XML.equals((Object)((MetadataType)node.getModel()).getMetadataFormat())) {
                    ISegment lastSegment = (ISegment)reference.segments.getLast();
                    if (lastSegment.getProperty(ModelSegmentProperty.class).get().getModel() instanceof ArrayType || MappingNode.isRepeatedKeyValuePair(lastSegment.getProperty(ModelSegmentProperty.class).get().getModel())) {
                        lastSegment.addProperty(new XMLRepeatedElementProperty());
                    }
                } else if (node.getModel() instanceof ObjectType) {
                    ObjectType property = (ObjectType)node.getModel();
                    for (ObjectFieldType propertyMetadataField : property.getFields()) {
                        ISegment lastSegment;
                        Optional<ModelSegmentProperty> maybeModel;
                        if (!MetadataFormat.XML.equals((Object)propertyMetadataField.getValue().getMetadataFormat()) || !(maybeModel = (lastSegment = (ISegment)reference.segments.getLast()).getProperty(ModelSegmentProperty.class)).isPresent() || !(maybeModel.get().getModel() instanceof ArrayType)) continue;
                        lastSegment.addProperty(new XMLRepeatedElementProperty());
                    }
                }
            }
        }
    }

    private static void calculateSiblingModel(GraphicalTreeNode<?> node, TreeReference reference) {
        GraphicalTreeNode parent = node.getParent();
        int index = 0;
        GraphicalTreeNode[] siblings = parent.getChildren(node.getLevel());
        while (index < siblings.length && !siblings[index].equals(node)) {
            ++index;
        }
        GraphicalTreeNode[] previousNodes = Arrays.copyOf(siblings, index);
        ((ISegment)reference.segments.getFirst()).addProperty(new PreviousNodesProperty(previousNodes));
    }

    private static void handleNode(TreeReference reference, GraphicalTreeNode<?> node) {
        if (node.getModel() instanceof AttributeFieldType) {
            AttributeFieldType field = (AttributeFieldType)node.getModel();
            ArrayList segmentProperties = Lists.newArrayList();
            segmentProperties.add(new ModelSegmentProperty(field.getValue()));
            segmentProperties.add(new AttributeSegmentProperty(true));
            segmentProperties.add(new NodeSegmentProperty(node));
            segmentProperties.add(new ListProperty(field.getValue(), node));
            QName qName = MetadataTypeHelper.toQName((AttributeFieldType)field);
            reference.segments.addFirst(new TreeSegment(qName, segmentProperties));
        } else if (node.getModel() instanceof ObjectFieldType) {
            ObjectFieldType field = (ObjectFieldType)node.getModel();
            ArrayList segmentProperties = Lists.newArrayList();
            segmentProperties.add(new ModelSegmentProperty(field.getValue()));
            segmentProperties.add(new FieldSegmentProperty(field));
            segmentProperties.add(new AttributeSegmentProperty(false));
            segmentProperties.add(new NodeSegmentProperty(node));
            segmentProperties.add(new ListProperty(field.getValue(), node));
            if (field.getMetadataFormat().equals((Object)MetadataFormat.XML) && field.isRepeated()) {
                segmentProperties.add(new XMLRepeatedElementProperty());
            }
            QName qName = MetadataTypeHelper.toQName((ObjectFieldType)field);
            reference.segments.addFirst(new TreeSegment(qName, segmentProperties));
        } else if (node.getModel() instanceof ObjectType) {
            ArrayList segmentProperties = Lists.newArrayList();
            segmentProperties.add(new ModelSegmentProperty((MetadataType)node.getModel()));
            segmentProperties.add(new NodeSegmentProperty(node));
            QName qName = GraphicalToolHelper.toQName(node);
            reference.segments.addFirst(new TreeSegment(qName, segmentProperties));
        } else if (node.getModel() instanceof MetadataType) {
            MetadataType metadataType = (MetadataType)node.getModel();
            ArrayList segmentProperties = Lists.newArrayList();
            segmentProperties.add(new ModelSegmentProperty(metadataType));
            segmentProperties.add(new NodeSegmentProperty(node));
            QName qName = GraphicalToolHelper.toQName(node);
            reference.segments.addFirst(new TreeSegment(qName, segmentProperties));
        }
    }
}

