/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.graphical.references;

import com.google.common.base.Optional;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.mule.tooling.dfl.ui.graphical.references.AbstractReference;
import org.mule.tooling.dfl.ui.graphical.references.CodeSegment;
import org.mule.tooling.dfl.ui.graphical.references.ISegment;
import org.mule.tooling.dfl.ui.graphical.references.VirtualTreeReference;

public class RelativeReference
extends AbstractReference {
    private RelativeReference() {
    }

    public static AbstractReference of(AbstractReference canonicalReference, Map<String, AbstractReference> contextVariables) {
        if (canonicalReference instanceof VirtualTreeReference) {
            return canonicalReference;
        }
        RelativeReference relativeReference = new RelativeReference();
        LinkedList<ISegment> canonicalSegments = canonicalReference.getSegments();
        int maxNumberOfSegmentsMatched = 0;
        Optional variableName = Optional.absent();
        for (Map.Entry<String, AbstractReference> entry : contextVariables.entrySet()) {
            LinkedList<ISegment> variableSegments = entry.getValue().getSegments();
            int segmentsMatched = RelativeReference.calculateSegmentsMatched(variableSegments, canonicalSegments);
            if (segmentsMatched <= maxNumberOfSegmentsMatched) continue;
            maxNumberOfSegmentsMatched = segmentsMatched;
            variableName = Optional.fromNullable((Object)entry.getKey());
        }
        if (variableName.isPresent()) {
            String variable = (String)variableName.get();
            AbstractReference variableReference = contextVariables.get(variable);
            if (variableReference.segments.size() == maxNumberOfSegmentsMatched) {
                relativeReference.segments.add(new CodeSegment(variable));
            } else {
                maxNumberOfSegmentsMatched = 0;
            }
        }
        List subSegments = canonicalSegments.subList(maxNumberOfSegmentsMatched, canonicalSegments.size());
        for (ISegment segment : subSegments) {
            relativeReference.segments.add(segment);
        }
        return relativeReference;
    }

    private static int calculateSegmentsMatched(LinkedList<ISegment> variableSegments, LinkedList<ISegment> canonicalSegments) {
        int matchCounter = 0;
        int variableSegmentSize = variableSegments.size();
        int canonicalSegmentSize = canonicalSegments.size();
        int segmentIndex = 0;
        while (segmentIndex < variableSegmentSize && segmentIndex < canonicalSegmentSize) {
            ISegment variableSegment = variableSegments.get(segmentIndex);
            ISegment canonicalSegment = canonicalSegments.get(segmentIndex);
            if (variableSegment.getQName().equals(canonicalSegment.getQName())) {
                ++matchCounter;
            }
            ++segmentIndex;
        }
        return matchCounter;
    }
}

