/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.graphical.references;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.mule.tooling.dfl.dFL.Attribute;
import org.mule.tooling.dfl.dFL.BinaryFunction;
import org.mule.tooling.dfl.dFL.ClojureOperatorOrOrExpression;
import org.mule.tooling.dfl.dFL.Content;
import org.mule.tooling.dfl.dFL.DeclaredNamespace;
import org.mule.tooling.dfl.dFL.DollarVariable;
import org.mule.tooling.dfl.dFL.DotSelector;
import org.mule.tooling.dfl.dFL.DynamicSelector;
import org.mule.tooling.dfl.dFL.Expression;
import org.mule.tooling.dfl.dFL.FunctionCall;
import org.mule.tooling.dfl.dFL.Key;
import org.mule.tooling.dfl.dFL.KeyExpression;
import org.mule.tooling.dfl.dFL.SelectorWithNameSpace;
import org.mule.tooling.dfl.dFL.SimpleSelector;
import org.mule.tooling.dfl.dFL.VariableReference;
import org.mule.tooling.dfl.ui.graphical.code2view.CodeStructureManager;
import org.mule.tooling.dfl.ui.graphical.model.GraphicalEvaluationContext;
import org.mule.tooling.dfl.ui.graphical.references.AbstractReference;
import org.mule.tooling.dfl.ui.graphical.references.CodeSegment;
import org.mule.tooling.dfl.ui.graphical.references.ISegment;
import org.mule.tooling.dfl.ui.graphical.references.properties.AttributeSegmentProperty;
import org.mule.tooling.dfl.ui.graphical.references.properties.ISegmentProperty;
import org.mule.tooling.dfl.ui.graphical.view2code.generation.DflFactoryUtils;
import org.mule.tooling.utils.Pair;

public class CodeReference
extends AbstractReference {
    private CodeReference() {
    }

    public static CodeReference of(CodeStructureManager structureManager) {
        CodeReference reference = new CodeReference();
        CodeReference.buildSegments(structureManager, reference);
        return reference;
    }

    public static CodeReference of(GraphicalEvaluationContext context, EObject object) {
        DotSelector selector;
        String type;
        CodeReference reference = new CodeReference();
        CodeReference.buildSegments(context, context.getFrameCount(), object, reference);
        if (object instanceof DotSelector && ".@".equals(type = (selector = (DotSelector)object).getType())) {
            ((ISegment)reference.segments.getLast()).addProperty(new AttributeSegmentProperty());
        }
        return reference;
    }

    private static void buildSegments(CodeStructureManager structureManager, CodeReference reference) {
        for (EObject node : structureManager.getNodes()) {
            if (node instanceof Key) {
                Key key = (Key)node;
                KeyExpression keyExpression = key.getValue();
                StringBuilder sb = new StringBuilder();
                for (ILeafNode leafNode : NodeModelUtils.getNode((EObject)keyExpression).getLeafNodes()) {
                    if (leafNode.isHidden()) continue;
                    sb.append(leafNode.getText());
                }
                String name = sb.toString();
                String namespace = "";
                DeclaredNamespace declaredNamespace = key.getNamespace();
                if (declaredNamespace != null) {
                    namespace = structureManager.getNamespaces().get(declaredNamespace.getName());
                    namespace = namespace != null ? namespace : "";
                }
                reference.segments.push(new CodeSegment(name, namespace));
                continue;
            }
            if (!(node instanceof Attribute)) continue;
            ArrayList segmentProperties = Lists.newArrayList();
            segmentProperties.add(new AttributeSegmentProperty());
            Attribute attribute = (Attribute)node;
            if (attribute.getName() == null) continue;
            reference.segments.push(new CodeSegment(attribute.getName(), (List<ISegmentProperty>)segmentProperties));
        }
    }

    private static void buildSegments(GraphicalEvaluationContext context, int frameIndex, EObject currentObject, CodeReference reference) {
        Stack<Pair<Integer, EObject>> prevSteps = new Stack<Pair<Integer, EObject>>();
        CodeReference.buildSegments(context, frameIndex, currentObject, reference, prevSteps);
    }

    private static void buildSegments(GraphicalEvaluationContext context, int frameIndex, EObject currentObject, CodeReference reference, Stack<Pair<Integer, EObject>> prevSteps) {
        block8: {
            block15: {
                String variableReference;
                block16: {
                    block14: {
                        block13: {
                            block12: {
                                block11: {
                                    block10: {
                                        block9: {
                                            if (currentObject instanceof Content) break block8;
                                            if (!(currentObject instanceof ClojureOperatorOrOrExpression)) break block9;
                                            ClojureOperatorOrOrExpression clojureOperatorOrOrExpression = (ClojureOperatorOrOrExpression)currentObject;
                                            EObject expression = clojureOperatorOrOrExpression.eContainer();
                                            CodeReference.buildSegmentIfNew(context, frameIndex, expression, reference, prevSteps);
                                            break block8;
                                        }
                                        if (!DflFactoryUtils.isFunctionNamed(currentObject, "map")) break block10;
                                        BinaryFunction lambda = (BinaryFunction)currentObject;
                                        Expression element = lambda.getElement();
                                        CodeReference.buildSegmentIfNew(context, frameIndex - 1, (EObject)element, reference, prevSteps);
                                        break block8;
                                    }
                                    if (!DflFactoryUtils.isFunctionNamed(currentObject, "filter")) break block11;
                                    BinaryFunction lambda = (BinaryFunction)currentObject;
                                    Expression element = lambda.getElement();
                                    CodeReference.buildSegmentIfNew(context, frameIndex - 1, (EObject)element, reference, prevSteps);
                                    break block8;
                                }
                                if (!DflFactoryUtils.isFunctionNamed(currentObject, "distinctBy")) break block12;
                                BinaryFunction lambda = (BinaryFunction)currentObject;
                                Expression element = lambda.getElement();
                                CodeReference.buildSegmentIfNew(context, frameIndex - 1, (EObject)element, reference, prevSteps);
                                break block8;
                            }
                            if (!(currentObject instanceof DotSelector)) break block13;
                            DotSelector selector = (DotSelector)currentObject;
                            CodeReference.buildSegmentIfNew(context, frameIndex, (EObject)selector.getSelector(), reference, prevSteps);
                            CodeReference.buildSegmentIfNew(context, frameIndex, (EObject)selector.getData(), reference, prevSteps);
                            break block8;
                        }
                        if (!(currentObject instanceof DynamicSelector)) break block14;
                        DynamicSelector selector = (DynamicSelector)currentObject;
                        CodeReference.buildSegmentIfNew(context, frameIndex, (EObject)selector.getData(), reference, prevSteps);
                        break block8;
                    }
                    if (!(currentObject instanceof VariableReference)) break block15;
                    VariableReference variable = (VariableReference)currentObject;
                    variableReference = variable.getReference();
                    EObject variableValue = context.getVariables(frameIndex).get(variableReference);
                    if (variableValue == null) break block16;
                    CodeReference.buildSegmentIfNew(context, frameIndex, variableValue, reference, prevSteps);
                    break block8;
                }
                if (variableReference == null) break block8;
                reference.segments.push(new CodeSegment(variableReference));
                break block8;
            }
            if (currentObject instanceof DollarVariable) {
                EObject variableValue = context.getVariables(frameIndex).get("$");
                CodeReference.buildSegmentIfNew(context, frameIndex, variableValue, reference, prevSteps);
            } else if (currentObject instanceof SimpleSelector) {
                SimpleSelector selector = (SimpleSelector)currentObject;
                reference.segments.push(new CodeSegment(selector.getName()));
            } else if (currentObject instanceof SelectorWithNameSpace) {
                SelectorWithNameSpace selector = (SelectorWithNameSpace)currentObject;
                DeclaredNamespace namespace = selector.getNamespace();
                String prefix = namespace.getName();
                Map<String, String> namespaces = context.getNamespaces();
                String namespaceUri = namespaces.get(prefix);
                reference.segments.push(new CodeSegment(selector.getName(), namespaceUri != null ? namespaceUri : ""));
            } else if (currentObject instanceof FunctionCall) {
                FunctionCall lambda = (FunctionCall)currentObject;
                for (Expression element : lambda.getParameters().getParameters()) {
                    CodeReference.buildSegmentIfNew(context, frameIndex - 1, (EObject)element, reference, prevSteps);
                }
            }
        }
    }

    private static void buildSegmentIfNew(GraphicalEvaluationContext context, int frameIndex, EObject currentObject, CodeReference reference, Stack<Pair<Integer, EObject>> prevSteps) {
        if (!prevSteps.contains(Pair.of((Object)frameIndex, (Object)currentObject))) {
            prevSteps.push((Pair<Integer, EObject>)Pair.of((Object)frameIndex, (Object)currentObject));
            CodeReference.buildSegments(context, frameIndex, currentObject, reference, prevSteps);
            prevSteps.pop();
        }
    }
}

