/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.graphical.references;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import javax.xml.namespace.QName;
import org.mule.tooling.dfl.ui.graphical.references.ISegment;
import org.mule.tooling.dfl.ui.graphical.references.properties.ISegmentProperty;
import org.mule.tooling.dfl.ui.graphical.references.properties.SegmentPropertyManager;

public abstract class AbstractSegment
implements ISegment {
    private QName qName;
    protected SegmentPropertyManager<ISegmentProperty> segmentPropertyManager;

    public AbstractSegment(QName qName) {
        this(qName, Lists.newArrayList());
    }

    public AbstractSegment(QName qName, List<ISegmentProperty> segmentProperties) {
        this.qName = qName;
        this.segmentPropertyManager = new SegmentPropertyManager<ISegmentProperty>(segmentProperties);
    }

    @Override
    public QName getQName() {
        return this.qName;
    }

    @Override
    public List<ISegmentProperty> getProperties() {
        return this.segmentPropertyManager.getProperties();
    }

    @Override
    public boolean hasProperty(Class<? extends ISegmentProperty> segmentProperty) {
        return this.segmentPropertyManager.hasProperty(segmentProperty);
    }

    public String toString() {
        return this.getQName().getLocalPart();
    }

    @Override
    public <T extends ISegmentProperty> Optional<T> getProperty(Class<T> segmentPropertyClass) {
        return this.segmentPropertyManager.getProperty(segmentPropertyClass);
    }

    @Override
    public void addProperty(ISegmentProperty segmentProperty) {
        this.segmentPropertyManager.addProperty(segmentProperty);
    }
}

