/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.graphical.references;

import com.google.common.base.Joiner;
import java.math.BigDecimal;
import java.util.LinkedList;
import java.util.Optional;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.mule.tooling.dfl.dFL.DFLFactory;
import org.mule.tooling.dfl.dFL.DeclaredNamespace;
import org.mule.tooling.dfl.dFL.Document;
import org.mule.tooling.dfl.dFL.DotSelector;
import org.mule.tooling.dfl.dFL.DynamicSelector;
import org.mule.tooling.dfl.dFL.Expression;
import org.mule.tooling.dfl.dFL.IntegerLiteral;
import org.mule.tooling.dfl.dFL.SelectorOrFunction;
import org.mule.tooling.dfl.dFL.SimpleSelector;
import org.mule.tooling.dfl.dFL.StringSelector;
import org.mule.tooling.dfl.dFL.VariableReference;
import org.mule.tooling.dfl.ui.graphical.references.ISegment;
import org.mule.tooling.dfl.ui.graphical.references.properties.AttributeSegmentProperty;
import org.mule.tooling.dfl.ui.graphical.references.properties.ListProperty;
import org.mule.tooling.dfl.ui.graphical.references.properties.XMLRepeatedElementProperty;
import org.mule.tooling.dfl.ui.scafflod.ScaffoldingHelper;
import org.mule.tooling.dfl.util.DFLModelHelper;

public abstract class AbstractReference {
    protected LinkedList<ISegment> segments = new LinkedList();

    public QName getQName() {
        return this.segments.getLast().getQName();
    }

    public LinkedList<ISegment> getSegments() {
        return new LinkedList<ISegment>(this.segments);
    }

    public String toString() {
        return Joiner.on((String)".").join(this.segments);
    }

    public Expression createSelectionExpression(Document document) {
        VariableReference variableReference = DFLFactory.eINSTANCE.createVariableReference();
        LinkedList<ISegment> temporalSegments = this.getSegments();
        String firstSegmentName = temporalSegments.get(0).getQName().getLocalPart();
        variableReference.setReference(firstSegmentName);
        temporalSegments.removeFirst();
        VariableReference from = variableReference;
        int currentSegment = 0;
        int segmentSize = temporalSegments.size();
        for (ISegment segment : temporalSegments) {
            ++currentSegment;
            boolean isDynamicSelector = false;
            QName qName = segment.getQName();
            DotSelector dotSelector = DFLFactory.eINSTANCE.createDotSelector();
            DynamicSelector dynamicSelector = DFLFactory.eINSTANCE.createDynamicSelector();
            dotSelector.setType(".");
            dotSelector.setData((Expression)from);
            SimpleSelector selector = null;
            if (StringUtils.isNotEmpty((String)qName.getNamespaceURI())) {
                StringSelector stringSelector = DFLFactory.eINSTANCE.createStringSelector();
                qName = ScaffoldingHelper.defineNamespace(document, qName);
                DeclaredNamespace declaredNameSpace = DFLFactory.eINSTANCE.createDeclaredNamespace();
                declaredNameSpace.setName(qName.getPrefix());
                stringSelector.setNamespace(declaredNameSpace);
                selector = stringSelector;
            } else {
                selector = DFLFactory.eINSTANCE.createSimpleSelector();
            }
            Optional<AttributeSegmentProperty> attributeProperty = segment.getProperty(AttributeSegmentProperty.class);
            Optional<ListProperty> listProperty = segment.getProperty(ListProperty.class);
            String localPart = qName.getLocalPart();
            if (segment.hasProperty(XMLRepeatedElementProperty.class)) {
                dotSelector.setType(".*");
            } else if (attributeProperty.isPresent() && attributeProperty.get().isAttribute()) {
                dotSelector.setType(".@");
            } else if (listProperty.isPresent() && listProperty.get().isList() && currentSegment < segmentSize) {
                isDynamicSelector = true;
                IntegerLiteral index = DFLFactory.eINSTANCE.createIntegerLiteral();
                index.setValue(BigDecimal.valueOf(0L));
                dynamicSelector.setType("[");
                dynamicSelector.setData((Expression)dotSelector);
                dynamicSelector.setExpression((Expression)index);
            }
            selector.setName(DFLModelHelper.quoteIfNecessary((String)localPart));
            dotSelector.setSelector((SelectorOrFunction)selector);
            Object object = from = isDynamicSelector ? dynamicSelector : dotSelector;
        }
        return from;
    }
}

