/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.graphical.providers;

import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.ArrayUtils;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.FilteredTree;
import org.mule.tooling.dfl.ui.graphical.model.ITreeGraphicalMapping;
import org.mule.tooling.dfl.ui.graphical.providers.IConnectorProvider;
import org.mule.tooling.dfl.ui.graphical.util.TreeViewerHelper;

public class LeftConnectorProvider
implements IConnectorProvider {
    private FilteredTree filteredTree;
    private List<ITreeGraphicalMapping> mappings;

    public LeftConnectorProvider(FilteredTree filteredTree, List<ITreeGraphicalMapping> mappings) {
        this.mappings = mappings;
        this.filteredTree = filteredTree;
    }

    @Override
    public FilteredTree getFilteredTree() {
        return this.filteredTree;
    }

    @Override
    public TreeItem[] getItems() {
        return this.filteredTree.getViewer().getTree().getItems();
    }

    @Override
    public List<ITreeGraphicalMapping> getMappings() {
        return this.mappings;
    }

    @Override
    public TreeItem getConnectorItem(ITreeGraphicalMapping mapping) {
        return mapping.getLeftItem().getTreeItem();
    }

    @Override
    public TreeItem getMirrorConnectorItem(ITreeGraphicalMapping mapping) {
        return mapping.getRightItem().getTreeItem();
    }

    @Override
    public boolean isSelected(ITreeGraphicalMapping mapping) {
        Object[] selection = this.filteredTree.getViewer().getTree().getSelection();
        TreeItem treeItem = mapping.getLeftItem().getTreeItem();
        return ArrayUtils.contains((Object[])selection, (Object)treeItem);
    }

    @Override
    public TreeItem[] getSelection() {
        return this.getFilteredTree().getViewer().getTree().getSelection();
    }

    @Override
    public boolean isMappingInsideContext(Optional<TreeItem> rootOfSelectedContext, ITreeGraphicalMapping mapping) {
        boolean isMappingInsideContext = false;
        if (rootOfSelectedContext.isPresent()) {
            isMappingInsideContext = TreeViewerHelper.isContained(rootOfSelectedContext.get(), this.getConnectorItem(mapping));
        }
        return isMappingInsideContext;
    }

    @Override
    public boolean isHover(ITreeGraphicalMapping mapping, TreeItem hoverItem) {
        return hoverItem != null && mapping.getLeftItem().getTreeItem() == hoverItem;
    }
}

