/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.graphical.model.containers;

import java.util.Objects;
import java.util.Optional;
import org.mule.tooling.dfl.ui.graphical.model.DefaultGraphicalMapping;
import org.mule.tooling.dfl.ui.graphical.model.IGraphicalMapping;
import org.mule.tooling.dfl.ui.graphical.model.LambdaOperator;
import org.mule.tooling.dfl.ui.graphical.model.containers.IMappingInfo;
import org.mule.tooling.dfl.ui.graphical.references.AbstractReference;

public class LambdaMappingInfo
implements IMappingInfo {
    private LambdaOperator operator;
    private IMappingInfo mappingInfo;

    public LambdaMappingInfo(LambdaOperator operator, IGraphicalMapping graphicalMapping) {
        this.operator = operator;
        this.mappingInfo = new DefaultGraphicalMapping.EmptyMappingInfo(graphicalMapping);
    }

    public LambdaOperator getOperator() {
        return this.operator;
    }

    public IMappingInfo getMappingInfo() {
        return this.mappingInfo;
    }

    @Override
    public Optional<? extends AbstractReference> getReference() {
        return this.mappingInfo.getReference();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public void wrap(IMappingInfo mappingInfoToWrap) {
        if (this.mappingInfo.isEmpty()) {
            this.mappingInfo = mappingInfoToWrap;
        } else {
            this.mappingInfo.wrap(mappingInfoToWrap);
        }
    }

    public String toString() {
        return Objects.toString(this.mappingInfo.getReference().orElse(null), "LambdaMappingInfo");
    }
}

