/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.graphical.model;

import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.FilteredTree;
import org.mule.tooling.dfl.ui.graphical.model.IGraphicalMapping;
import org.mule.tooling.dfl.ui.graphical.model.ITreeGraphicalMapping;
import org.mule.tooling.dfl.ui.graphical.model.containers.IMappingInfo;
import org.mule.tooling.dfl.ui.graphical.util.GraphicalToolHelper;
import org.mule.tooling.dfl.ui.graphical.util.GraphicalTreeItem;
import org.mule.tooling.dfl.ui.graphical.util.TreeViewerHelper;
import org.mule.tooling.dfl.ui.input.CustomResourceTreeViewer;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeNode;

public class TreeGraphicalMappingAdapter
implements ITreeGraphicalMapping {
    private GraphicalTreeItem leftGraphicalTreeItem = GraphicalTreeItem.empty();
    private GraphicalTreeItem rightGraphicalTreeItem = GraphicalTreeItem.empty();
    private IGraphicalMapping adapted;
    private Tree leftTree;
    private Tree rightTree;
    private TreeViewer leftTreeViewer;
    private TreeViewer rightTreeViewer;
    private boolean outputIsXML;

    public TreeGraphicalMappingAdapter(FilteredTree leftFilteredTree, FilteredTree rightFilteredTree, IGraphicalMapping adapted) {
        this.adapted = adapted;
        this.leftTreeViewer = leftFilteredTree.getViewer();
        this.rightTreeViewer = rightFilteredTree.getViewer();
        this.leftTree = this.leftTreeViewer.getTree();
        this.rightTree = this.rightTreeViewer.getTree();
        this.outputIsXML = this.rightTree.getItems().length == 0 ? false : TreeViewerHelper.checkXMLType(this.rightTree.getItems()[0]);
    }

    @Override
    public IMappingInfo getSourceElement() {
        return this.adapted.getSourceElement();
    }

    @Override
    public void setSourceElement(IMappingInfo sourceElement) {
        this.adapted.setSourceElement(sourceElement);
    }

    @Override
    public IMappingInfo getTargetElement() {
        return this.adapted.getTargetElement();
    }

    @Override
    public void setTargetElement(IMappingInfo targetElement) {
        this.adapted.setTargetElement(targetElement);
    }

    @Override
    public int getZIndex() {
        return this.adapted.getZIndex();
    }

    @Override
    public void refresh() {
        this.leftGraphicalTreeItem = GraphicalTreeItem.empty();
        this.rightGraphicalTreeItem = GraphicalTreeItem.empty();
    }

    @Override
    public GraphicalTreeItem getLeftItem() {
        TreeItem[] leftItems;
        if (this.leftGraphicalTreeItem.isDisposed() && this.leftGraphicalTreeItem != GraphicalTreeItem.NULL && (leftItems = this.leftTree.getItems()).length > 0) {
            IMappingInfo sourceElement = this.getSourceElement();
            boolean inputIsXml = GraphicalToolHelper.checkXMLType(sourceElement, leftItems);
            int initialSegment = 0;
            this.leftGraphicalTreeItem = GraphicalToolHelper.findGraphicalTreeItem(sourceElement, (CustomResourceTreeViewer)this.leftTreeViewer, leftItems, initialSegment);
            if (!this.leftGraphicalTreeItem.isDisposed() && inputIsXml) {
                this.leftGraphicalTreeItem.findTextXmlNode();
            } else if (this.leftGraphicalTreeItem.isDisposed()) {
                this.leftGraphicalTreeItem = GraphicalTreeItem.NULL;
            }
        }
        return this.leftGraphicalTreeItem;
    }

    @Override
    public GraphicalTreeItem getRightItem() {
        TreeItem[] rightItems;
        if (this.rightGraphicalTreeItem.isDisposed() && this.rightGraphicalTreeItem != GraphicalTreeItem.NULL && (rightItems = this.rightTree.getItems()).length > 0) {
            TreeItem rightPayloadItem = rightItems[0];
            IMappingInfo targetElement = this.getTargetElement();
            if (!targetElement.getReference().isPresent()) {
                this.rightGraphicalTreeItem = GraphicalTreeItem.of(rightPayloadItem, (GraphicalTreeNode)rightPayloadItem.getData(), true);
            } else {
                TreeItem[] rightPayloadItems = TreeViewerHelper.resolvePayloadItems(rightPayloadItem);
                if (rightPayloadItems.length == 0) {
                    this.rightGraphicalTreeItem = GraphicalTreeItem.of(rightPayloadItem, (GraphicalTreeNode)rightPayloadItem.getData(), true);
                } else {
                    this.rightGraphicalTreeItem = GraphicalToolHelper.findGraphicalTreeItem(targetElement, (CustomResourceTreeViewer)this.rightTreeViewer, rightPayloadItems);
                    if (!this.rightGraphicalTreeItem.isDisposed() && this.outputIsXML) {
                        this.rightGraphicalTreeItem.findTextXmlNode();
                    } else if (this.rightGraphicalTreeItem.isDisposed()) {
                        this.rightGraphicalTreeItem = GraphicalTreeItem.NULL;
                    }
                }
            }
        }
        return this.rightGraphicalTreeItem;
    }
}

