/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.graphical.model;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.mule.tooling.dfl.dFL.ClojureOperator;
import org.mule.tooling.dfl.dFL.ClojureOperatorOrOrExpression;
import org.mule.tooling.dfl.dFL.DollarVariable;
import org.mule.tooling.dfl.dFL.Expression;
import org.mule.tooling.dfl.dFL.FunctionParameter;
import org.mule.tooling.dfl.dFL.LambdaLiteral;
import org.mule.tooling.dfl.dFL.Using;
import org.mule.tooling.dfl.dFL.VariableDefinition;
import org.mule.tooling.dfl.dFL.VariableDirective;
import org.mule.tooling.dfl.dFL.VariableReference;
import org.mule.tooling.dfl.ui.graphical.view2code.generation.DflFactoryUtils;

public abstract class GraphicalEvaluationContext {
    protected int level = 0;
    protected Map<String, String> namespaces = new HashMap<String, String>();
    protected Deque<Map<String, EObject>> frames = new ArrayDeque<Map<String, EObject>>();

    public void startScope() {
        ++this.level;
    }

    public void endScope() {
        --this.level;
    }

    public int getScope() {
        return this.level;
    }

    public void startFrame() {
        this.frames.push(new HashMap());
    }

    public void endFrame() {
        this.frames.pop();
    }

    public int getFrameCount() {
        return this.frames.size();
    }

    public void addNamespace(String prefix, String value) {
        this.namespaces.put(prefix, value);
    }

    public Map<String, String> getNamespaces() {
        return this.namespaces;
    }

    public void addVariable(String name, EObject value) {
        this.frames.peek().put(name, value);
    }

    public Map<String, EObject> getVariables() {
        return this.getVariables(this.getFrameCount());
    }

    public Map<String, EObject> getVariables(int frameLevel) {
        int currentFrame = 0;
        HashMap<String, EObject> variables = new HashMap<String, EObject>();
        Iterator<Map<String, EObject>> iterator = this.frames.descendingIterator();
        while (iterator.hasNext() && currentFrame < frameLevel) {
            Map<String, EObject> frame = iterator.next();
            for (Map.Entry<String, EObject> entry : frame.entrySet()) {
                variables.put(entry.getKey(), entry.getValue());
            }
            ++currentFrame;
        }
        return variables;
    }

    public void handleLambdaParameters(LambdaLiteral object) {
        FunctionParameter param1;
        FunctionParameter functionParameter = param1 = !object.getFParameters().isEmpty() ? (FunctionParameter)object.getFParameters().get(0) : null;
        if (param1 != null) {
            this.addVariable(param1.getName(), DflFactoryUtils.fromEnclosedExpressionToParent(object.eContainer()));
        } else {
            this.addVariable("$", DflFactoryUtils.fromEnclosedExpressionToParent(object.eContainer()));
        }
    }

    public void handleLambdaParameters(ClojureOperatorOrOrExpression object) {
        if (object == null) {
            return;
        }
        if (object.getClojureOperator() != null) {
            ClojureOperator clojureOperator = object.getClojureOperator();
            FunctionParameter param1 = clojureOperator.getParam1();
            if (param1 != null) {
                this.addVariable(param1.getName(), object.eContainer());
            } else {
                this.addVariable("$", object.eContainer());
            }
        } else if (object.getOrExpression() != null) {
            Expression expression = DflFactoryUtils.fromEnclosedExpressionToChild(object.getOrExpression());
            if (expression instanceof LambdaLiteral && !((LambdaLiteral)expression).getFParameters().isEmpty()) {
                FunctionParameter param1 = (FunctionParameter)((LambdaLiteral)expression).getFParameters().get(0);
                this.addVariable(param1.getName(), object.eContainer());
            } else {
                this.addVariable("$", object.eContainer());
            }
        }
    }

    public void handleVariableDefinitions(Using object) {
        EList parameters = object.getParameters();
        for (VariableDefinition variableDefinition : parameters) {
            Expression variableInitialValue = variableDefinition.getInitialValue();
            if (variableInitialValue instanceof DollarVariable) {
                this.addVariable(variableDefinition.getName(), this.getVariables().get("$"));
                continue;
            }
            if (variableInitialValue instanceof VariableReference) {
                VariableReference variable = (VariableReference)variableInitialValue;
                String variableReference = variable.getReference();
                EObject variableValue = this.getVariables().get(variableReference);
                if (variableValue != null) {
                    this.addVariable(variableDefinition.getName(), variableValue);
                    continue;
                }
                this.addVariable(variableDefinition.getName(), (EObject)variable);
                continue;
            }
            this.addVariable(variableDefinition.getName(), (EObject)variableDefinition.getInitialValue());
        }
    }

    public void handleVariableDefinitions(VariableDirective object) {
        Expression expression = object.getExpression();
        this.addVariable(object.getName(), (EObject)expression);
    }

    public GraphicalEvaluationContext dumpContext() {
        return new StaticContext(this.frames, this.namespaces, this.level);
    }

    public static GraphicalEvaluationContext empty() {
        return new EmptyContext();
    }

    private static final class EmptyContext
    extends GraphicalEvaluationContext {
        public EmptyContext() {
            this.frames = new ArrayDeque();
        }
    }

    private static final class StaticContext
    extends GraphicalEvaluationContext {
        private StaticContext(Deque<Map<String, EObject>> frames, Map<String, String> namespaces, int level) {
            this.level = level;
            this.namespaces = new HashMap<String, String>(namespaces);
            this.frames = new ArrayDeque<Map<String, EObject>>(frames);
        }
    }
}

