/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.graphical.model;

import java.util.Optional;
import org.mule.tooling.dfl.ui.graphical.model.IGraphicalMapping;
import org.mule.tooling.dfl.ui.graphical.model.containers.IMappingInfo;
import org.mule.tooling.dfl.ui.graphical.references.AbstractReference;

public class DefaultGraphicalMapping
implements IGraphicalMapping {
    private int zIndex;
    private IMappingInfo sourceElement;
    private IMappingInfo targetElement;

    public DefaultGraphicalMapping(int zIndex) {
        this.zIndex = zIndex;
    }

    @Override
    public IMappingInfo getSourceElement() {
        if (this.sourceElement == null) {
            this.sourceElement = new EmptyMappingInfo(this);
        }
        return this.sourceElement;
    }

    @Override
    public void setSourceElement(IMappingInfo sourceElement) {
        this.sourceElement = sourceElement;
    }

    @Override
    public IMappingInfo getTargetElement() {
        return this.targetElement;
    }

    @Override
    public void setTargetElement(IMappingInfo targetElement) {
        this.targetElement = targetElement;
    }

    @Override
    public int getZIndex() {
        return this.zIndex;
    }

    public String toString() {
        return "Source: " + String.valueOf(this.sourceElement) + " - Target: " + String.valueOf(this.targetElement) + " zIndex: " + this.zIndex;
    }

    public static final class EmptyMappingInfo
    implements IMappingInfo {
        private IGraphicalMapping mapping;

        public EmptyMappingInfo(IGraphicalMapping mapping) {
            this.mapping = mapping;
        }

        public Optional<AbstractReference> getReference() {
            return Optional.empty();
        }

        @Override
        public void wrap(IMappingInfo mappingInfoToWrap) {
            this.mapping.setSourceElement(mappingInfoToWrap);
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        public String toString() {
            return "EmptyMappingInfo";
        }
    }
}

