/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.graphical.livedata;

import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.mule.weave.v2.runtime.ArrayDataWeaveValue;
import org.mule.weave.v2.runtime.DataWeaveValue;
import org.mule.weave.v2.runtime.ObjectDataWeaveValue;
import scala.Option;

public interface DataWeaveValueSelector {
    public Optional<DataWeaveValue> select(DataWeaveValue var1);

    public static DataWeaveValueSelector selectField(String name) {
        return new ObjectDataWeaveValueSelector(name);
    }

    public static DataWeaveValueSelector selectField(String name, String namespace) {
        return new ObjectDataWeaveValueSelector(name, namespace);
    }

    public static DataWeaveValueSelector selectAttribute(String name, String namespace) {
        return new AttributeDataWeaveValueSelector(name, namespace);
    }

    public static DataWeaveValueSelector selectAttribute(String name) {
        return new AttributeDataWeaveValueSelector(name);
    }

    public static DataWeaveValueSelector selectItem() {
        return new ArrayDataWeaveValueSelector();
    }

    public static class ArrayDataWeaveValueSelector
    implements DataWeaveValueSelector {
        @Override
        public Optional<DataWeaveValue> select(DataWeaveValue value) {
            if (value instanceof ArrayDataWeaveValue) {
                Option selection = ((ArrayDataWeaveValue)value).head();
                if (selection.isEmpty()) {
                    return Optional.empty();
                }
                return Optional.of((DataWeaveValue)selection.get());
            }
            return Optional.empty();
        }

        public String toString() {
            return "[_]";
        }
    }

    public static class AttributeDataWeaveValueSelector
    implements DataWeaveValueSelector {
        private String name;
        private String nameSpace;

        public AttributeDataWeaveValueSelector(String name) {
            this.name = name;
        }

        public AttributeDataWeaveValueSelector(String name, String nameSpace) {
            this.name = name;
            this.nameSpace = nameSpace;
        }

        @Override
        public Optional<DataWeaveValue> select(DataWeaveValue value) {
            Option selection = StringUtils.isBlank((String)this.nameSpace) ? value.selectAttribute(this.name) : value.selectAttribute(this.name, Option.apply((Object)this.nameSpace));
            if (selection.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of((DataWeaveValue)selection.get());
        }

        public String toString() {
            if (StringUtils.isEmpty((String)this.nameSpace)) {
                return ".@" + this.name;
            }
            return ".@{" + this.nameSpace + "}" + this.name;
        }
    }

    public static class ObjectDataWeaveValueSelector
    implements DataWeaveValueSelector {
        private String name;
        private String nameSpace;

        public ObjectDataWeaveValueSelector(String name) {
            this.name = name;
        }

        public ObjectDataWeaveValueSelector(String name, String nameSpace) {
            this.name = name;
            this.nameSpace = nameSpace;
        }

        @Override
        public Optional<DataWeaveValue> select(DataWeaveValue value) {
            if (value instanceof ObjectDataWeaveValue) {
                ObjectDataWeaveValue objectNavigator = (ObjectDataWeaveValue)value;
                Option selection = StringUtils.isBlank((String)this.nameSpace) ? objectNavigator.select(this.name) : objectNavigator.select(this.name, this.nameSpace);
                if (selection.isEmpty()) {
                    return Optional.empty();
                }
                return Optional.of((DataWeaveValue)selection.get());
            }
            return Optional.empty();
        }

        public String toString() {
            if (StringUtils.isEmpty((String)this.nameSpace)) {
                return "." + this.name;
            }
            return ".{" + this.nameSpace + "}" + this.name;
        }
    }
}

