/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.graphical.listener;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.mule.tooling.dfl.ui.graphical.references.AbstractReference;
import org.mule.tooling.dfl.ui.graphical.references.ISegment;
import org.mule.tooling.dfl.ui.graphical.references.TreeReference;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeNode;

public class ExpanderCollapserHandler
implements ITreeViewerListener {
    private TreeViewer leftViewer;
    private TreeViewer rightViewer;
    private List<TreeReference> leftReferences;
    private List<TreeReference> rightReferences;

    public ExpanderCollapserHandler(TreeViewer leftViewer, TreeViewer rightViewer) {
        this.leftViewer = leftViewer;
        this.rightViewer = rightViewer;
        this.storeExpandedPaths();
    }

    public void treeExpanded(TreeExpansionEvent event) {
        this.storeExpandedPaths();
        if (this.leftViewer == event.getTreeViewer()) {
            this.leftReferences.add(TreeReference.of((GraphicalTreeNode)event.getElement()));
        } else if (this.rightViewer == event.getTreeViewer()) {
            this.rightReferences.add(TreeReference.of((GraphicalTreeNode)event.getElement()));
        }
    }

    public void treeCollapsed(TreeExpansionEvent event) {
        this.storeExpandedPaths();
    }

    public void storeExpandedPaths() {
        Object object;
        Object[] expandedTreePaths = this.leftViewer.getExpandedElements();
        this.leftReferences = Lists.newArrayListWithExpectedSize((int)expandedTreePaths.length);
        Object[] objectArray = expandedTreePaths;
        int n = expandedTreePaths.length;
        int n2 = 0;
        while (n2 < n) {
            object = objectArray[n2];
            this.leftReferences.add(TreeReference.of((GraphicalTreeNode)object));
            ++n2;
        }
        expandedTreePaths = this.rightViewer.getExpandedElements();
        this.rightReferences = Lists.newArrayListWithExpectedSize((int)expandedTreePaths.length);
        objectArray = expandedTreePaths;
        n = expandedTreePaths.length;
        n2 = 0;
        while (n2 < n) {
            object = objectArray[n2];
            this.rightReferences.add(TreeReference.of((GraphicalTreeNode)object));
            ++n2;
        }
    }

    public boolean checkLeftItemAvailability(Optional<AbstractReference> optionalReference) {
        boolean isAvailable = false;
        if (optionalReference.isPresent()) {
            AbstractReference abstractReference = (AbstractReference)optionalReference.get();
            int i = 0;
            while (i < this.leftReferences.size()) {
                LinkedList<ISegment> segments;
                TreeReference treeReference = this.leftReferences.get(i);
                LinkedList<ISegment> treeSegments = treeReference.getSegments();
                boolean partialComparisonResult = this.partialSegmentsComparison(treeSegments, segments = abstractReference.getSegments());
                if (partialComparisonResult) {
                    isAvailable = true;
                    break;
                }
                ++i;
            }
        }
        return isAvailable;
    }

    public boolean checkRightItemAvailability(Optional<AbstractReference> optionalReference) {
        boolean isAvailable = false;
        if (optionalReference.isPresent()) {
            AbstractReference abstractReference = (AbstractReference)optionalReference.get();
            int i = 0;
            while (i < this.rightReferences.size()) {
                TreeReference treeReference = this.rightReferences.get(i);
                LinkedList<ISegment> treeSegments = treeReference.getSegments();
                LinkedList<ISegment> segments = abstractReference.getSegments();
                treeSegments.removeFirst();
                boolean partialComparisonResult = this.partialSegmentsComparison(treeSegments, segments);
                if (partialComparisonResult) {
                    isAvailable = true;
                    break;
                }
                ++i;
            }
        }
        return isAvailable;
    }

    private boolean partialSegmentsComparison(List<ISegment> firstSegments, List<ISegment> secondSegments) {
        if (firstSegments.size() != secondSegments.size() - 1) {
            return false;
        }
        boolean equals = true;
        int segmentIndex = 0;
        while (segmentIndex < firstSegments.size() && equals) {
            ISegment variableSegment = firstSegments.get(segmentIndex);
            ISegment canonicalSegment = secondSegments.get(segmentIndex);
            if (!variableSegment.getQName().equals(canonicalSegment.getQName())) {
                equals = false;
            }
            ++segmentIndex;
        }
        return equals;
    }
}

