/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.graphical.code2view;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.dfl.dFL.And;
import org.mule.tooling.dfl.dFL.AnyDateLiteral;
import org.mule.tooling.dfl.dFL.AnyRegexLiteral;
import org.mule.tooling.dfl.dFL.Array;
import org.mule.tooling.dfl.dFL.ArrayElement;
import org.mule.tooling.dfl.dFL.As;
import org.mule.tooling.dfl.dFL.Attribute;
import org.mule.tooling.dfl.dFL.AttributeElement;
import org.mule.tooling.dfl.dFL.Attributes;
import org.mule.tooling.dfl.dFL.BinaryFunction;
import org.mule.tooling.dfl.dFL.Body;
import org.mule.tooling.dfl.dFL.BooleanLiteral;
import org.mule.tooling.dfl.dFL.BracketSelector;
import org.mule.tooling.dfl.dFL.ClojureOperator;
import org.mule.tooling.dfl.dFL.ClojureOperatorOrOrExpression;
import org.mule.tooling.dfl.dFL.ConditionalArrayElement;
import org.mule.tooling.dfl.dFL.Content;
import org.mule.tooling.dfl.dFL.DefaultValueExpression;
import org.mule.tooling.dfl.dFL.DescendantSelector;
import org.mule.tooling.dfl.dFL.Division;
import org.mule.tooling.dfl.dFL.DoBlock;
import org.mule.tooling.dfl.dFL.Document;
import org.mule.tooling.dfl.dFL.DollarVariable;
import org.mule.tooling.dfl.dFL.DotSelector;
import org.mule.tooling.dfl.dFL.DynamicSelector;
import org.mule.tooling.dfl.dFL.EnclosedExpression;
import org.mule.tooling.dfl.dFL.EnclosedObjectElement;
import org.mule.tooling.dfl.dFL.Equal;
import org.mule.tooling.dfl.dFL.Expression;
import org.mule.tooling.dfl.dFL.FilterSelector;
import org.mule.tooling.dfl.dFL.FunctionCall;
import org.mule.tooling.dfl.dFL.GreaterThan;
import org.mule.tooling.dfl.dFL.GreaterThanEqual;
import org.mule.tooling.dfl.dFL.Header;
import org.mule.tooling.dfl.dFL.If;
import org.mule.tooling.dfl.dFL.IntegerLiteral;
import org.mule.tooling.dfl.dFL.Is;
import org.mule.tooling.dfl.dFL.Key;
import org.mule.tooling.dfl.dFL.KeyValuePair;
import org.mule.tooling.dfl.dFL.LambdaLiteral;
import org.mule.tooling.dfl.dFL.LessThan;
import org.mule.tooling.dfl.dFL.LessThanEqual;
import org.mule.tooling.dfl.dFL.Minus;
import org.mule.tooling.dfl.dFL.MultipleKeyValuePairObj;
import org.mule.tooling.dfl.dFL.Multiply;
import org.mule.tooling.dfl.dFL.NamespaceDirective;
import org.mule.tooling.dfl.dFL.Negated;
import org.mule.tooling.dfl.dFL.NotEqual;
import org.mule.tooling.dfl.dFL.NullLiteral;
import org.mule.tooling.dfl.dFL.ObjectElement;
import org.mule.tooling.dfl.dFL.ObjectElements;
import org.mule.tooling.dfl.dFL.ObjectPattern;
import org.mule.tooling.dfl.dFL.Or;
import org.mule.tooling.dfl.dFL.Plus;
import org.mule.tooling.dfl.dFL.QuotedStringLiteral;
import org.mule.tooling.dfl.dFL.RealLiteral;
import org.mule.tooling.dfl.dFL.RightShift;
import org.mule.tooling.dfl.dFL.Similar;
import org.mule.tooling.dfl.dFL.SingleKeyValuePairObj;
import org.mule.tooling.dfl.dFL.UnaryMinus;
import org.mule.tooling.dfl.dFL.Unless;
import org.mule.tooling.dfl.dFL.Using;
import org.mule.tooling.dfl.dFL.ValueSelector;
import org.mule.tooling.dfl.dFL.VariableDirective;
import org.mule.tooling.dfl.dFL.VariableReference;
import org.mule.tooling.dfl.dFL.util.DFLSwitch;
import org.mule.tooling.dfl.ui.graphical.code2view.MappingContext;
import org.mule.tooling.dfl.ui.graphical.model.IGraphicalMapping;
import org.mule.tooling.dfl.ui.graphical.model.LambdaOperator;
import org.mule.tooling.dfl.ui.graphical.model.containers.FunctionMappingInfo;
import org.mule.tooling.dfl.ui.graphical.model.containers.KeyMappingInfo;
import org.mule.tooling.dfl.ui.graphical.model.containers.LambdaMappingInfo;
import org.mule.tooling.dfl.ui.graphical.model.containers.OperatorMappingInfo;
import org.mule.tooling.dfl.ui.graphical.model.containers.ValueMappingInfo;
import org.mule.tooling.dfl.ui.graphical.references.CodeReference;
import org.mule.tooling.dfl.ui.graphical.view2code.generation.DflFactoryUtils;

public class CodeToViewAction
extends DFLSwitch<Void> {
    private MappingContext context;

    protected MappingContext getContext() {
        return this.context;
    }

    public CodeToViewAction(MappingContext context) {
        this.context = context;
    }

    public Void caseDocument(Document object) {
        this.context.startFrame();
        this.doSwitch((EObject)object.getBody());
        this.context.endFrame();
        return null;
    }

    public Void caseDefaultValueExpression(DefaultValueExpression object) {
        this.doSwitch((EObject)object.getElement());
        if (this.context.getCurrentMapping().getSourceElement() == null) {
            this.doSwitch((EObject)object.getDefault());
        }
        return (Void)super.caseDefaultValueExpression(object);
    }

    public Void caseBody(Body object) {
        Header header = object.getHeader();
        if (header != null) {
            this.doSwitch((EObject)header);
        }
        this.doSwitch((EObject)object.getContent());
        return (Void)super.caseBody(object);
    }

    public Void caseHeader(Header object) {
        EList directives;
        if (object != null && (directives = object.getDirectives()) != null) {
            List namespaces = CoreUtils.filterByType((Iterable)directives, NamespaceDirective.class);
            for (NamespaceDirective namespaceDirective : namespaces) {
                this.context.getStructureManager().getNamespaces().put(namespaceDirective.getName(), namespaceDirective.getValue());
            }
            List variables = CoreUtils.filterByType((Iterable)directives, VariableDirective.class);
            for (VariableDirective variableDirective : variables) {
                this.context.handleVariableDefinitions(variableDirective);
            }
        }
        return (Void)super.caseHeader(object);
    }

    public Void caseContent(Content object) {
        IGraphicalMapping currentMapping = this.context.newMapping();
        currentMapping.setTargetElement(new KeyMappingInfo((EObject)object));
        this.context.startMapping(currentMapping);
        Expression expression = object.getElement();
        if (expression != null) {
            this.doSwitch((EObject)expression);
        }
        this.context.endMapping();
        return (Void)super.caseContent(object);
    }

    public Void caseSingleKeyValuePairObj(SingleKeyValuePairObj object) {
        return this.doSwitch((EObject)object.getObjectElement());
    }

    public Void caseMultipleKeyValuePairObj(MultipleKeyValuePairObj object) {
        this.context.startScope();
        ObjectPattern pattern = object.getPattern();
        if (pattern instanceof ObjectElements) {
            for (ObjectElement objectElement : ((ObjectElements)pattern).getObjectElements()) {
                this.context.startChildContext();
                this.doSwitch((EObject)objectElement);
            }
        }
        this.context.endScope();
        return (Void)super.caseMultipleKeyValuePairObj(object);
    }

    public Void caseKeyValuePair(KeyValuePair object) {
        this.context.resetChildContext();
        Key key = object.getKey();
        Expression value = object.getValue();
        if (key != null) {
            this.context.addNode((EObject)key);
            if (key.getAttributes() != null) {
                this.doSwitch((EObject)key.getAttributes());
            }
            IGraphicalMapping currentMapping = this.context.newMapping();
            currentMapping.setTargetElement(new KeyMappingInfo(this.context.getCurrentNode(), CodeReference.of(this.context.getStructureManager())));
            this.context.startMapping(currentMapping);
            this.doSwitch((EObject)value);
            this.context.endMapping();
            this.context.removeNode();
        }
        return (Void)super.caseKeyValuePair(object);
    }

    public Void caseEnclosedObjectElement(EnclosedObjectElement object) {
        if (object.getValue() == null && object.getAttributes() == null && object.getCondition() == null) {
            this.doSwitch((EObject)object.getExpression());
        } else if (object.getExpression() != null && object.getCondition() != null && object.getValue() == null) {
            this.doSwitch((EObject)object.getExpression());
        }
        return null;
    }

    public Void caseEnclosedExpression(EnclosedExpression object) {
        return this.doSwitch((EObject)object.getExpression());
    }

    public Void caseAttributes(Attributes object) {
        for (AttributeElement attributeElement : object.getAttributes()) {
            this.doSwitch((EObject)attributeElement);
        }
        return (Void)super.caseAttributes(object);
    }

    public Void caseAttribute(Attribute object) {
        this.context.addNode((EObject)object);
        IGraphicalMapping currentMapping = this.context.newMapping();
        currentMapping.setTargetElement(new KeyMappingInfo(this.context.getCurrentNode(), CodeReference.of(this.context.getStructureManager())));
        this.context.startMapping(currentMapping);
        this.doSwitch((EObject)object.getValue());
        this.context.endMapping();
        this.context.removeNode();
        return (Void)super.caseAttribute(object);
    }

    public Void caseClojureOperatorOrOrExpression(ClojureOperatorOrOrExpression object) {
        this.context.handleLambdaParameters(object);
        if (object.getOrExpression() != null) {
            this.doSwitch((EObject)object.getOrExpression());
        } else {
            this.doSwitch((EObject)object.getClojureOperator());
        }
        return (Void)super.caseClojureOperatorOrOrExpression(object);
    }

    public Void caseClojureOperator(ClojureOperator object) {
        this.context.addVariable(object.getParam1().getName(), DflFactoryUtils.fromEnclosedExpressionToParent(object.eContainer()));
        return this.doSwitch((EObject)object.getExpression());
    }

    public Void caseLambdaLiteral(LambdaLiteral object) {
        this.context.handleLambdaParameters(object);
        this.doSwitch((EObject)object.getExpression());
        return (Void)super.caseLambdaLiteral(object);
    }

    public Void caseFunctionCall(FunctionCall object) {
        for (Expression expression : object.getParameters().getParameters()) {
            if (expression instanceof LambdaLiteral) continue;
            IGraphicalMapping currentMapping = this.context.newMapping();
            currentMapping.setTargetElement(new KeyMappingInfo(this.context.getCurrentNode(), CodeReference.of(this.context.getStructureManager())));
            this.context.startMapping(currentMapping);
            this.doSwitch((EObject)expression);
            this.context.endMapping();
        }
        IGraphicalMapping currentMapping = this.context.newMapping();
        currentMapping.setTargetElement(new KeyMappingInfo(this.context.getCurrentNode(), CodeReference.of(this.context.getStructureManager())));
        this.context.startMapping(currentMapping);
        this.context.getCurrentMapping().getSourceElement().wrap(new FunctionMappingInfo(object));
        this.context.endMapping();
        return null;
    }

    public Void caseDoBlock(DoBlock object) {
        if (object.getBody().getContent() != null) {
            this.doSwitch((EObject)object.getBody().getContent().getElement());
        }
        return (Void)super.caseDoBlock(object);
    }

    public Void caseDescendantSelector(DescendantSelector object) {
        this.context.getCurrentMapping().getSourceElement().wrap(new OperatorMappingInfo((EObject)object));
        return (Void)super.caseDescendantSelector(object);
    }

    public Void caseDotSelector(DotSelector object) {
        this.context.getCurrentMapping().getSourceElement().wrap(new ValueMappingInfo((EObject)object, CodeReference.of(this.context, (EObject)object)));
        return (Void)super.caseDotSelector(object);
    }

    public Void caseBracketSelector(BracketSelector object) {
        this.doSwitch((EObject)object.getData());
        IGraphicalMapping currentMapping = this.context.newMapping();
        currentMapping.setTargetElement(new KeyMappingInfo(this.context.getCurrentNode(), CodeReference.of(this.context.getStructureManager())));
        this.context.startMapping(currentMapping);
        this.doSwitch((EObject)object.getSelector());
        this.context.endMapping();
        return (Void)super.caseBracketSelector(object);
    }

    public Void caseDynamicSelector(DynamicSelector object) {
        this.doSwitch((EObject)object.getData());
        IGraphicalMapping currentMapping = this.context.newMapping();
        currentMapping.setTargetElement(new KeyMappingInfo(this.context.getCurrentNode(), CodeReference.of(this.context.getStructureManager())));
        this.context.startMapping(currentMapping);
        this.doSwitch((EObject)object.getExpression());
        this.context.endMapping();
        return (Void)super.caseDynamicSelector(object);
    }

    public Void caseFilterSelector(FilterSelector object) {
        this.doSwitch((EObject)object.getData());
        IGraphicalMapping currentMapping = this.context.newMapping();
        currentMapping.setTargetElement(new KeyMappingInfo(this.context.getCurrentNode(), CodeReference.of(this.context.getStructureManager())));
        this.context.startMapping(currentMapping);
        this.doSwitch((EObject)object.getExpression());
        this.context.endMapping();
        return (Void)super.caseFilterSelector(object);
    }

    public Void caseValueSelector(ValueSelector object) {
        this.doSwitch((EObject)object.getData());
        IGraphicalMapping currentMapping = this.context.newMapping();
        currentMapping.setTargetElement(new KeyMappingInfo(this.context.getCurrentNode(), CodeReference.of(this.context.getStructureManager())));
        this.context.startMapping(currentMapping);
        this.doSwitch((EObject)object.getSelector());
        this.context.endMapping();
        return (Void)super.caseValueSelector(object);
    }

    public Void caseDollarVariable(DollarVariable object) {
        this.context.getCurrentMapping().getSourceElement().wrap(new ValueMappingInfo((EObject)object, CodeReference.of(this.context, (EObject)object)));
        return (Void)super.caseDollarVariable(object);
    }

    public Void caseVariableReference(VariableReference object) {
        this.context.getCurrentMapping().getSourceElement().wrap(new ValueMappingInfo((EObject)object, CodeReference.of(this.context, (EObject)object)));
        return (Void)super.caseVariableReference(object);
    }

    public Void caseUsing(Using object) {
        this.context.startFrame();
        this.context.handleVariableDefinitions(object);
        this.doSwitch((EObject)object.getExpression());
        this.context.endFrame();
        return (Void)super.caseUsing(object);
    }

    public Void caseQuotedStringLiteral(QuotedStringLiteral object) {
        this.context.getCurrentMapping().getSourceElement().wrap(new ValueMappingInfo((EObject)object));
        return (Void)super.caseQuotedStringLiteral(object);
    }

    public Void caseRealLiteral(RealLiteral object) {
        this.context.getCurrentMapping().getSourceElement().wrap(new ValueMappingInfo((EObject)object));
        return (Void)super.caseRealLiteral(object);
    }

    public Void caseIntegerLiteral(IntegerLiteral object) {
        this.context.getCurrentMapping().getSourceElement().wrap(new ValueMappingInfo((EObject)object));
        return (Void)super.caseIntegerLiteral(object);
    }

    public Void caseBooleanLiteral(BooleanLiteral object) {
        this.context.getCurrentMapping().getSourceElement().wrap(new ValueMappingInfo((EObject)object));
        return (Void)super.caseBooleanLiteral(object);
    }

    public Void caseAnyDateLiteral(AnyDateLiteral object) {
        this.context.getCurrentMapping().getSourceElement().wrap(new ValueMappingInfo((EObject)object));
        return (Void)super.caseAnyDateLiteral(object);
    }

    public Void caseNullLiteral(NullLiteral object) {
        this.context.getCurrentMapping().getSourceElement().wrap(new ValueMappingInfo((EObject)object));
        return (Void)super.caseNullLiteral(object);
    }

    public Void caseAnyRegexLiteral(AnyRegexLiteral object) {
        this.context.getCurrentMapping().getSourceElement().wrap(new ValueMappingInfo((EObject)object));
        return (Void)super.caseAnyRegexLiteral(object);
    }

    public Void caseUnaryMinus(UnaryMinus object) {
        return this.parseUnaryOperator((Expression)object, object.getExpression());
    }

    public Void caseNegated(Negated object) {
        return this.parseUnaryOperator((Expression)object, object.getExpression());
    }

    public Void caseBinaryFunction(BinaryFunction object) {
        if (DflFactoryUtils.isFunctionNamed((EObject)object, "map")) {
            if (!this.context.isChildContext()) {
                Expression element = object.getElement();
                ClojureOperatorOrOrExpression function = object.getFunction();
                return this.parseLambda(LambdaOperator.MAP, element, function);
            }
            this.handleSpecialCase(object);
            this.context.startChildContext();
            return null;
        }
        if (DflFactoryUtils.isFunctionNamed((EObject)object, "filter")) {
            Expression element = object.getElement();
            ClojureOperatorOrOrExpression function = object.getFunction();
            return this.parseLambda(LambdaOperator.FILTER, element, function);
        }
        if (object.getFunction() != null) {
            Expression left = object.getElement();
            ClojureOperatorOrOrExpression function = object.getFunction();
            if (function.getOrExpression() != null) {
                Expression right = function.getOrExpression();
                return this.parseBinaryOperator((Expression)object, left, right);
            }
            ClojureOperator right = function.getClojureOperator();
            return this.parseBinaryOperator((Expression)object, left, right);
        }
        return (Void)super.caseBinaryFunction(object);
    }

    public Void caseOr(Or object) {
        Expression left = object.getLeft();
        Expression right = object.getRight();
        return this.parseBinaryOperator((Expression)object, left, right);
    }

    public Void caseAnd(And object) {
        Expression left = object.getLeft();
        Expression right = object.getRight();
        return this.parseBinaryOperator((Expression)object, left, right);
    }

    public Void caseEqual(Equal object) {
        Expression left = object.getLeft();
        Expression right = object.getRight();
        return this.parseBinaryOperator((Expression)object, left, right);
    }

    public Void caseNotEqual(NotEqual object) {
        Expression left = object.getLeft();
        Expression right = object.getRight();
        return this.parseBinaryOperator((Expression)object, left, right);
    }

    public Void caseSimilar(Similar object) {
        Expression left = object.getLeft();
        Expression right = object.getRight();
        return this.parseBinaryOperator((Expression)object, left, right);
    }

    public Void caseGreaterThan(GreaterThan object) {
        Expression left = object.getLeft();
        Expression right = object.getRight();
        return this.parseBinaryOperator((Expression)object, left, right);
    }

    public Void caseGreaterThanEqual(GreaterThanEqual object) {
        Expression left = object.getLeft();
        Expression right = object.getRight();
        return this.parseBinaryOperator((Expression)object, left, right);
    }

    public Void caseLessThan(LessThan object) {
        Expression left = object.getLeft();
        Expression right = object.getRight();
        return this.parseBinaryOperator((Expression)object, left, right);
    }

    public Void caseLessThanEqual(LessThanEqual object) {
        Expression left = object.getLeft();
        Expression right = object.getRight();
        return this.parseBinaryOperator((Expression)object, left, right);
    }

    public Void casePlus(Plus object) {
        Expression left = object.getLeft();
        Expression right = object.getRight();
        return this.parseBinaryOperator((Expression)object, left, right);
    }

    public Void caseMinus(Minus object) {
        Expression left = object.getLeft();
        Expression right = object.getRight();
        return this.parseBinaryOperator((Expression)object, left, right);
    }

    public Void caseRightShift(RightShift object) {
        Expression left = object.getLeft();
        Expression right = object.getRight();
        return this.parseBinaryOperator((Expression)object, left, right);
    }

    public Void caseMultiply(Multiply object) {
        Expression left = object.getLeft();
        Expression right = object.getRight();
        return this.parseBinaryOperator((Expression)object, left, right);
    }

    public Void caseDivision(Division object) {
        Expression left = object.getLeft();
        Expression right = object.getRight();
        return this.parseBinaryOperator((Expression)object, left, right);
    }

    public Void caseIf(If object) {
        Expression trueStatement = object.getTrueStatement();
        Expression condition = object.getCondition();
        Expression falseStatement = object.getFalseStatement();
        return this.parseTernaryOperator((Expression)object, trueStatement, condition, falseStatement);
    }

    public Void caseUnless(Unless object) {
        Expression trueStatement = object.getTrueStatement();
        Expression condition = object.getCondition();
        Expression falseStatement = object.getFalseStatement();
        return this.parseTernaryOperator((Expression)object, trueStatement, condition, falseStatement);
    }

    public Void caseAs(As object) {
        this.doSwitch((EObject)object.getElement());
        return (Void)super.caseAs(object);
    }

    public Void caseIs(Is object) {
        this.doSwitch((EObject)object.getElement());
        return (Void)super.caseIs(object);
    }

    public Void caseArray(Array object) {
        DflFactoryUtils.ArrayWrapper wrapper = DflFactoryUtils.from(object);
        for (ArrayElement arrayElement : wrapper.getElements()) {
            this.doSwitch((EObject)arrayElement);
        }
        return (Void)super.caseArray(object);
    }

    public Void caseConditionalArrayElement(ConditionalArrayElement object) {
        this.doSwitch((EObject)object.getExpression());
        IGraphicalMapping currentMapping = this.context.newMapping();
        currentMapping.setTargetElement(new KeyMappingInfo(this.context.getCurrentNode(), CodeReference.of(this.context.getStructureManager())));
        this.context.startMapping(currentMapping);
        this.doSwitch((EObject)object.getCondition());
        this.context.endMapping();
        return (Void)super.caseConditionalArrayElement(object);
    }

    private Void parseTernaryOperator(Expression operator, Expression firstOperand, Expression secondOperand, Expression thirdOperand) {
        this.doSwitch((EObject)firstOperand);
        IGraphicalMapping firstCurrentMapping = this.context.newMapping();
        firstCurrentMapping.setTargetElement(new KeyMappingInfo(this.context.getCurrentNode(), CodeReference.of(this.context.getStructureManager())));
        this.context.startMapping(firstCurrentMapping);
        this.doSwitch((EObject)secondOperand);
        this.context.endMapping();
        IGraphicalMapping secondCurrentMapping = this.context.newMapping();
        secondCurrentMapping.setTargetElement(new KeyMappingInfo(this.context.getCurrentNode(), CodeReference.of(this.context.getStructureManager())));
        this.context.startMapping(secondCurrentMapping);
        this.doSwitch((EObject)thirdOperand);
        this.context.endMapping();
        return null;
    }

    private void handleSpecialCase(BinaryFunction mapLambda) {
        int frameCount = 1;
        ClojureOperatorOrOrExpression function = mapLambda.getFunction();
        this.context.startFrame();
        this.context.handleLambdaParameters(function);
        if (function.getOrExpression() != null) {
            Expression expression = function.getOrExpression();
            if (expression instanceof Using) {
                ++frameCount;
                Using using = (Using)expression;
                this.context.startFrame();
                this.context.handleVariableDefinitions(using);
                expression = using.getExpression();
            } else if (expression instanceof MultipleKeyValuePairObj) {
                MultipleKeyValuePairObj multipleKeyValuePairObj = (MultipleKeyValuePairObj)expression;
                ObjectPattern pattern = multipleKeyValuePairObj.getPattern();
                if (pattern instanceof ObjectElements) {
                    for (ObjectElement objectElement : ((ObjectElements)pattern).getObjectElements()) {
                        this.processObjectElement(mapLambda, objectElement);
                    }
                }
            } else if (this.isLambdaWithMultipleKeyValuePairObj(expression)) {
                LambdaLiteral lambda = (LambdaLiteral)expression;
                MultipleKeyValuePairObj multipleKeyValuePairObj = (MultipleKeyValuePairObj)lambda.getExpression();
                ObjectPattern pattern = multipleKeyValuePairObj.getPattern();
                if (pattern instanceof ObjectElements) {
                    for (ObjectElement objectElement : ((ObjectElements)pattern).getObjectElements()) {
                        this.processObjectElement(mapLambda, objectElement);
                    }
                }
            } else {
                this.doSwitch((EObject)expression);
            }
        } else {
            ClojureOperator clojureOperator = function.getClojureOperator();
            this.doSwitch((EObject)clojureOperator);
        }
        int currentFrame = 0;
        while (currentFrame < frameCount) {
            this.context.endFrame();
            ++currentFrame;
        }
    }

    private void processObjectElement(BinaryFunction mapLambda, ObjectElement objectElement) {
        EnclosedObjectElement enclosedObjectElement;
        if (objectElement instanceof KeyValuePair) {
            KeyValuePair keyValuePair = (KeyValuePair)objectElement;
            Key key = keyValuePair.getKey();
            Expression value = keyValuePair.getValue();
            this.processKeyValuePair(mapLambda, key, value);
        } else if (objectElement instanceof EnclosedObjectElement && (enclosedObjectElement = (EnclosedObjectElement)objectElement).getExpression() instanceof SingleKeyValuePairObj) {
            SingleKeyValuePairObj singleKeyValuePairObj = (SingleKeyValuePairObj)enclosedObjectElement.getExpression();
            this.processObjectElement(mapLambda, (ObjectElement)singleKeyValuePairObj.getObjectElement());
        }
    }

    private void processKeyValuePair(BinaryFunction mapLambda, Key key, Expression value) {
        this.context.addNode((EObject)key);
        if (key.getAttributes() != null) {
            this.doSwitch((EObject)key.getAttributes());
        }
        IGraphicalMapping currentMapping = this.context.newMapping();
        currentMapping.setTargetElement(new KeyMappingInfo(this.context.getCurrentNode(), CodeReference.of(this.context.getStructureManager())));
        this.context.startMapping(currentMapping);
        this.context.getCurrentMapping().getSourceElement().wrap(new LambdaMappingInfo(LambdaOperator.MAP, currentMapping));
        this.doSwitch((EObject)mapLambda.getElement());
        this.context.endMapping();
        this.doSwitch((EObject)value);
        this.context.removeNode();
    }

    private Void parseUnaryOperator(Expression operator, Expression firstOperand) {
        this.context.getCurrentMapping().getSourceElement().wrap(new OperatorMappingInfo((EObject)operator));
        IGraphicalMapping currentMapping = this.context.newMapping();
        currentMapping.setTargetElement(new KeyMappingInfo(this.context.getCurrentNode(), CodeReference.of(this.context.getStructureManager())));
        this.context.startMapping(currentMapping);
        this.doSwitch((EObject)firstOperand);
        this.context.endMapping();
        return null;
    }

    private Void parseBinaryOperator(Expression operator, Expression firstOperand, Expression secondOperand) {
        this.doSwitch((EObject)firstOperand);
        IGraphicalMapping currentMapping = this.context.newMapping();
        currentMapping.setTargetElement(new KeyMappingInfo(this.context.getCurrentNode(), CodeReference.of(this.context.getStructureManager())));
        this.context.startMapping(currentMapping);
        this.doSwitch((EObject)secondOperand);
        this.context.endMapping();
        return null;
    }

    private Void parseBinaryOperator(Expression operator, Expression firstOperand, ClojureOperator secondOperand) {
        this.doSwitch((EObject)firstOperand);
        IGraphicalMapping currentMapping = this.context.newMapping();
        currentMapping.setTargetElement(new KeyMappingInfo(this.context.getCurrentNode(), CodeReference.of(this.context.getStructureManager())));
        this.context.startMapping(currentMapping);
        this.doSwitch((EObject)secondOperand);
        this.context.endMapping();
        return null;
    }

    private Void parseLambda(LambdaOperator lambdaOperator, Expression element, ClojureOperatorOrOrExpression function) {
        IGraphicalMapping currentMapping = this.context.getCurrentMapping();
        currentMapping.getSourceElement().wrap(new LambdaMappingInfo(lambdaOperator, currentMapping));
        this.doSwitch((EObject)element);
        this.context.startFrame();
        this.doSwitch((EObject)function);
        this.context.endFrame();
        return null;
    }

    private boolean isLambdaWithMultipleKeyValuePairObj(Expression expression) {
        return expression instanceof LambdaLiteral && ((LambdaLiteral)expression).getExpression() instanceof MultipleKeyValuePairObj;
    }

    public Void doSwitch(EObject eObject) {
        if (eObject != null) {
            super.doSwitch(eObject);
        }
        return null;
    }
}

