/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.graphical;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Display;
import org.mule.tooling.dfl.ui.highlighting.DFLColors;
import org.mule.tooling.ui.widgets.util.ThemeUtils;
import org.mule.tooling.ui.widgets.util.WidgetUtils;

public final class WeaveUIConstants {
    public static final int ROW_HEIGHT = 25;
    public static final Color CORE_BLUE_3 = new Color((Device)Display.getDefault(), 0, 162, 223);
    public static final Color CORE_BLUE_1 = new Color((Device)Display.getDefault(), 171, 226, 245);
    public static final Color CORE_BLUE_2 = new Color((Device)Display.getDefault(), 72, 193, 237);
    public static final Color CORE_BLUE_4 = new Color((Device)Display.getDefault(), 8, 114, 153);
    public static final Color CORE_BLUE_5 = new Color((Device)Display.getDefault(), 17, 68, 89);
    public static final Color ROBUST_BLUE_3 = new Color((Device)Display.getDefault(), 80, 103, 115);
    public static final Color ROBUST_BLUE_1 = new Color((Device)Display.getDefault(), 161, 177, 184);
    public static final Color ROBUST_BLUE_2 = new Color((Device)Display.getDefault(), 107, 138, 153);
    public static final Color ROBUST_BLUE_4 = new Color((Device)Display.getDefault(), 50, 68, 77);
    public static final Color ROBUST_BLUE_5 = new Color((Device)Display.getDefault(), 39, 47, 51);
    public static final Color FUTURE_GREEN_3 = new Color((Device)Display.getDefault(), 23, 188, 101);
    public static final Color FUTURE_GREEN_1 = new Color((Device)Display.getDefault(), 170, 242, 203);
    public static final Color FUTURE_GREEN_2 = new Color((Device)Display.getDefault(), 51, 204, 122);
    public static final Color FUTURE_GREEN_4 = new Color((Device)Display.getDefault(), 14, 140, 72);
    public static final Color FUTURE_GREEN_5 = new Color((Device)Display.getDefault(), 23, 77, 48);
    public static final Color ALUMINUM_1 = new Color((Device)Display.getDefault(), 249, 250, 251);
    public static final Color ALUMINUM_2 = ThemeUtils.getCurrentTheme().getBackgroundColor();
    public static final Color ALUMINUM_3 = new Color((Device)Display.getDefault(), 232, 233, 234);
    public static final Color ALUMINUM_4 = new Color((Device)Display.getDefault(), 202, 203, 204);
    public static final Color ALUMINUM_5 = ThemeUtils.getCurrentTheme().getForegroundColor();
    public static final Color ALUMINUM_DATA_TYPE = ThemeUtils.getCurrentTheme().getAnnotationRulerColor();
    public static final Color STEEL_1 = new Color((Device)Display.getDefault(), 107, 108, 109);
    public static final Color STEEL_2 = new Color((Device)Display.getDefault(), 88, 89, 90);
    public static final Color STEEL_3 = new Color((Device)Display.getDefault(), 58, 59, 60);
    public static final Color STEEL_4 = new Color((Device)Display.getDefault(), 38, 39, 40);
    public static final Color STEEL_5 = new Color((Device)Display.getDefault(), 18, 19, 20);
    public static final Color YELLOW_3 = new Color((Device)Display.getDefault(), 242, 190, 36);
    public static final Color VIRIDIAN_3 = new Color((Device)Display.getDefault(), 0, 180, 157);
    public static final Color TEAL_3 = new Color((Device)Display.getDefault(), 0, 181, 209);
    public static final Color NAVY_3 = new Color((Device)Display.getDefault(), 23, 139, 234);
    public static final Color INDIGO_3 = new Color((Device)Display.getDefault(), 94, 102, 249);
    public static final Color VIOLET_3 = new Color((Device)Display.getDefault(), 154, 99, 249);
    public static final Color RED_3 = new Color((Device)Display.getDefault(), 209, 52, 78);
    public static final Color STRING_COLOR = new Color((Device)Display.getDefault(), DFLColors.STRING.getColor());
    public static final Color NUMBER_COLOR = new Color((Device)Display.getDefault(), DFLColors.NUMBER.getColor());
    public static final Color KEYWORD_COLOR = new Color((Device)Display.getDefault(), DFLColors.KEYWORD.getColor());
    public static final Color VARIABLE_COLOR = new Color((Device)Display.getDefault(), DFLColors.VARIABLE.getColor());
    public static final Color TYPE_COLOR = new Color((Device)Display.getDefault(), DFLColors.TYPE.getColor());
    public static final Color LIGHT_GRAY = Display.getCurrent().getSystemColor(15);
    public static final Color WHITE = ThemeUtils.getCurrentTheme().getBackgroundColor();
    public static final Color BLACK = Display.getCurrent().getSystemColor(2);
    public static final Font DEFAULT_TEXT_FONT = JFaceResources.getFontRegistry().get("org.eclipse.jface.defaultfont");
    public static final Font DEFAULT_KEYWORD_FONT = JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont");
    public static final StyledString.Styler STRING_STYLE = WeaveUIConstants.createStylerFor(STRING_COLOR, DEFAULT_TEXT_FONT);
    public static final StyledString.Styler NUMBER_STYLE = WeaveUIConstants.createStylerFor(NUMBER_COLOR, DEFAULT_TEXT_FONT);
    public static final StyledString.Styler KEYWORD_STYLE = WeaveUIConstants.createStylerFor(KEYWORD_COLOR, DEFAULT_KEYWORD_FONT);
    public static final StyledString.Styler DEFAULT_STYLE = WeaveUIConstants.createStylerFor(BLACK, DEFAULT_TEXT_FONT);
    public static final StyledString.Styler TYPE_STYLE = WeaveUIConstants.createStylerFor(TYPE_COLOR, DEFAULT_TEXT_FONT);
    public static final StyledString.Styler VARIABLE_STYLE = WeaveUIConstants.createStylerFor(VARIABLE_COLOR, DEFAULT_TEXT_FONT);
    public static final StyledString.Styler MODULE_STYLE = WeaveUIConstants.createStylerFor(LIGHT_GRAY, JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.defaultfont"));
    public static Font CODE_FONT;
    public static Font TITLE_FONT;

    static {
        FontData fontData = JFaceResources.getFontRegistry().get("org.eclipse.jface.defaultfont").getFontData()[0];
        fontData.setHeight(16);
        CODE_FONT = new Font((Device)WidgetUtils.getDisplay(), fontData);
        fontData = JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont").getFontData()[0];
        fontData.setHeight(26);
        TITLE_FONT = new Font((Device)WidgetUtils.getDisplay(), fontData);
    }

    public static StyledString.Styler createStylerFor(final Color foregroundColor, final Font font) {
        return new StyledString.Styler(){

            public void applyStyles(TextStyle textStyle) {
                textStyle.foreground = foregroundColor;
                textStyle.font = font;
            }
        };
    }

    private WeaveUIConstants() {
    }
}

