/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.graphical;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.FilteredTree;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.dfl.ui.DFLExtendedActivator;
import org.mule.tooling.dfl.ui.css.IMappingGraphStyle;
import org.mule.tooling.dfl.ui.css.MappingGraphStyle;
import org.mule.tooling.dfl.ui.graphical.ConnectorEndpoint;
import org.mule.tooling.dfl.ui.graphical.WeaveUIConstants;
import org.mule.tooling.dfl.ui.graphical.events.AutoMappingClickEvent;
import org.mule.tooling.dfl.ui.graphical.events.GraphicalEventTypes;
import org.mule.tooling.dfl.ui.graphical.events.IAutoMappingActivation;
import org.mule.tooling.dfl.ui.graphical.listener.GenericRedrawFunction;
import org.mule.tooling.dfl.ui.graphical.listener.RedrawSelectionChangedListener;
import org.mule.tooling.dfl.ui.graphical.listener.RedrawTreeViewerListener;
import org.mule.tooling.dfl.ui.graphical.listener.ScrollBarSelectionListener;
import org.mule.tooling.dfl.ui.graphical.model.ITreeGraphicalMapping;
import org.mule.tooling.dfl.ui.graphical.model.LambdaOperator;
import org.mule.tooling.dfl.ui.graphical.model.containers.IMappingInfo;
import org.mule.tooling.dfl.ui.graphical.model.containers.IMappingReference;
import org.mule.tooling.dfl.ui.graphical.model.containers.LambdaMappingInfo;
import org.mule.tooling.dfl.ui.graphical.providers.LeftConnectorProvider;
import org.mule.tooling.dfl.ui.graphical.providers.RightConnectorProvider;
import org.mule.tooling.dfl.ui.graphical.references.AbstractReference;
import org.mule.tooling.dfl.ui.graphical.util.GraphicalToolHelper;
import org.mule.tooling.dfl.ui.graphical.util.GraphicalTreeItem;
import org.mule.tooling.dfl.ui.graphical.util.MappingNode;
import org.mule.tooling.dfl.ui.graphical.util.TreeViewerHelper;
import org.mule.tooling.dfl.ui.input.CustomResourceTreeViewer;
import org.mule.tooling.dfl.ui.utils.ImagesHelper;
import org.mule.tooling.ui.splitter.Splitter;
import org.mule.tooling.ui.widgets.SquareButton;
import org.mule.tooling.ui.widgets.util.ThemeUtils;
import org.mule.tooling.utils.eventbus.EventBus;
import org.mule.tooling.utils.eventbus.IEvent;
import org.mule.tooling.utils.eventbus.IEventHandler;

public class MappingPainter
extends Composite
implements PaintListener {
    private Splitter splitter;
    private TreeViewer leftViewer;
    private TreeViewer rightViewer;
    private FilteredTree leftFilteredTree;
    private FilteredTree rightFilteredTree;
    private int leftMargin;
    private int rightMargin;
    private TreeItem hoverItem;
    private boolean showErrorMessage;
    private List<ITreeGraphicalMapping> mappings;
    private final IMappingGraphStyle style = new MappingGraphStyle();
    private static final Image fxImage = ImagesHelper.getImage(ThemeUtils.getCurrentTheme().getDflImgFolder() + "fx-16x16.png");
    private static final Image filterImage = ImagesHelper.getImage("icons/filter.png");
    private static final Image errorMessageImage = ImagesHelper.getImage("icons/error_message.png");
    private static final Image emptyMessageImage = ImagesHelper.getImage("icons/empty_message.png");
    private static final Rectangle fxImageBounds = fxImage.getBounds();
    private static final Rectangle filterImageBounds = filterImage.getBounds();
    private static final IPreferenceStore preferenceStore = DFLExtendedActivator.getInstance().getPreferenceStore();
    private final EventBus eventBus;
    private TreeItem treeItem;
    private SquareButton autoMappingButton;
    private Runnable hideAutoMappingButton;
    private FocusAdapter autoMappingFocusHandler;
    private MenuDetectListener autoMappingMenuHandler;
    private SelectionAdapter autoMappingClickHandler;
    private SelectionAdapter autoMappingChangeSelectionHandler;
    private Optional<TreeItem> lastRootOfSelectedContext;
    private int rightItemHeight = -1;
    private int leftItemHeight = -1;

    public MappingPainter(Composite parent, EventBus eventBus, int style) {
        super(parent, style | 0x20000000);
        this.eventBus = eventBus;
        this.mappings = new ArrayList<ITreeGraphicalMapping>();
        this.autoMappingButton = new SquareButton((Composite)this, 0);
        this.autoMappingButton.setImage(ImagesHelper.getImage("icons/light.png"));
        ThemeUtils.setCssId((Object)this.autoMappingButton, (String)"SquareButtonWithAnchor");
        this.autoMappingButton.setVisible(false);
        this.autoMappingButton.setImagePadding(6);
        this.autoMappingButton.setInnerMarginWidth(0);
        this.autoMappingButton.setRoundedCorners(false);
        this.autoMappingButton.setSquareCornesWithAnchor(true);
        this.autoMappingButton.setToolTipText("Explode mapping");
        Point size = this.autoMappingButton.computeSize(-1, -1);
        this.autoMappingButton.setSize(size);
        this.hideAutoMappingButton = new HideAutoMappingButton(this.autoMappingButton);
        eventBus.registerListener(GraphicalEventTypes.ON_AUTO_MAPPING_ACTIVATION, (IEventHandler)new AutoMappingActivationHandler(this));
        this.registerListeners();
    }

    public List<ITreeGraphicalMapping> getMappings() {
        return this.mappings;
    }

    public void setHoverItem(TreeItem hoverItem) {
        this.hoverItem = hoverItem;
        this.splitter.setHoverItem(hoverItem);
    }

    public void setLeftFilteredTree(FilteredTree leftFilteredTree) {
        this.leftFilteredTree = leftFilteredTree;
        this.leftViewer = leftFilteredTree.getViewer();
        this.registerTreeListeners();
    }

    public void setRightFilteredTree(FilteredTree rightFilteredTree) {
        this.rightFilteredTree = rightFilteredTree;
        this.rightViewer = rightFilteredTree.getViewer();
        this.registerTreeListeners();
    }

    public FilteredTree getLeftFilteredTree() {
        return this.leftFilteredTree;
    }

    public FilteredTree getRightFilteredTree() {
        return this.rightFilteredTree;
    }

    public TreeViewer getLeftViewer() {
        return this.leftViewer;
    }

    public TreeViewer getRightViewer() {
        return this.rightViewer;
    }

    public void reload() {
        if (!this.isDisposed()) {
            this.splitter.redrawSashes();
            this.redraw();
        }
    }

    public void reload(List<ITreeGraphicalMapping> mappings) {
        this.showErrorMessage = false;
        this.mappings = mappings;
        this.lastRootOfSelectedContext = Optional.empty();
        ((CustomResourceTreeViewer)this.leftFilteredTree.getViewer()).setMappingPainter(this);
        ((CustomResourceTreeViewer)this.rightFilteredTree.getViewer()).setMappingPainter(this);
        this.splitter.setConnectorProvider(0, new LeftConnectorProvider(this.leftFilteredTree, this.mappings));
        this.splitter.setConnectorProvider(1, new RightConnectorProvider(this.rightFilteredTree, this.leftFilteredTree, this.mappings));
        if (!this.isDisposed()) {
            this.splitter.redrawSashes();
            this.redraw();
        }
    }

    public void refreshItems() {
        if (this.mappings != null) {
            for (ITreeGraphicalMapping graphicalMapping : this.mappings) {
                graphicalMapping.refresh();
            }
        }
    }

    public void paintControl(PaintEvent pe) {
        if (this.isDisposed()) {
            return;
        }
        this.doPaint(pe);
    }

    protected void doPaint(PaintEvent pe) {
        try {
            this.computeLocationForAutoMappingButton();
            GC gc = pe.gc;
            Tree leftTree = this.getLeftViewer().getTree();
            TreeItem[] leftSelection = leftTree.getSelection();
            Tree rightTree = this.getRightViewer().getTree();
            TreeItem[] rightSelection = rightTree.getSelection();
            Optional<TreeItem> rootOfSelectedContext = TreeViewerHelper.findSelectedContext(leftSelection, this.mappings);
            if (!rootOfSelectedContext.equals(this.lastRootOfSelectedContext)) {
                Collections.sort(this.mappings, new CustomComparator(rootOfSelectedContext));
            }
            this.lastRootOfSelectedContext = rootOfSelectedContext;
            boolean showInitialMessage = true;
            HashSet<TreeItem> fxIndicators = new HashSet<TreeItem>();
            HashSet<ConnectorEndpoint> connectorEndpoints = new HashSet<ConnectorEndpoint>();
            Rectangle leftTreeClientArea = null;
            Rectangle rightTreeClientArea = null;
            if (!this.mappings.isEmpty()) {
                leftTreeClientArea = leftTree.getClientArea();
                rightTreeClientArea = rightTree.getClientArea();
            }
            for (ITreeGraphicalMapping mapping : this.mappings) {
                int yRight;
                int yLeft;
                IMappingInfo sourceElement = mapping.getSourceElement();
                if (sourceElement instanceof LambdaMappingInfo) {
                    LambdaMappingInfo lambda;
                    do {
                        GraphicalTreeItem leftGraphicalTreeItem;
                        if (LambdaOperator.MAP.equals((Object)(lambda = (LambdaMappingInfo)sourceElement).getOperator())) {
                            leftGraphicalTreeItem = mapping.getLeftItem();
                            GraphicalTreeItem rightGraphicalTreeItem = mapping.getRightItem();
                            if (leftGraphicalTreeItem.isDisposed() || rightGraphicalTreeItem.isDisposed()) continue;
                            leftGraphicalTreeItem.computeVisibleItem();
                            rightGraphicalTreeItem.computeVisibleItem();
                            if (!connectorEndpoints.add(new ConnectorEndpoint(leftGraphicalTreeItem.getTreeItem(), rightGraphicalTreeItem.getTreeItem()))) continue;
                            this.rightItemHeight = this.calculateTreeHeight(rightGraphicalTreeItem, this.rightItemHeight);
                            this.leftItemHeight = this.calculateTreeHeight(leftGraphicalTreeItem, this.leftItemHeight);
                            yLeft = leftGraphicalTreeItem.getInitialYAxis(leftTreeClientArea);
                            yRight = rightGraphicalTreeItem.getInitialYAxis(rightTreeClientArea);
                            int leftContextHeight = TreeViewerHelper.calculateHeight(leftGraphicalTreeItem.getTreeItem(), this.leftItemHeight);
                            int rightContextHeight = TreeViewerHelper.calculateHeight(rightGraphicalTreeItem.getTreeItem(), this.rightItemHeight);
                            boolean isMappingInsideContext = false;
                            if (rootOfSelectedContext.isPresent()) {
                                isMappingInsideContext = TreeViewerHelper.isContained(rootOfSelectedContext.get(), leftGraphicalTreeItem.getTreeItem());
                            }
                            showInitialMessage = false;
                            this.paintContext(pe.gc, isMappingInsideContext, yLeft, yRight, leftContextHeight, rightContextHeight);
                            continue;
                        }
                        if (!LambdaOperator.FILTER.equals((Object)lambda.getOperator()) || (leftGraphicalTreeItem = mapping.getLeftItem()).isDisposed()) continue;
                        leftGraphicalTreeItem.computeVisibleItem();
                        this.leftItemHeight = this.calculateTreeHeight(leftGraphicalTreeItem, this.leftItemHeight);
                        int initialLeftY = leftGraphicalTreeItem.getInitialYAxis(leftTreeClientArea);
                        int middleLeftY = leftGraphicalTreeItem.getMiddleYAxis(initialLeftY, this.leftItemHeight);
                        this.painterFilterIcon(pe.gc, initialLeftY, middleLeftY);
                    } while ((sourceElement = lambda.getMappingInfo()) instanceof LambdaMappingInfo);
                    continue;
                }
                GraphicalTreeItem leftGraphicalTreeItem = mapping.getLeftItem();
                GraphicalTreeItem rightGraphicalTreeItem = mapping.getRightItem();
                if (!leftGraphicalTreeItem.isDisposed() && !rightGraphicalTreeItem.isDisposed()) {
                    leftGraphicalTreeItem.computeVisibleItem();
                    rightGraphicalTreeItem.computeVisibleItem();
                    ConnectorEndpoint connector = new ConnectorEndpoint(leftGraphicalTreeItem.getTreeItem(), rightGraphicalTreeItem.getTreeItem());
                    if (!connectorEndpoints.add(connector)) continue;
                    this.rightItemHeight = this.calculateTreeHeight(rightGraphicalTreeItem, this.rightItemHeight);
                    this.leftItemHeight = this.calculateTreeHeight(leftGraphicalTreeItem, this.leftItemHeight);
                    yLeft = leftGraphicalTreeItem.getMiddleYAxis(this.leftItemHeight, leftTreeClientArea);
                    yRight = rightGraphicalTreeItem.getMiddleYAxis(this.rightItemHeight, rightTreeClientArea);
                    boolean selected = this.checkSelection(leftSelection, leftGraphicalTreeItem.getTreeItem()) && this.checkSelection(rightSelection, rightGraphicalTreeItem.getTreeItem());
                    showInitialMessage = false;
                    boolean reachable = leftGraphicalTreeItem.isReachable() && rightGraphicalTreeItem.isReachable();
                    this.paintArrow(gc, reachable, selected, yLeft, yRight, leftGraphicalTreeItem.getTreeItem());
                    continue;
                }
                if (rightGraphicalTreeItem.isDisposed() || sourceElement.isEmpty()) continue;
                rightGraphicalTreeItem.computeVisibleItem();
                if (!fxIndicators.add(rightGraphicalTreeItem.getTreeItem())) continue;
                this.rightItemHeight = this.calculateTreeHeight(rightGraphicalTreeItem, this.rightItemHeight);
                int initialRightY = rightGraphicalTreeItem.getInitialYAxis(rightTreeClientArea);
                int middleRightY = rightGraphicalTreeItem.getMiddleYAxis(initialRightY, this.rightItemHeight);
                this.paintFx(gc, initialRightY, middleRightY);
            }
            if (this.showErrorMessage) {
                this.showMessage(gc, errorMessageImage);
            } else if (showInitialMessage) {
                this.showMessage(gc, emptyMessageImage);
            }
        }
        catch (Exception exception) {
            MuleCorePlugin.logError((String)"Error painting connectors", (Throwable)exception);
        }
    }

    private int calculateTreeHeight(GraphicalTreeItem graphicalTreeItem, int currentHeight) {
        int newHeight = currentHeight;
        if (newHeight == -1) {
            Tree tree = graphicalTreeItem.getTreeItem().getParent();
            newHeight = tree.getItemHeight();
        }
        return newHeight;
    }

    private boolean checkSelection(TreeItem[] selection, TreeItem treeItem) {
        if (selection != null && selection.length != 0) {
            TreeItem[] treeItemArray = selection;
            int n = selection.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem selectedItem = treeItemArray[n2];
                if (selectedItem.equals(treeItem)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private void registerListeners() {
        this.addPaintListener(this);
    }

    private void registerTreeListeners() {
        if (this.getLeftViewer() == null || this.getRightViewer() == null) {
            return;
        }
        ScrollBarSelectionListener<Control> scrollbarListener = new ScrollBarSelectionListener<Control>((Control)this, new GenericRedrawFunction());
        this.getLeftViewer().getTree().getVerticalBar().addSelectionListener(scrollbarListener);
        this.getRightViewer().getTree().getVerticalBar().addSelectionListener(scrollbarListener);
        RedrawTreeViewerListener<Control> treeListener = new RedrawTreeViewerListener<Control>((Control)this, new GenericRedrawFunction());
        this.getLeftViewer().addTreeListener(treeListener);
        this.getRightViewer().addTreeListener(treeListener);
        RedrawSelectionChangedListener<Control> selectionChangedListener = new RedrawSelectionChangedListener<Control>((Control)this, new GenericRedrawFunction());
        this.getLeftViewer().addSelectionChangedListener(selectionChangedListener);
        this.getRightViewer().addSelectionChangedListener(selectionChangedListener);
    }

    public void setInputSplitter(Splitter inputSashForm) {
        this.splitter = inputSashForm;
    }

    public void setLeftMargin(int leftMargin) {
        this.leftMargin = leftMargin;
    }

    public void setRightMargin(int rightMargin) {
        this.rightMargin = rightMargin;
    }

    public IMappingGraphStyle getMappingGraphStyle() {
        return this.style;
    }

    public void showErrorMessage() {
        this.showErrorMessage = true;
    }

    public EventBus getEventBus() {
        return this.eventBus;
    }

    public void hideButton() {
        Display.getDefault().syncExec(this.hideAutoMappingButton);
    }

    private void refreshAutoMappingClickHandler(MappingPainter mappingPainter, MappingNode sourceMappingNode, MappingNode targetMappingNode) {
        if (this.autoMappingClickHandler != null) {
            this.autoMappingButton.removeSelectionListener((SelectionListener)this.autoMappingClickHandler);
        }
        this.autoMappingClickHandler = new AutoMappingClickHandler(mappingPainter, sourceMappingNode, targetMappingNode);
        this.autoMappingButton.addSelectionListener((SelectionListener)this.autoMappingClickHandler);
    }

    private void refreshAutoMappingFocusHandler(MappingPainter mappingPainter) {
        if (this.autoMappingFocusHandler != null) {
            this.treeItem.getParent().removeFocusListener((FocusListener)this.autoMappingFocusHandler);
        }
        this.autoMappingFocusHandler = new AutoMappingFocusHandler(mappingPainter);
        this.treeItem.getParent().addFocusListener((FocusListener)this.autoMappingFocusHandler);
    }

    public void refreshAutoMappingMenuHandler(MappingPainter mappingPainter) {
        if (this.autoMappingMenuHandler != null) {
            this.treeItem.getParent().removeMenuDetectListener(this.autoMappingMenuHandler);
        }
        this.autoMappingMenuHandler = new AutoMappingMenuHandler(mappingPainter);
        this.treeItem.getParent().addMenuDetectListener(this.autoMappingMenuHandler);
    }

    private void refreshAutoMappingSelectionHandler(MappingPainter mappingPainter, TreeItem treeItem) {
        if (this.autoMappingChangeSelectionHandler != null) {
            treeItem.getParent().removeSelectionListener((SelectionListener)this.autoMappingChangeSelectionHandler);
        }
        this.autoMappingChangeSelectionHandler = new AutoMappingChangeSelection(mappingPainter, treeItem);
        treeItem.getParent().addSelectionListener((SelectionListener)this.autoMappingChangeSelectionHandler);
    }

    private void computeLocationForAutoMappingButton() {
        if (!this.autoMappingButton.isDisposed() && this.autoMappingButton.isVisible() && this.treeItem != null) {
            Tree tree = this.treeItem.getParent();
            int initialYAxis = this.treeItem.getTextBounds((int)0).y - tree.getClientArea().y + tree.getHeaderHeight() + this.rightMargin;
            this.autoMappingButton.setLocation(this.getBounds().width - this.autoMappingButton.getSize().x - 6, initialYAxis + 1);
        }
    }

    private void showMessage(GC gc, Image image) {
        Rectangle bounds = this.getBounds();
        int totalWidth = bounds.width;
        int middleX = totalWidth / 2;
        int initialY = bounds.height / 2;
        Rectangle imageBounds = image.getBounds();
        gc.setAlpha(255);
        gc.setForeground(this.style.getMappingLineColor());
        gc.drawImage(image, Math.max(0, middleX - imageBounds.width / 2), Math.max(0, initialY - imageBounds.height / 2 - this.leftMargin / 2));
    }

    private void paintArrow(GC gc, boolean reachable, boolean selected, int leftY, int rightY, TreeItem leftItem) {
        int areaWidth;
        int leftItemY = leftY;
        int rightItemY = rightY;
        leftItemY += this.leftMargin;
        rightItemY += this.rightMargin;
        gc.setAntialias(1);
        if (selected) {
            gc.setAlpha((int)(255.0f * this.style.getMappingSelectedLineOpacity()));
            gc.setBackground(this.style.getMappingSelectedLineColor());
            gc.setForeground(this.style.getMappingSelectedLineColor());
        } else if (leftItem == this.hoverItem) {
            gc.setAlpha((int)(255.0f * this.style.getMappingHoverLineOpacity()));
            gc.setBackground(this.style.getMappingHoverLineColor());
            gc.setForeground(this.style.getMappingHoverLineColor());
        } else {
            gc.setAlpha((int)(255.0f * this.style.getMappingLineOpacity()));
            gc.setBackground(this.style.getMappingLineColor());
            gc.setForeground(this.style.getMappingLineColor());
        }
        gc.setLineWidth(0);
        if (reachable) {
            gc.setLineStyle(this.style.getMappingLineStyle());
        } else {
            gc.setLineStyle(this.style.getUnreachableMappingLineStyle());
            gc.setAlpha((int)(255.0f * this.style.getUnreachableMappingLineOpacity()));
        }
        int finalX = areaWidth = this.getBounds().width;
        if (preferenceStore.getBoolean("dataweave.curvearrow")) {
            int middleX = finalX / 2;
            int firstControlPointCoordX = finalX / 3;
            int lastControlPointCoordX = finalX - 0 - firstControlPointCoordX;
            int middleYBetweenLeftAndRight = leftItemY - (leftItemY - rightItemY) / 2;
            Path path = new Path((Device)Display.getCurrent());
            path.moveTo(0.0f, (float)leftItemY);
            path.quadTo((float)firstControlPointCoordX, (float)leftItemY, (float)middleX, (float)middleYBetweenLeftAndRight);
            path.quadTo((float)lastControlPointCoordX, (float)rightItemY, (float)finalX, (float)rightItemY);
            gc.drawPath(path);
            path.dispose();
        } else {
            gc.drawLine(0, leftItemY, finalX, rightItemY);
        }
    }

    private void paintContext(GC gc, boolean isMappingInsideContext, int leftY, int rightY, int leftContextHeight, int rightContextHeight) {
        int leftItemY = leftY;
        int rightItemY = rightY;
        int lowerLeftItemY = (leftItemY += this.leftMargin) + leftContextHeight;
        int lowerRightItemY = (rightItemY += this.rightMargin) + rightContextHeight;
        gc.setAntialias(1);
        gc.setLineStyle(isMappingInsideContext ? 1 : 3);
        gc.setLineWidth(0);
        int finalX = this.getBounds().width;
        int middleX = finalX / 2;
        int firstControlPointCoordX = finalX / 3;
        int lastControlPointCoordX = finalX - firstControlPointCoordX;
        int middleUpperYBetweenLeftAndRight = leftItemY - (leftItemY - rightItemY) / 2;
        int middleLowerYBetweenLeftAndRight = lowerLeftItemY - (lowerLeftItemY - lowerRightItemY) / 2;
        Path path = new Path((Device)Display.getCurrent());
        path.moveTo(0.0f, (float)leftItemY);
        path.quadTo((float)firstControlPointCoordX, (float)leftItemY, (float)middleX, (float)middleUpperYBetweenLeftAndRight);
        path.quadTo((float)lastControlPointCoordX, (float)rightItemY, (float)finalX, (float)rightItemY);
        path.lineTo((float)finalX, (float)(rightItemY + rightContextHeight));
        path.quadTo((float)lastControlPointCoordX, (float)lowerRightItemY, (float)middleX, (float)middleLowerYBetweenLeftAndRight);
        path.quadTo((float)firstControlPointCoordX, (float)lowerLeftItemY, 0.0f, (float)lowerLeftItemY);
        if (isMappingInsideContext) {
            gc.setAlpha((int)(255.0f * this.style.getMappingSelectedContextBorderOpacity()));
            gc.setForeground(this.style.getMappingSelectedContextBorderColor());
            gc.drawPath(path);
            gc.setAlpha((int)(255.0f * this.style.getMappingSelectedContextOpacity()));
            gc.setBackground(this.style.getMappingSelectedContextColor());
        } else {
            gc.setAlpha((int)(255.0f * this.style.getMappingContextBorderOpacity()));
            gc.setForeground(this.style.getMappingContextBorderColor());
            gc.drawPath(path);
            gc.setAlpha((int)(255.0f * this.style.getMappingContextOpacity()));
            gc.setBackground(this.style.getMappingContextColor());
        }
        gc.fillPath(path);
        path.dispose();
    }

    private void paintFx(GC gc, int initialRightY, int middleRightY) {
        Rectangle bounds = this.getRightFilteredTree().getBounds();
        int maxRightY = bounds.y + bounds.height - this.rightMargin;
        int middleRightItemY = middleRightY;
        if ((middleRightItemY += this.rightMargin) < this.rightMargin || middleRightY > maxRightY) {
            return;
        }
        gc.setAntialias(1);
        gc.setAlpha(255);
        gc.setBackground(WeaveUIConstants.BLACK);
        gc.setForeground(WeaveUIConstants.BLACK);
        gc.setLineStyle(2);
        gc.setLineWidth(0);
        int areaWidth = this.getBounds().width;
        int finalX = areaWidth - MappingPainter.fxImageBounds.width;
        gc.drawImage(fxImage, finalX, middleRightItemY - MappingPainter.fxImageBounds.height / 2);
    }

    private void painterFilterIcon(GC gc, int initialLeftY, int middleLeftY) {
        Rectangle bounds = this.getLeftFilteredTree().getBounds();
        int maxLeftY = bounds.y + bounds.height - this.leftMargin;
        int middleLeftItemY = middleLeftY;
        if ((middleLeftItemY += this.leftMargin) < this.leftMargin || middleLeftY > maxLeftY) {
            return;
        }
        gc.setAntialias(1);
        gc.setAlpha(255);
        gc.setBackground(WeaveUIConstants.BLACK);
        gc.setForeground(WeaveUIConstants.BLACK);
        gc.setLineStyle(2);
        gc.setLineWidth(0);
        gc.drawImage(filterImage, 5, middleLeftItemY - MappingPainter.filterImageBounds.height / 2);
    }

    private static final class AutoMappingActivationHandler
    implements IAutoMappingActivation {
        private MappingPainter mappingPainter;

        public AutoMappingActivationHandler(MappingPainter mappingPainter) {
            this.mappingPainter = mappingPainter;
        }

        @Override
        public void onAutoMappingActivation(MappingNode sourceMappingNode, MappingNode targetMappingNode) {
            TreeItem[] items = this.mappingPainter.rightViewer.getTree().getItems();
            MappingReferenceProvider mappingReferenceProvider = new MappingReferenceProvider(targetMappingNode);
            boolean inputIsXml = GraphicalToolHelper.checkXMLType(mappingReferenceProvider, items);
            int initialSegment = GraphicalToolHelper.isPayloadReference(mappingReferenceProvider) && inputIsXml ? 1 : 0;
            this.mappingPainter.treeItem = GraphicalToolHelper.findTreeItem(mappingReferenceProvider, items, initialSegment);
            this.mappingPainter.computeLocationForAutoMappingButton();
            this.mappingPainter.refreshAutoMappingClickHandler(this.mappingPainter, sourceMappingNode, targetMappingNode);
            this.mappingPainter.refreshAutoMappingFocusHandler(this.mappingPainter);
            this.mappingPainter.refreshAutoMappingMenuHandler(this.mappingPainter);
            this.mappingPainter.refreshAutoMappingSelectionHandler(this.mappingPainter, this.mappingPainter.treeItem);
            this.mappingPainter.treeItem.getParent().setFocus();
            this.mappingPainter.autoMappingButton.setVisible(true);
        }
    }

    private static final class AutoMappingChangeSelection
    extends SelectionAdapter {
        private final TreeItem treeItem;
        private final MappingPainter mappingPainter;

        public AutoMappingChangeSelection(MappingPainter mappingPainter, TreeItem treeItem) {
            this.mappingPainter = mappingPainter;
            this.treeItem = treeItem;
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.item != this.treeItem) {
                this.mappingPainter.hideButton();
            }
        }
    }

    private static final class AutoMappingClickHandler
    extends SelectionAdapter {
        private final MappingPainter mappingPainter;
        private final MappingNode sourceMappingNode;
        private final MappingNode targetMappingNode;

        private AutoMappingClickHandler(MappingPainter mappingPainter, MappingNode sourceMappingNode, MappingNode targetMappingNode) {
            this.mappingPainter = mappingPainter;
            this.sourceMappingNode = sourceMappingNode;
            this.targetMappingNode = targetMappingNode;
        }

        public void widgetSelected(SelectionEvent e) {
            this.mappingPainter.getEventBus().fireEvent((IEvent)new AutoMappingClickEvent(this.sourceMappingNode, this.targetMappingNode));
            this.mappingPainter.hideButton();
        }
    }

    private static final class AutoMappingFocusHandler
    extends FocusAdapter {
        private final MappingPainter mappingPainter;

        public AutoMappingFocusHandler(MappingPainter mappingPainter) {
            this.mappingPainter = mappingPainter;
        }

        public void focusLost(FocusEvent e) {
            Timer timer = new Timer();
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    mappingPainter.hideButton();
                }
            }, 250L);
        }
    }

    private static final class AutoMappingMenuHandler
    implements MenuDetectListener {
        private final MappingPainter mappingPainter;

        public AutoMappingMenuHandler(MappingPainter mappingPainter) {
            this.mappingPainter = mappingPainter;
        }

        public void menuDetected(MenuDetectEvent e) {
            this.mappingPainter.hideButton();
        }
    }

    private static final class CustomComparator
    implements Comparator<ITreeGraphicalMapping> {
        private Optional<TreeItem> rootOfSelectedContext;

        public CustomComparator(Optional<TreeItem> rootOfSelectedContext) {
            this.rootOfSelectedContext = rootOfSelectedContext;
        }

        @Override
        public int compare(ITreeGraphicalMapping element1, ITreeGraphicalMapping element2) {
            boolean element1IsLambda = element1.getSourceElement() instanceof LambdaMappingInfo;
            boolean element2IsLambda = element2.getSourceElement() instanceof LambdaMappingInfo;
            TreeItem leftTreeItemElement1 = element1.getLeftItem().getTreeItem();
            Boolean element1IsInsiseContext = false;
            if (this.rootOfSelectedContext.isPresent()) {
                element1IsInsiseContext = TreeViewerHelper.isContained(this.rootOfSelectedContext.get(), leftTreeItemElement1);
            }
            TreeItem leftTreeItemElement2 = element2.getLeftItem().getTreeItem();
            Boolean element2IsInsideContext = false;
            if (this.rootOfSelectedContext.isPresent()) {
                element2IsInsideContext = TreeViewerHelper.isContained(this.rootOfSelectedContext.get(), leftTreeItemElement2);
            }
            int element1ZIndex = element1.getZIndex();
            int element2ZIndex = element2.getZIndex();
            CompareToBuilder comparator = new CompareToBuilder();
            comparator.append(!element1IsLambda, !element2IsLambda).append((Object)element1IsInsiseContext, (Object)element2IsInsideContext).append(element1ZIndex, element2ZIndex);
            return comparator.toComparison();
        }
    }

    private final class HideAutoMappingButton
    implements Runnable {
        private SquareButton autoMappingButton;

        public HideAutoMappingButton(SquareButton autoMappingButton) {
            this.autoMappingButton = autoMappingButton;
        }

        @Override
        public void run() {
            if (!this.autoMappingButton.isDisposed() && this.autoMappingButton.isVisible()) {
                this.autoMappingButton.setVisible(false);
            }
        }
    }

    private static final class MappingReferenceProvider
    implements IMappingReference {
        private final MappingNode targetMappingNode;

        private MappingReferenceProvider(MappingNode targetMappingNode) {
            this.targetMappingNode = targetMappingNode;
        }

        @Override
        public Optional<? extends AbstractReference> getReference() {
            return Optional.of(this.targetMappingNode.getReference());
        }
    }
}

