/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.embedded.editor.actions;

import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.xtext.ui.editor.embedded.TextViewerAction;
import org.mule.tooling.dfl.ui.utils.Messages;

public class DFLToggleCommentAction
extends TextViewerAction {
    private String fDocumentPartitioning;
    private Map<String, String[]> fPrefixesMap;
    private ITextOperationTarget fOperationTarget;

    public DFLToggleCommentAction(ResourceBundle bundle, String prefix, ITextViewer viewer) {
        super(bundle, prefix, viewer);
    }

    public void run() {
        if (this.fOperationTarget == null || this.fDocumentPartitioning == null || this.fPrefixesMap == null) {
            return;
        }
        final int operationCode = this.isSelectionCommented(this.getTextViewer().getSelectionProvider().getSelection()) ? 12 : 11;
        Shell shell = this.getTextViewer().getTextWidget().getShell();
        if (!this.fOperationTarget.canDoOperation(operationCode)) {
            if (shell != null) {
                MessageDialog.openError((Shell)shell, (String)Messages.ToggleComment_error_title, (String)Messages.ToggleComment_error_message);
            }
            return;
        }
        Display display = null;
        if (shell != null && !shell.isDisposed()) {
            display = shell.getDisplay();
        }
        BusyIndicator.showWhile((Display)display, (Runnable)new Runnable(){

            @Override
            public void run() {
                DFLToggleCommentAction.this.fOperationTarget.doOperation(operationCode);
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isSelectionCommented(ISelection selection) {
        if (!(selection instanceof ITextSelection)) {
            return false;
        }
        ITextSelection textSelection = (ITextSelection)selection;
        if (textSelection.getStartLine() < 0 || textSelection.getEndLine() < 0) {
            return false;
        }
        IDocument document = this.getTextViewer().getDocument();
        try {
            IRegion block = this.getTextBlockFromSelection(textSelection, document);
            ITypedRegion[] regions = TextUtilities.computePartitioning((IDocument)document, (String)this.fDocumentPartitioning, (int)block.getOffset(), (int)block.getLength(), (boolean)false);
            int[] lines = new int[regions.length * 2];
            int i = 0;
            int j = 0;
            while (i < regions.length) {
                lines[j] = this.getFirstCompleteLineOfRegion((IRegion)regions[i], document);
                int length = regions[i].getLength();
                int offset = regions[i].getOffset() + length;
                if (length > 0) {
                    --offset;
                }
                lines[j + 1] = lines[j] == -1 ? -1 : document.getLineOfOffset(offset);
                ++i;
                j += 2;
            }
            i = 0;
            j = 0;
            while (i < regions.length) {
                String[] prefixes = this.fPrefixesMap.get(regions[i].getType());
                if (prefixes != null && prefixes.length > 0 && lines[j] >= 0 && lines[j + 1] >= 0 && !this.isBlockCommented(lines[j], lines[j + 1], prefixes, document)) {
                    return false;
                }
                ++i;
                j += 2;
            }
            return true;
        }
        catch (BadLocationException x) {
            JavaPlugin.log((Throwable)x);
            return false;
        }
    }

    private IRegion getTextBlockFromSelection(ITextSelection selection, IDocument document) {
        try {
            IRegion line = document.getLineInformationOfOffset(selection.getOffset());
            int length = selection.getLength() == 0 ? line.getLength() : selection.getLength() + selection.getOffset() - line.getOffset();
            return new Region(line.getOffset(), length);
        }
        catch (BadLocationException x) {
            JavaPlugin.log((Throwable)x);
            return null;
        }
    }

    private int getFirstCompleteLineOfRegion(IRegion region, IDocument document) {
        int nextLine;
        int offset;
        block4: {
            try {
                int startLine = document.getLineOfOffset(region.getOffset());
                offset = document.getLineOffset(startLine);
                if (offset >= region.getOffset()) {
                    return startLine;
                }
                nextLine = startLine + 1;
                if (nextLine != document.getNumberOfLines()) break block4;
                return -1;
            }
            catch (BadLocationException x) {
                JavaPlugin.log((Throwable)x);
                return -1;
            }
        }
        offset = document.getLineOffset(nextLine);
        return offset > region.getOffset() + region.getLength() ? -1 : nextLine;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isBlockCommented(int startLine, int endLine, String[] prefixes, IDocument document) {
        try {
            int i = startLine;
            while (true) {
                if (i > endLine) {
                    return true;
                }
                IRegion line = document.getLineInformation(i);
                String text = document.get(line.getOffset(), line.getLength());
                int[] found = TextUtilities.indexOf((String[])prefixes, (String)text, (int)0);
                if (found[0] == -1) {
                    return false;
                }
                String s = document.get(line.getOffset(), found[0]);
                if ((s = s.trim()).length() != 0) {
                    return false;
                }
                ++i;
            }
        }
        catch (BadLocationException x) {
            JavaPlugin.log((Throwable)x);
            return false;
        }
    }

    public void update() {
        super.update();
        if (!this.canModifyViewer()) {
            this.setEnabled(false);
            return;
        }
        ITextViewer viewer = this.getTextViewer();
        if (this.fOperationTarget == null && viewer != null) {
            this.fOperationTarget = viewer.getTextOperationTarget();
        }
        boolean isEnabled = this.fOperationTarget != null && this.fOperationTarget.canDoOperation(11) && this.fOperationTarget.canDoOperation(12);
        this.setEnabled(isEnabled);
    }

    public void configure(ISourceViewer sourceViewer, SourceViewerConfiguration configuration) {
        this.fPrefixesMap = null;
        String[] types = configuration.getConfiguredContentTypes(sourceViewer);
        HashMap<String, String[]> prefixesMap = new HashMap<String, String[]>(types.length);
        String[] stringArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            String[] prefixes = configuration.getDefaultPrefixes(sourceViewer, type);
            if (prefixes != null && prefixes.length > 0) {
                int emptyPrefixes = 0;
                String[] stringArray2 = prefixes;
                int n3 = prefixes.length;
                int n4 = 0;
                while (n4 < n3) {
                    String prefixe = stringArray2[n4];
                    if (prefixe.length() == 0) {
                        ++emptyPrefixes;
                    }
                    ++n4;
                }
                if (emptyPrefixes > 0) {
                    String[] nonemptyPrefixes = new String[prefixes.length - emptyPrefixes];
                    int j = 0;
                    int k = 0;
                    while (j < prefixes.length) {
                        String prefix = prefixes[j];
                        if (prefix.length() != 0) {
                            nonemptyPrefixes[k] = prefix;
                            ++k;
                        }
                        ++j;
                    }
                    prefixes = nonemptyPrefixes;
                }
                prefixesMap.put(type, prefixes);
            }
            ++n2;
        }
        this.fDocumentPartitioning = configuration.getConfiguredDocumentPartitioning(sourceViewer);
        this.fPrefixesMap = prefixesMap;
    }
}

