/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.embedded.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.text.Document;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.XtextDocument;
import org.eclipse.xtext.ui.editor.validation.IValidationIssueProcessor;
import org.eclipse.xtext.ui.editor.validation.ValidationJob;
import org.eclipse.xtext.util.concurrent.IReadAccess;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.CheckType;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;
import org.mule.tooling.client.api.PropagationInfo;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.dfl.ui.datasense.IDataSenseProvider;
import org.mule.tooling.dfl.ui.embedded.editor.DataWeaveIssue;
import org.mule.tooling.dfl.ui.ls.DataWeaveLanguageService;
import org.mule.tooling.messageflow.events.IMetadataPropagationFinishedListener;
import org.mule.tooling.messageflow.events.PropagationEventTypes;
import org.mule.tooling.ui.widgets.errors.ErrorManager;
import org.mule.tooling.utils.eventbus.EventBus;
import org.mule.tooling.utils.eventbus.EventBusHelper;
import org.mule.tooling.utils.eventbus.IEventHandler;
import org.mule.weave.v2.editor.ValidationMessage;
import org.mule.weave.v2.editor.ValidationMessages;
import org.mule.weave.v2.parser.Message;
import org.mule.weave.v2.parser.MessageCategoryHelper;
import org.mule.weave.v2.parser.location.Position;
import org.mule.weave.v2.parser.location.WeaveLocation;

public class DFLValidationJob
extends ValidationJob {
    private final XtextDocument document;
    private final Optional<ErrorManager<Document, Issue>> errorManager;
    private final IMuleProject project;
    private IDataSenseProvider dataSenseProvider;
    private EventBusHelper eventBusHelper = new EventBusHelper();

    public DFLValidationJob(IResourceValidator xtextResourceChecker, IReadAccess<XtextResource> xtextDocument, Optional<ErrorManager<Document, Issue>> errorManager, IValidationIssueProcessor validationIssueProcessor, CheckMode checkMode, XtextDocument document, IMuleProject project, IDataSenseProvider dataSenseProvider, EventBus eventBus) {
        super(xtextResourceChecker, xtextDocument, validationIssueProcessor, checkMode);
        this.errorManager = errorManager;
        this.document = document;
        this.project = project;
        this.dataSenseProvider = dataSenseProvider;
        this.eventBusHelper.registerListener(eventBus, PropagationEventTypes.ON_METADATA_PROPAGATION_FINISHED, (IEventHandler)new IMetadataPropagationFinishedListener(){

            public void onMetadataPropagationFinished(PropagationInfo propagationInfo) {
                DFLValidationJob.this.run((IProgressMonitor)new NullProgressMonitor());
            }
        });
    }

    public void dispose() {
        this.eventBusHelper.unregister();
    }

    public List<Issue> createIssues(IProgressMonitor monitor) {
        if (this.errorManager.isPresent()) {
            this.errorManager.get().clearIssues((Object)this.document);
        }
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (this.project.isAccessible()) {
            DataWeaveLanguageService weaveLanguageService = DataWeaveLanguageService.getInstance(this.project);
            ValidationMessages validate = weaveLanguageService.validate(this.document.getResourceURI(), (IXtextDocument)this.document, this.dataSenseProvider, !this.dataSenseProvider.isDataSenseAvailable());
            List errorMessages = Stream.of(validate.errorMessage()).map(error -> this.createIssue((ValidationMessage)error, Severity.ERROR)).collect(Collectors.toList());
            List warningMessages = Stream.of(validate.warningMessage()).map(error -> this.createIssue((ValidationMessage)error, Severity.WARNING)).collect(Collectors.toList());
            ArrayList<Issue> issues = new ArrayList<Issue>();
            issues.addAll(errorMessages);
            issues.addAll(warningMessages);
            if (this.errorManager.isPresent()) {
                for (Issue issue : issues) {
                    this.errorManager.get().addIssue((Object)this.document, (Object)issue);
                }
            }
            return issues;
        }
        return Collections.emptyList();
    }

    private Issue createIssue(ValidationMessage message, Severity severity) {
        Message theMessage = message.message();
        WeaveLocation location = message.location();
        Position startPosition = location.startPosition();
        Position endPosition = location.endPosition();
        DataWeaveIssue result = new DataWeaveIssue(this.document, theMessage.category());
        result.setSyntaxError(true);
        result.setSeverity(severity);
        result.setLineNumber(startPosition.line());
        result.setMessage(theMessage.message());
        result.setOffset(startPosition.index());
        result.setLength(endPosition.index() - startPosition.index());
        result.setType(CheckType.NORMAL);
        result.setQuickFix(message.quickFix());
        result.setSyntaxError(MessageCategoryHelper.isSyntaxMessage((Message)theMessage));
        return result;
    }
}

