/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.embedded.editor;

import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import com.google.inject.Inject;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationPainter;
import org.eclipse.jface.text.source.AnnotationRulerColumn;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.LineNumberRulerColumn;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.text.undo.IDocumentUndoManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextSourceViewer;
import org.eclipse.xtext.ui.editor.XtextSourceViewerConfiguration;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditor;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditorActions;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditorFactory;
import org.eclipse.xtext.ui.editor.embedded.OperationHistoryListener;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.XtextDocument;
import org.eclipse.xtext.ui.editor.model.edit.IModificationContext;
import org.eclipse.xtext.ui.editor.validation.AnnotationIssueProcessor;
import org.eclipse.xtext.ui.editor.validation.IValidationIssueProcessor;
import org.eclipse.xtext.ui.editor.validation.ValidationJob;
import org.eclipse.xtext.util.concurrent.IReadAccess;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.Issue;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.dfl.ui.datasense.IDataSenseProvider;
import org.mule.tooling.dfl.ui.datasense.SelectionRangeManager;
import org.mule.tooling.dfl.ui.embedded.editor.DFLDocumentUndoManagerRegistry;
import org.mule.tooling.dfl.ui.embedded.editor.DFLEmbeddedEditor;
import org.mule.tooling.dfl.ui.embedded.editor.DFLEmbeddedEditorActions;
import org.mule.tooling.dfl.ui.embedded.editor.DFLEmbeddedEditorFoldingStructureProvider;
import org.mule.tooling.dfl.ui.embedded.editor.DFLValidationJob;
import org.mule.tooling.ui.widgets.errors.ErrorManager;
import org.mule.tooling.ui.widgets.util.ThemeUtils;
import org.mule.tooling.utils.eventbus.EventBus;

public class DFLEmbeddedEditorBuilder
extends EmbeddedEditorFactory.Builder {
    private static final String FG_COLOR_KEY = "lineNumberColor";
    private static final String BG_COLOR_KEY = "AbstractTextEditor.Color.Background";
    private static final String USE_DEFAULT_BG_KEY = "AbstractTextEditor.Color.Background.SystemDefault";
    @Inject(optional=true)
    private AnnotationPainter.IDrawingStrategy projectionAnnotationDrawingStrategy;
    @Inject
    SelectionRangeManager selectionManager;
    @Inject
    private DFLEmbeddedEditorFoldingStructureProvider foldingStructureProvider;
    private IAnnotationAccess fAnnotationAccess;
    private boolean lineNumbers;
    private Optional<ErrorManager<Document, Issue>> errorManager;
    private IMuleProject project;
    private IDataSenseProvider dataSenseProvider;
    private EventBus eventBus;
    private boolean oneLiner = false;

    protected IAnnotationAccess createAnnotationAccess() {
        return new DefaultMarkerAnnotationAccess(){

            public int getLayer(Annotation annotation) {
                if (annotation.isMarkedDeleted()) {
                    return 0;
                }
                return super.getLayer(annotation);
            }
        };
    }

    protected IAnnotationAccess getAnnotationAccess() {
        if (this.fAnnotationAccess == null) {
            this.fAnnotationAccess = this.createAnnotationAccess();
        }
        return this.fAnnotationAccess;
    }

    protected ISharedTextColors getSharedColors() {
        return EditorsPlugin.getDefault().getSharedTextColors();
    }

    protected ProjectionSupport installProjectionSupport(EmbeddedEditor e, ProjectionViewer projectionViewer) {
        ProjectionSupport projectionSupport = new ProjectionSupport(projectionViewer, this.getAnnotationAccess(), this.getSharedColors());
        projectionSupport.setAnnotationPainterDrawingStrategy(this.projectionAnnotationDrawingStrategy);
        projectionSupport.install();
        return projectionSupport;
    }

    public DFLEmbeddedEditorBuilder showLineNumbers() {
        this.lineNumbers = true;
        return this;
    }

    public DFLEmbeddedEditorBuilder oneLiner(boolean oneliner) {
        this.oneLiner = oneliner;
        return this;
    }

    public DFLEmbeddedEditor withParent(final Composite parent) {
        if (this.editorBuild) {
            throw new IllegalStateException();
        }
        this.editorBuild = true;
        CompositeRuler annotationRuler = this.annotationTypes != null && this.annotationTypes.length != 0 ? new CompositeRuler() : null;
        int styles = 768;
        if (this.oneLiner) {
            styles = 512;
        }
        XtextSourceViewer viewer = this.sourceViewerFactory.createSourceViewer(parent, (IVerticalRuler)annotationRuler, null, false, styles);
        XtextSourceViewerConfiguration viewerConfiguration = (XtextSourceViewerConfiguration)this.sourceViewerConfigurationProvider.get();
        viewer.configure((SourceViewerConfiguration)viewerConfiguration);
        StyledText textWidget = viewer.getTextWidget();
        textWidget.setFont(JFaceResources.getFont((String)"org.eclipse.jface.textfont"));
        if (this.oneLiner) {
            textWidget.setWordWrap(true);
        }
        final SourceViewerDecorationSupport viewerDecorationSupport = new SourceViewerDecorationSupport((ISourceViewer)viewer, null, this.getAnnotationAccess(), this.getSharedColors());
        MarkerAnnotationPreferences annotationPreferences = new MarkerAnnotationPreferences();
        UnmodifiableIterator e = Iterators.filter(annotationPreferences.getAnnotationPreferences().iterator(), AnnotationPreference.class);
        while (e.hasNext()) {
            viewerDecorationSupport.setAnnotationPreference((AnnotationPreference)e.next());
        }
        if (this.characterPairMatcher != null) {
            viewerDecorationSupport.setCharacterPairMatcher(this.characterPairMatcher);
            viewerDecorationSupport.setMatchingCharacterPainterPreferenceKeys("CharacterMatching", "CharacterMatching.Color");
        }
        viewerDecorationSupport.install(this.preferenceStoreAccess.getPreferenceStore());
        XtextDocument document = (XtextDocument)this.documentProvider.get();
        IDocumentPartitioner partitioner = (IDocumentPartitioner)this.documentPartitionerProvider.get();
        partitioner.connect((IDocument)document);
        document.setDocumentPartitioner(partitioner);
        final EmbeddedEditorActions actions = this.initializeActions((SourceViewer)viewer);
        ((DFLEmbeddedEditorActions)actions).initializeActionsForSourceViewerConfiguration((SourceViewerConfiguration)viewerConfiguration);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                viewerDecorationSupport.dispose();
                DFLEmbeddedEditorBuilder.this.highlightingHelper.uninstall();
            }
        });
        viewer.setEditable(!Boolean.TRUE.equals(this.readonly));
        viewer.getContentAssistantFacade().addCompletionListener(new ICompletionListener(){
            private Button defaultButton;

            public void selectionChanged(ICompletionProposal proposal, boolean smartToggle) {
            }

            public void assistSessionStarted(ContentAssistEvent event) {
                this.defaultButton = parent.getShell().getDefaultButton();
                parent.getShell().setDefaultButton(null);
            }

            public void assistSessionEnded(ContentAssistEvent event) {
                parent.getShell().setDefaultButton(this.defaultButton);
                this.defaultButton = null;
            }
        });
        DataWeaveIssueProcessor dataWeaveIssueProcessor = new DataWeaveIssueProcessor(document, viewer);
        DFLValidationJob validationJob = new DFLValidationJob(this.resourceValidator, (IReadAccess<XtextResource>)document, this.errorManager, dataWeaveIssueProcessor, CheckMode.FAST_ONLY, document, this.project, this.dataSenseProvider, this.eventBus);
        document.setValidationJob((Job)validationJob);
        parent.addDisposeListener(event -> validationJob.dispose());
        DFLEmbeddedEditor result = new DFLEmbeddedEditor(document, viewer, viewerConfiguration, this.resourceProvider, this.selectionManager, new DFLAfterDocumentSetProcessor(document, validationJob, viewerConfiguration, annotationRuler, actions, viewer)){

            @Override
            public Optional<IAction> getAction(String actionId) {
                if (actions instanceof DFLEmbeddedEditorActions) {
                    return Optional.ofNullable(((DFLEmbeddedEditorActions)actions).getAction(ITextEditorActionConstants.FIND));
                }
                return Optional.empty();
            }

            @Override
            public void cleanDisposeListener() {
                if (actions instanceof DFLEmbeddedEditorActions) {
                    ((DFLEmbeddedEditorActions)actions).cleanDisposeListener();
                }
            }
        };
        Control control = viewer.getControl();
        GridDataFactory.fillDefaults().grab(true, true).applyTo(control);
        this.installProjectionSupport(result, (ProjectionViewer)viewer);
        this.foldingStructureProvider.install(result, (ProjectionViewer)viewer);
        return result;
    }

    public void setEventBus(EventBus eventBus) {
        this.eventBus = eventBus;
    }

    protected OperationHistoryListener installUndoRedoSupport(SourceViewer viewer, IDocument document, final EmbeddedEditorActions actions) {
        IDocumentUndoManager undoManager = DFLDocumentUndoManagerRegistry.getDocumentUndoManager(document);
        IUndoContext context = undoManager.getUndoContext();
        IOperationHistory operationHistory = PlatformUI.getWorkbench().getOperationSupport().getOperationHistory();
        OperationHistoryListener operationHistoryListener = new OperationHistoryListener(context, new IUpdate(){

            public void update() {
                ((DFLEmbeddedEditorActions)actions).updateAction(ITextEditorActionConstants.REDO);
                ((DFLEmbeddedEditorActions)actions).updateAction(ITextEditorActionConstants.UNDO);
            }
        });
        operationHistory.addOperationHistoryListener((IOperationHistoryListener)operationHistoryListener);
        return operationHistoryListener;
    }

    private void updateForegroundColor(IPreferenceStore store, IVerticalRulerColumn column) {
        RGB rgb = DFLEmbeddedEditorBuilder.getColorFromStore(store, FG_COLOR_KEY);
        if (rgb == null) {
            rgb = new RGB(0, 0, 0);
        }
        ISharedTextColors sharedColors = this.getSharedColors();
        if (column instanceof LineNumberRulerColumn) {
            ((LineNumberRulerColumn)column).setForeground(sharedColors.getColor(rgb));
        }
    }

    private void updateBackgroundColor(IPreferenceStore store, IVerticalRulerColumn column) {
        RGB rgb = store.getBoolean(USE_DEFAULT_BG_KEY) ? null : DFLEmbeddedEditorBuilder.getColorFromStore(store, BG_COLOR_KEY);
        ISharedTextColors sharedColors = this.getSharedColors();
        if (column instanceof LineNumberRulerColumn) {
            ((LineNumberRulerColumn)column).setBackground(sharedColors.getColor(rgb));
        }
    }

    private static RGB getColorFromStore(IPreferenceStore store, String key) {
        RGB rgb = null;
        if (store.contains(key)) {
            rgb = store.isDefault(key) ? PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)key) : PreferenceConverter.getColor((IPreferenceStore)store, (String)key);
        }
        return rgb;
    }

    public void setErrorManager(Optional<ErrorManager<Document, Issue>> errorManager) {
        this.errorManager = errorManager;
    }

    public void setMuleProject(IMuleProject project) {
        this.project = project;
    }

    public void setDataSenseProvider(IDataSenseProvider dataSenseProvider) {
        this.dataSenseProvider = dataSenseProvider;
    }

    private final class DFLAfterDocumentSetProcessor
    implements Runnable {
        private final XtextDocument document;
        private final ValidationJob validationJob;
        private final XtextSourceViewerConfiguration viewerConfiguration;
        private final CompositeRuler annotationRuler;
        private final EmbeddedEditorActions actions;
        private final XtextSourceViewer viewer;

        private DFLAfterDocumentSetProcessor(XtextDocument document, ValidationJob validationJob, XtextSourceViewerConfiguration viewerConfiguration, CompositeRuler annotationRuler, EmbeddedEditorActions actions, XtextSourceViewer viewer) {
            this.document = document;
            this.validationJob = validationJob;
            this.viewerConfiguration = viewerConfiguration;
            this.annotationRuler = annotationRuler;
            this.actions = actions;
            this.viewer = viewer;
        }

        @Override
        public void run() {
            DFLEmbeddedEditorBuilder.this.afterCreatePartialEditor(this.viewer, this.document, this.annotationRuler, this.actions);
            DFLEmbeddedEditorBuilder.this.highlightingHelper.install(this.viewerConfiguration, this.viewer);
            if (DFLEmbeddedEditorBuilder.this.lineNumbers) {
                LineNumberRulerColumn lineNumberColumn = new LineNumberRulerColumn();
                DFLEmbeddedEditorBuilder.this.updateForegroundColor(DFLEmbeddedEditorBuilder.this.preferenceStoreAccess.getPreferenceStore(), (IVerticalRulerColumn)lineNumberColumn);
                DFLEmbeddedEditorBuilder.this.updateBackgroundColor(DFLEmbeddedEditorBuilder.this.preferenceStoreAccess.getPreferenceStore(), (IVerticalRulerColumn)lineNumberColumn);
                this.annotationRuler.addDecorator(2, (IVerticalRulerColumn)lineNumberColumn);
            }
            if (this.annotationRuler != null) {
                Iterator decoratorIterator = this.annotationRuler.getDecoratorIterator();
                while (decoratorIterator.hasNext()) {
                    Object next = decoratorIterator.next();
                    if (!(next instanceof AnnotationRulerColumn)) continue;
                    AnnotationRulerColumn annotationRulerColumn = (AnnotationRulerColumn)next;
                    RGB annotationRulerColor = ThemeUtils.getCurrentTheme().getAnnotationRulerColor().getRGB();
                    annotationRulerColumn.getControl().setBackground(DFLEmbeddedEditorBuilder.this.getSharedColors().getColor(annotationRulerColor));
                }
                this.viewer.doOperation(19);
            }
            this.validationJob.schedule();
        }
    }

    private final class DataWeaveIssueProcessor
    implements IValidationIssueProcessor {
        private final XtextDocument document;
        private final XtextSourceViewer viewer;
        private AnnotationIssueProcessor annotationIssueProcessor;

        private DataWeaveIssueProcessor(XtextDocument document, XtextSourceViewer viewer) {
            this.document = document;
            this.viewer = viewer;
        }

        public void processIssues(List<Issue> issues, IProgressMonitor monitor) {
            IAnnotationModel annotationModel;
            IValidationIssueProcessor issueProcessor = DFLEmbeddedEditorBuilder.this.issueProcessor;
            if (issueProcessor != null) {
                issueProcessor.processIssues(issues, monitor);
            }
            if ((annotationModel = this.viewer.getAnnotationModel()) != null) {
                if (this.annotationIssueProcessor == null) {
                    this.annotationIssueProcessor = new AnnotationIssueProcessor((IXtextDocument)this.document, annotationModel, DFLEmbeddedEditorBuilder.this.issueResolutionProvider);
                }
                if (this.annotationIssueProcessor != null) {
                    this.annotationIssueProcessor.processIssues(issues, monitor);
                }
            }
        }
    }

    public static final class DataWeaveModificationContext
    implements IModificationContext {
        private final XtextDocument document;

        public DataWeaveModificationContext(XtextDocument document) {
            this.document = document;
        }

        public IXtextDocument getXtextDocument(URI uri) {
            if (uri.trimFragment().equals(this.document.getResourceURI())) {
                return this.document;
            }
            return null;
        }

        public IXtextDocument getXtextDocument() {
            return this.document;
        }
    }
}

