/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.embedded.editor;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ActiveShellExpression;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.texteditor.FindReplaceAction;
import org.eclipse.ui.texteditor.IAbstractTextEditorHelpContextIds;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.xtext.ui.editor.ISourceViewerAware;
import org.eclipse.xtext.ui.editor.embedded.ActivationCodeTrigger;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditorActions;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditorMessages;
import org.eclipse.xtext.ui.editor.embedded.TextViewerOperationAction;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.dfl.ui.embedded.editor.actions.DFLToggleCommentAction;
import org.mule.tooling.dfl.ui.utils.Messages;
import org.mule.tooling.utils.Pair;
import org.mule.tooling.utils.SilentRunner;

public class DFLEmbeddedEditorActions
extends EmbeddedEditorActions {
    private static final String WEAVE_EMBEDDED_ACTION_EXTENSION_ID = "org.mule.tooling.dfl.ui.weaveEmbeddedContextMenuAction";
    private Shell shell;
    private DisposeListener disposeListener;
    private List<Pair<String, String>> contextMenuActions;

    public DFLEmbeddedEditorActions(ISourceViewer viewer, IWorkbench workbench) {
        super(viewer, workbench);
    }

    public IAction getAction(String actionId) {
        return this.get(actionId);
    }

    public void cleanDisposeListener() {
        this.disposeListener.widgetDisposed(null);
        this.removeDisposeListener();
    }

    private void removeDisposeListener() {
        if (this.shell != null) {
            this.shell.removeDisposeListener(this.disposeListener);
            this.shell = null;
        }
    }

    public void initializeActionsForSourceViewerConfiguration(SourceViewerConfiguration configuration) {
        ((DFLToggleCommentAction)this.getAction("ToggleComment")).configure(this.viewer, configuration);
    }

    protected void initialize() {
        ArrayList handlerActivations = Lists.newArrayListWithExpectedSize((int)3);
        IHandlerService handlerService = (IHandlerService)this.workbench.getAdapter(IHandlerService.class);
        IContextService contextService = (IContextService)this.workbench.getAdapter(IContextService.class);
        StyledText viewerWidget = this.viewer.getTextWidget();
        this.shell = viewerWidget.getShell();
        ActiveShellExpression expression = new ActiveShellExpression(this.shell);
        IContextActivation contextActivation = contextService.activateContext("org.eclipse.xtext.ui.embeddedTextEditorScope", (Expression)expression);
        MenuManager manager = new MenuManager(null, null);
        IMenuListener menuListener = new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                DFLEmbeddedEditorActions.this.fillContextMenu(mgr);
            }
        };
        this.disposeListener = e -> {
            this.removeDisposeListener();
            contextService.deactivateContext(contextActivation);
            this.deactivateHandlers(handlerActivations, handlerService);
            manager.removeMenuListener(menuListener);
        };
        this.shell.addDisposeListener(this.disposeListener);
        viewerWidget.addDisposeListener(this.disposeListener);
        viewerWidget.addFocusListener(FocusListener.focusLostAdapter(e -> this.deactivateHandlers(handlerActivations, handlerService)));
        viewerWidget.addFocusListener(FocusListener.focusGainedAdapter(e -> this.activateHandlers(handlerActivations, handlerService, expression)));
        this.createActions();
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(menuListener);
        Menu menu = manager.createContextMenu((Control)viewerWidget);
        viewerWidget.setMenu(menu);
        ArrayList activationCodes = Lists.newArrayList();
        this.setActionActivationCode(activationCodes, "ShiftRightTab", '\t', -1, 0);
        this.setActionActivationCode(activationCodes, "ShiftLeft", '\t', -1, 131072);
        viewerWidget.addVerifyKeyListener((VerifyKeyListener)new ActivationCodeTrigger(this.allActions, (List)activationCodes));
    }

    private void activateHandlers(List<IHandlerActivation> handlerActivations, IHandlerService handlerService, ActiveShellExpression expression) {
        for (IAction action : this.allActions.values()) {
            handlerActivations.add(handlerService.activateHandler(action.getActionDefinitionId(), (IHandler)new ActionHandler(action), (Expression)expression, true));
        }
    }

    private void deactivateHandlers(List<IHandlerActivation> handlerActivations, IHandlerService handlerService) {
        if (!handlerActivations.isEmpty()) {
            handlerService.deactivateHandlers(handlerActivations);
            handlerActivations.clear();
        }
    }

    protected void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        menu.appendToGroup("group.generate", (IAction)this.allActions.get("Format"));
        if (this.contextMenuActions == null) {
            return;
        }
        for (Pair<String, String> pair : this.contextMenuActions) {
            String left = (String)pair.getLeft();
            if (StringUtils.isNotBlank((String)left)) {
                menu.appendToGroup(left, (IAction)this.allActions.get(pair.getRight()));
                continue;
            }
            menu.add((IAction)this.allActions.get(pair.getRight()));
        }
    }

    protected void createActions() {
        super.createActions();
        Shell activeShell = Display.getDefault().getActiveShell();
        IFindReplaceTarget replaceTarget = this.viewer.getFindReplaceTarget();
        if (activeShell != null && replaceTarget != null) {
            FindReplaceAction action = new FindReplaceAction(EmbeddedEditorMessages.getBundleForConstructedKeys(), "Editor.FindReplace.", activeShell, replaceTarget);
            action.setHelpContextId(IAbstractTextEditorHelpContextIds.FIND_ACTION);
            action.setActionDefinitionId("org.eclipse.ui.edit.findReplace");
            this.setAction(ITextEditorActionConstants.FIND, (IAction)action);
            action = new TextViewerOperationAction(Messages.getResourceBundle(), "Format.", (ITextViewer)this.viewer, 15);
            action.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.format");
            action.setAccelerator(SWT.MOD1 | SWT.MOD2 | 0x46);
            this.setAction("Format", (IAction)action);
        } else {
            MuleCorePlugin.logWarning((String)"activeShell or replaceTarget were null");
        }
        DFLToggleCommentAction toggleAction = new DFLToggleCommentAction(Messages.getResourceBundle(), "ToggleComment.", (ITextViewer)this.viewer);
        toggleAction.setHelpContextId("org.eclipse.jdt.ui.toggle_comment_action");
        toggleAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.toggle.comment");
        this.setAction("ToggleComment", (IAction)toggleAction);
        this.initExtensionPointActions();
    }

    private void initExtensionPointActions() {
        IConfigurationElement[] configurationElementsFor;
        IConfigurationElement[] iConfigurationElementArray = configurationElementsFor = Platform.getExtensionRegistry().getConfigurationElementsFor(WEAVE_EMBEDDED_ACTION_EXTENSION_ID);
        int n = configurationElementsFor.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            SilentRunner.run(() -> {
                IAction action = (IAction)element.createExecutableExtension("class");
                String id = element.getAttribute("id");
                String inContextMenu = element.getAttribute("contextMenu");
                if (action instanceof ISourceViewerAware) {
                    ((ISourceViewerAware)action).setSourceViewer(this.viewer);
                }
                this.setAction(id, action);
                if (StringUtils.isNotBlank((String)inContextMenu) && Boolean.parseBoolean(inContextMenu)) {
                    String group = element.getAttribute("group");
                    this.addContextMenuAction(id, group);
                }
            });
            ++n2;
        }
    }

    private void addContextMenuAction(String id, String group) {
        if (this.contextMenuActions == null) {
            this.contextMenuActions = new ArrayList<Pair<String, String>>();
        }
        this.contextMenuActions.add((Pair<String, String>)new Pair((Object)group, (Object)id));
    }

    public void updateAction(String actionId) {
        super.updateAction(actionId);
    }
}

