/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.embedded.editor;

import java.util.Iterator;
import java.util.Optional;
import org.eclipse.jface.action.IAction;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.ui.editor.XtextSourceViewer;
import org.eclipse.xtext.ui.editor.XtextSourceViewerConfiguration;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditor;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditorModelAccess;
import org.eclipse.xtext.ui.editor.embedded.IEditedResourceProvider;
import org.eclipse.xtext.ui.editor.model.XtextDocument;
import org.eclipse.xtext.ui.editor.validation.XtextAnnotation;
import org.mule.tooling.dfl.ui.datasense.SelectionRangeManager;

public abstract class DFLEmbeddedEditor
extends EmbeddedEditor {
    private EmbeddedEditorModelAccess editorModelAccess;
    private SelectionRangeManager selectionManager;
    private Long lastStampValue;

    public DFLEmbeddedEditor(XtextDocument document, XtextSourceViewer viewer, XtextSourceViewerConfiguration configuration, IEditedResourceProvider resourceProvider, SelectionRangeManager selectionManager, Runnable afterSetDocumet) {
        super(document, viewer, configuration, resourceProvider, afterSetDocumet);
        this.setSelectionManager(selectionManager);
    }

    public abstract void cleanDisposeListener();

    public abstract Optional<IAction> getAction(String var1);

    public EmbeddedEditorModelAccess getEditorModelAccess() {
        return this.editorModelAccess;
    }

    public void setEditorModelAccess(EmbeddedEditorModelAccess editorModelAccess) {
        this.editorModelAccess = editorModelAccess;
    }

    public SelectionRangeManager getSelectionManager() {
        return this.selectionManager;
    }

    public void setSelectionManager(SelectionRangeManager selectionManager) {
        this.selectionManager = selectionManager;
    }

    public void setTextDocument(String textDocument) {
        this.getDocument().set(textDocument);
    }

    public String getTextDocument() {
        return this.getDocument().get();
    }

    public XtextDocument getDocument() {
        return super.getDocument();
    }

    public XtextSourceViewer getViewer() {
        return super.getViewer();
    }

    public boolean haveErrors() {
        Iterator annotationIterator = this.getViewer().getAnnotationModel().getAnnotationIterator();
        while (annotationIterator.hasNext()) {
            XtextAnnotation annotation;
            Object object = annotationIterator.next();
            if (!(object instanceof XtextAnnotation) || !Severity.ERROR.equals((Object)(annotation = (XtextAnnotation)object).getIssue().getSeverity())) continue;
            return true;
        }
        return false;
    }

    public EmbeddedEditorModelAccess createPartialEditor(String prefix, String editablePart, String suffix, boolean insertLineBreaks) {
        EmbeddedEditorModelAccess eema = super.createPartialEditor(prefix, editablePart, suffix, insertLineBreaks);
        this.lastStampValue = this.getDocument().getModificationStamp();
        return eema;
    }

    public boolean isDocumentModified() {
        if (this.lastStampValue.longValue() == this.getDocument().getModificationStamp()) {
            return false;
        }
        this.lastStampValue = this.getDocument().getModificationStamp();
        return true;
    }
}

