/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.embedded.editor;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.undo.IDocumentUndoManager;
import org.mule.tooling.dfl.ui.embedded.editor.DFLDocumentUndoManager;

public final class DFLDocumentUndoManagerRegistry {
    private static Map fgFactory = new HashMap();

    private DFLDocumentUndoManagerRegistry() {
    }

    public static synchronized void connect(IDocument document) {
        Assert.isNotNull((Object)document);
        Record record = (Record)fgFactory.get(document);
        if (record == null) {
            record = new Record(document);
            fgFactory.put(document, record);
        }
        ++record.count;
    }

    public static synchronized void disconnect(IDocument document) {
        Assert.isNotNull((Object)document);
        Record record = (Record)fgFactory.get(document);
        --record.count;
        if (record.count == 0) {
            fgFactory.remove(document);
        }
    }

    public static synchronized IDocumentUndoManager getDocumentUndoManager(IDocument document) {
        Assert.isNotNull((Object)document);
        Record record = (Record)fgFactory.get(document);
        if (record == null) {
            return null;
        }
        return record.undoManager;
    }

    private static final class Record {
        private int count = 0;
        private IDocumentUndoManager undoManager;

        public Record(IDocument document) {
            this.undoManager = new DFLDocumentUndoManager(document);
        }
    }
}

