/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.datasense;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.message.api.MessageMetadataTypeBuilder;
import org.mule.metadata.message.api.MuleEventMetadataType;
import org.mule.metadata.message.api.MuleEventMetadataTypeBuilder;
import org.mule.metadata.message.api.el.ModuleDefinition;
import org.mule.metadata.message.api.el.TypeBindings;
import org.mule.tooling.client.metadata.MetadataEvent;

public class WeaveTypesConvertersUtils {
    public static MuleEventMetadataType toMuleEventMetadata(MetadataEvent metadataEvent) {
        MuleEventMetadataTypeBuilder eventBuilder = new MuleEventMetadataTypeBuilder();
        MessageMetadataTypeBuilder messageBuilder = eventBuilder.message();
        messageBuilder.payload(metadataEvent.getPayload());
        messageBuilder.attributes(metadataEvent.getAttributes());
        ObjectType variables = metadataEvent.getVariables();
        Collection fields = variables.getFields();
        for (ObjectFieldType fieldType : fields) {
            eventBuilder.addVariable(fieldType.getKey().getName().getLocalPart(), fieldType.getValue());
        }
        MuleEventMetadataType eventType = eventBuilder.build();
        return eventType;
    }

    public static TypeBindings fromMap(Map<String, MetadataType> typeBindingsMap) {
        if (typeBindingsMap == null) {
            return TypeBindings.builder().build();
        }
        LinkedHashMap<String, MetadataType> bindings = new LinkedHashMap<String, MetadataType>();
        LinkedHashMap<String, Map> modules = new LinkedHashMap<String, Map>();
        typeBindingsMap.forEach((qualifiedIdentifier, metadataType) -> {
            String[] split = qualifiedIdentifier.split("::");
            if (split.length == 2) {
                String module = split[0];
                String identifier = split[1];
                LinkedHashMap<String, MetadataType> moduleBindings = (LinkedHashMap<String, MetadataType>)modules.get(module);
                if (moduleBindings == null) {
                    moduleBindings = new LinkedHashMap<String, MetadataType>();
                    modules.put(module, moduleBindings);
                }
                moduleBindings.put(identifier, (MetadataType)metadataType);
            } else if (split.length == 1) {
                String identifier = split[0];
                bindings.put(identifier, (MetadataType)metadataType);
            } else {
                throw new IllegalArgumentException(String.format("Illegal type binding identifier %s", qualifiedIdentifier));
            }
        });
        TypeBindings.Builder builder = TypeBindings.builder();
        bindings.forEach((arg_0, arg_1) -> ((TypeBindings.Builder)builder).addBinding(arg_0, arg_1));
        modules.forEach((module, moduleBindings) -> {
            ModuleDefinition.Builder moduleBuilder = builder.module(module);
            moduleBindings.forEach((arg_0, arg_1) -> ((ModuleDefinition.Builder)moduleBuilder).addElement(arg_0, arg_1));
        });
        return builder.build();
    }
}

