/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.datasense;

import java.util.Map;
import java.util.Optional;
import org.mule.metadata.api.model.MetadataType;
import org.mule.tooling.client.api.PropagationInfo;
import org.mule.tooling.client.metadata.MetadataEvent;
import org.mule.tooling.dfl.ui.datasense.AbstractMetadataTypeDataSenseProvider;
import org.mule.tooling.dfl.ui.input.IMetaDataProvider;
import org.mule.tooling.dfl.ui.utils.DwMetadataUtils;

public class PropagationInfoDataSenseProviderAdapter
extends AbstractMetadataTypeDataSenseProvider {
    private PropagationInfo propInfo;

    public PropagationInfoDataSenseProviderAdapter(PropagationInfo propInfo) {
        this.propInfo = propInfo;
    }

    @Override
    public Optional<MetadataType> getOutputMetadata() {
        return Optional.empty();
    }

    @Override
    public IMetaDataProvider getInputMetadata() {
        return new PropagationInfoMetadataProvider();
    }

    @Override
    public boolean isDataSenseAvailable() {
        return true;
    }

    private class PropagationInfoMetadataProvider
    implements IMetaDataProvider {
        private PropagationInfoMetadataProvider() {
        }

        @Override
        public MetadataEvent getMetadata() {
            return PropagationInfoDataSenseProviderAdapter.this.propInfo.getInputMetadataType();
        }

        @Override
        public Optional<MetadataType> getModel(String variableName) {
            if ("payload".equalsIgnoreCase(variableName)) {
                return Optional.of(this.getMetadata().getMessage().getPayload());
            }
            if ("attributes".equalsIgnoreCase(variableName)) {
                return Optional.of(this.getMetadata().getMessage().getAttributes());
            }
            if ("vars".equalsIgnoreCase(variableName)) {
                return Optional.of(this.getMetadata().getVariables());
            }
            return this.getMetadataModel(variableName);
        }

        private Optional<MetadataType> getMetadataModel(String variableName) {
            return DwMetadataUtils.fromOptional(this.getMetadata().getVariables().getFieldByName(variableName));
        }

        @Override
        public Map<String, MetadataType> getGlobalBindings() {
            return PropagationInfoDataSenseProviderAdapter.this.propInfo.getGlobalBindings();
        }

        @Override
        public Map<String, MetadataType> getFunctionBindings() {
            return PropagationInfoDataSenseProviderAdapter.this.propInfo.getFunctionBindings();
        }

        @Override
        public boolean isMetadataAvailable() {
            return true;
        }
    }
}

