/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.datasense;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.mule.metadata.api.model.MetadataType;
import org.mule.tooling.client.api.PropagationInfo;
import org.mule.tooling.client.metadata.ITypesManager;
import org.mule.tooling.client.metadata.MetadataEvent;
import org.mule.tooling.client.metadata.MetadataFactory;
import org.mule.tooling.client.metadata.enricher.MetadataEnricher;
import org.mule.tooling.client.metadata.enricher.MetadataEventEnricher;
import org.mule.tooling.client.metadata.enricher.MetadataOperationEnricher;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.io.EditingScope;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.metadata.cache.MetadataTypesManager;
import org.mule.tooling.metadata.datasense.DataSenseRequest;
import org.mule.tooling.metadata.datasense.DataSenseResponse;
import org.mule.tooling.model.messageflow.ComponentId;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.model.messageflow.path.MulePath;
import org.mule.tooling.ui.modules.core.api.metadata.IDataSenseResolver;
import org.mule.tooling.ui.modules.core.metadata.MetadataHelpers;
import org.mule.tooling.ui.modules.core.metadata.definition.MessageRowType;
import org.mule.tooling.ui.modules.core.metadata.definition.MetadataDefinitionConfiguration;
import org.mule.tooling.ui.modules.core.metadata.definition.MetadataResult;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeNode;

public class MetadataHelper {
    public static CompletableFuture<PropagationInfo> getPropagationMetadata(IMuleProject project, MuleConfiguration config, MessageFlowEntity entity) {
        MulePath mulePath = config.getPathFor((IMessageFlowEntity)entity);
        DataSenseRequest request = new DataSenseRequest(project, EditingScope.getCurrent(), config, mulePath, DataSenseRequest.DataSenseRequestType.PROPAGATION);
        return ((IDataSenseResolver)MuleCorePlugin.getStudioContext().get(IDataSenseResolver.class)).resolveDataSense(request).thenApply(DataSenseResponse::getPropagationInfo);
    }

    public static ITypesManager getTypesManager(IMuleProject project) {
        return ((MetadataTypesManager)project.getProjectComponent(MetadataTypesManager.class)).getTypesManager();
    }

    public static MetadataType getVariableMetadataType(MetadataEvent metadataEvent, String variableName) {
        return metadataEvent.getVariables().getFieldByName(variableName).map(input -> input.getValue()).orElse(MetadataFactory.undefined());
    }

    public static void updateMetadata(MessageRowType rowType, IMessageFlowNode node, IMuleProject project, Optional<String> variableName, MetadataResult result) {
        ComponentId componentId = ComponentId.from((IMessageFlowEntity)node);
        if (componentId.isUndefined()) {
            PropertyCollectionMap props = node.getProperties().toPropertyCollectionMap();
            componentId = MetadataHelpers.defineComponentIdProperty((IMessageFlowNode)node, (PropertyCollectionMap)props, (ComponentId)componentId);
        }
        ITypesManager typesManager = MetadataHelper.getTypesManager(project);
        Optional maybeEnricher = typesManager.getEnricher(componentId);
        HashMap previousConfigsByRowType = Maps.newHashMap();
        MessageRowType[] messageRowTypeArray = MessageRowType.values();
        int n = messageRowTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            MessageRowType previousRowType = messageRowTypeArray[n2];
            List configs = previousRowType.loadConfigFrom(maybeEnricher);
            if (configs != null && !configs.isEmpty()) {
                previousConfigsByRowType.put(previousRowType, configs);
            }
            ++n2;
        }
        MetadataDefinitionConfiguration prevConf = null;
        ArrayList previousConfigs = previousConfigsByRowType.get(rowType) != null ? (List)previousConfigsByRowType.get(rowType) : Lists.newArrayList();
        for (MetadataDefinitionConfiguration metadataDefinitionConfiguration : previousConfigs) {
            if ((MessageRowType.INPUT_PAYLOAD == rowType || MessageRowType.INPUT_ATTRIBUTES == rowType || MessageRowType.OUTPUT_PAYLOAD == rowType || MessageRowType.OUTPUT_ATTRIBUTES == rowType) && metadataDefinitionConfiguration.getId().equals(rowType.getId())) {
                prevConf = metadataDefinitionConfiguration;
                continue;
            }
            if (MessageRowType.INPUT_VARIABLES != rowType && MessageRowType.OUTPUT_VARIABLES != rowType || !variableName.isPresent() || !metadataDefinitionConfiguration.getVariableName().equals(variableName.get())) continue;
            prevConf = metadataDefinitionConfiguration;
        }
        if (prevConf != null) {
            previousConfigs.remove(prevConf);
        }
        MetadataEventEnricher inputEnricher = new MetadataEventEnricher();
        MetadataEventEnricher outputEnricher = new MetadataEventEnricher();
        MetadataDefinitionConfiguration newConfig = MetadataHelper.createConfig(result, variableName);
        previousConfigs.add(newConfig);
        previousConfigsByRowType.put(rowType, previousConfigs);
        for (Map.Entry configsByRowType : previousConfigsByRowType.entrySet()) {
            MessageRowType currentRowType = (MessageRowType)configsByRowType.getKey();
            List configs = (List)configsByRowType.getValue();
            currentRowType.processMetadataDefinitionConfig(configs, inputEnricher, outputEnricher);
        }
        typesManager.enrich(new MetadataEnricher(componentId, inputEnricher, outputEnricher, new MetadataOperationEnricher()));
        typesManager.persistCustomTypes();
    }

    public static boolean isPropertyHeader(GraphicalTreeNode<?> graphicalTreeNode) {
        String id = graphicalTreeNode.getId();
        return "vars".equals(id) || "attributes".equals(id);
    }

    public static Optional<MessageRowType> getCurrentMessageRowType(GraphicalTreeNode<?> graphicalTreeNode) {
        String nodeId = graphicalTreeNode.getId();
        Optional<MessageRowType> currentRowType = Optional.empty();
        if ("attributes".equals(nodeId)) {
            currentRowType = Optional.of(MessageRowType.INPUT_ATTRIBUTES);
        } else if ("vars".equals(nodeId)) {
            currentRowType = Optional.of(MessageRowType.INPUT_VARIABLES);
        }
        return currentRowType;
    }

    public static Optional<MessageRowType> getCurrentOutputMessageRowType(String category) {
        Optional<MessageRowType> currentRowType = Optional.empty();
        switch (category) {
            case "payload": {
                currentRowType = Optional.of(MessageRowType.OUTPUT_PAYLOAD);
                break;
            }
            case "attributes": {
                currentRowType = Optional.of(MessageRowType.OUTPUT_ATTRIBUTES);
                break;
            }
            case "vars": {
                currentRowType = Optional.of(MessageRowType.OUTPUT_VARIABLES);
            }
        }
        return currentRowType;
    }

    public static MetadataDefinitionConfiguration createConfig(MetadataResult result, Optional<String> propertyName) {
        MetadataDefinitionConfiguration configuration = new MetadataDefinitionConfiguration();
        configuration.setKey(result.getKey());
        if (propertyName.isPresent()) {
            configuration.setVariableName(propertyName.get());
        }
        configuration.setCollection(result.isCollection());
        configuration.setModule(result.getModule());
        configuration.setCollection(result.isCollection());
        return configuration;
    }
}

