/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.datasense;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.AnyType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.impl.DefaultObjectFieldType;
import org.mule.metadata.api.model.impl.DefaultObjectType;
import org.mule.tooling.client.ToolingMetadataKeyBuilder;
import org.mule.tooling.client.api.PropagationInfo;
import org.mule.tooling.client.api.metadata.MetadataKey;
import org.mule.tooling.client.metadata.ITypesManager;
import org.mule.tooling.client.metadata.MetadataEvent;
import org.mule.tooling.client.metadata.MetadataFactory;
import org.mule.tooling.client.metadata.MetadataMessage;
import org.mule.tooling.client.metadata.MetadataTypeProxy;
import org.mule.tooling.client.metadata.enricher.MetadataEnricher;
import org.mule.tooling.client.metadata.enricher.MetadataEventEnricher;
import org.mule.tooling.client.metadata.enricher.MetadataTypeRef;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.dfl.ui.datasense.MetadataHelper;
import org.mule.tooling.dfl.ui.input.IMetaDataProvider;
import org.mule.tooling.dfl.ui.utils.DwMetadataUtils;
import org.mule.tooling.metadata.annotations.CustomTypeAnnotation;
import org.mule.tooling.metadata.cache.MetadataTypesManager;
import org.mule.tooling.model.messageflow.ComponentId;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.ui.modules.core.metadata.IPropagationInfoProvider;
import org.mule.tooling.ui.modules.core.metadata.definition.MessageRowType;

public class DwMetadataProvider
implements IMetaDataProvider {
    private final IMuleProject project;
    private final IMessageFlowEntity element;
    private final MessageRowType defaultMessageRowType;
    private final BiFunction<PropagationInfo, Optional<DwMetadataProviderContext>, MetadataEvent> onDefinedCustomMetadata;
    private final Function<PropagationInfo, MetadataEvent> onUndefinedCustomMetadata;
    private final IPropagationInfoProvider propagationProvider;

    public static DwMetadataProvider createInputMetaDataProvider(IMuleProject project, IMessageFlowEntity element, IPropagationInfoProvider propagationProvider) {
        return new DwMetadataProvider(project, element, propagationProvider, MessageRowType.INPUT_PAYLOAD, DwMetadataProvider::overlapExpectedInputWithIncomingMetadata, PropagationInfo::getIncomingMetadataType);
    }

    public static DwMetadataProvider createOutputMetaDataProvider(IMuleProject project, IMessageFlowNode element, IPropagationInfoProvider propagationProvider, MessageRowType rowType) {
        return new DwMetadataProvider(project, (IMessageFlowEntity)element, propagationProvider, rowType, DwMetadataProvider::enrichOutputMetadata, PropagationInfo::getExpectedMetadataType);
    }

    public static MetadataEvent enrichOutputMetadata(PropagationInfo propagationInfo, Optional<DwMetadataProviderContext> context) {
        MetadataEvent output = propagationInfo.getOutputMetadataType();
        MetadataType payload = DwMetadataRow.PAYLOAD.getEnrichedMetadataTypeIfDefined(output, context);
        MetadataType attributes = DwMetadataRow.ATTRIBUTES.getEnrichedMetadataTypeIfDefined(output, context);
        ObjectType variables = (ObjectType)DwMetadataRow.VARIABLES.getEnrichedMetadataTypeIfDefined(output, context);
        return new MetadataEvent(new MetadataMessage(payload, attributes), output.getError(), variables);
    }

    private static MetadataEvent overlapExpectedInputWithIncomingMetadata(PropagationInfo propagationInfo, Optional<DwMetadataProviderContext> context) {
        if (IPropagationInfoProvider.isUnresolvedMetadata((PropagationInfo)propagationInfo)) {
            return IPropagationInfoProvider.getUnresolvedMetadataEvent();
        }
        MetadataEvent expectedInput = propagationInfo.getExpectedInputMetadataType();
        MetadataEvent incoming = propagationInfo.getIncomingMetadataType();
        MetadataType payload = DwMetadataRow.PAYLOAD.getMetadataType(expectedInput, incoming, context);
        MetadataType attributes = DwMetadataRow.ATTRIBUTES.getMetadataType(expectedInput, incoming, context);
        ObjectType variables = (ObjectType)DwMetadataRow.VARIABLES.getMetadataType(expectedInput, incoming, context);
        return new MetadataEvent(new MetadataMessage(payload, attributes), incoming.getError(), variables);
    }

    private static MetadataType getEnrichedMetadataType(MetadataType custom, MetadataType metadataType) {
        Map annotations = custom.getAnnotations().stream().filter(CustomTypeAnnotation.class::isInstance).collect(Collectors.toMap(a -> a.getClass(), Function.identity()));
        return MetadataTypeProxy.proxying((MetadataType)metadataType, annotations);
    }

    private static ObjectType overlapExpectedInputWithIncomingVariables(MetadataEvent expectedInput, MetadataEvent incoming, Optional<DwMetadataProviderContext> maybeContext) {
        ObjectType expectedVariables = expectedInput.getVariables();
        Collection expectedVariablesFields = expectedVariables.getFields();
        HashSet<ObjectFieldType> resultingFields = new HashSet<ObjectFieldType>(expectedVariables.getFields());
        Set expectedVariableKeys = expectedVariablesFields.stream().map(fieldType -> fieldType.getKey().getName()).collect(Collectors.toSet());
        Collection incomingVariables = incoming.getVariables().getFields().stream().filter(fieldType -> !expectedVariableKeys.contains(fieldType.getKey().getName())).collect(Collectors.toSet());
        resultingFields.addAll(incomingVariables);
        return DwMetadataProvider.enrichVariables(expectedVariables, resultingFields, maybeContext);
    }

    private static ObjectType enrichVariables(ObjectType variables, Optional<DwMetadataProviderContext> maybeContext) {
        return DwMetadataProvider.enrichVariables(variables, variables.getFields(), maybeContext);
    }

    private static ObjectType enrichVariables(ObjectType variables, Collection<ObjectFieldType> fields, Optional<DwMetadataProviderContext> maybeContext) {
        Collection enrichedResultingFields = maybeContext.map(context -> {
            ITypesManager typesManager = ((MetadataTypesManager)context.project.getProjectComponent(MetadataTypesManager.class)).getTypesManager();
            Map enricherVariables = context.enricher.getVariables();
            return fields.stream().map(variable -> {
                Optional<MetadataType> maybeCustom;
                String variableKey = variable.getKey().getName().getLocalPart();
                MetadataTypeRef ref = (MetadataTypeRef)enricherVariables.get(variableKey);
                if (ref == null || ref.isNull()) {
                    maybeCustom = Optional.empty();
                } else {
                    MetadataKey metadataKey = ToolingMetadataKeyBuilder.newKey((String)ref.getKey()).build();
                    maybeCustom = Optional.ofNullable(typesManager.getCustomMetadataType(metadataKey));
                }
                return maybeCustom.map(custom -> new DefaultObjectFieldType(variable.getKey(), DwMetadataProvider.getEnrichedMetadataType(custom, variable.getValue()), variable.isRequired(), variable.isRepeated(), variable.getMetadataFormat(), variable.getAnnotations().stream().collect(Collectors.toMap(annotation -> annotation.getClass(), Function.identity())))).orElse((ObjectFieldType)variable);
            }).collect(Collectors.toSet());
        }).orElse(new HashSet<ObjectFieldType>(fields));
        return new DefaultObjectType(enrichedResultingFields, variables.isOrdered(), (MetadataType)variables.getOpenRestriction().orElse(null), variables.getMetadataFormat(), variables.getAnnotations().stream().collect(Collectors.toMap(annotation -> annotation.getClass(), Function.identity())));
    }

    private static boolean isUndefinedMetadata(MetadataType expectedPayload) {
        return MetadataFactory.isUndefined((MetadataType)expectedPayload) || expectedPayload instanceof AnyType;
    }

    public DwMetadataProvider(IMuleProject project, IMessageFlowEntity element, IPropagationInfoProvider propagationProvider, MessageRowType defaultMessageRowType, BiFunction<PropagationInfo, Optional<DwMetadataProviderContext>, MetadataEvent> onDefinedCustomMetadata, Function<PropagationInfo, MetadataEvent> onUndefinedCustomMetadata) {
        this.project = project;
        this.element = element;
        this.propagationProvider = propagationProvider;
        this.defaultMessageRowType = defaultMessageRowType;
        this.onDefinedCustomMetadata = onDefinedCustomMetadata;
        this.onUndefinedCustomMetadata = onUndefinedCustomMetadata;
    }

    @Override
    public Optional<MetadataType> getModel(String variableName) {
        if ("payload".equalsIgnoreCase(variableName)) {
            return Optional.of(this.getMetadata().getMessage().getPayload());
        }
        if ("attributes".equalsIgnoreCase(variableName)) {
            return Optional.of(this.getMetadata().getMessage().getAttributes());
        }
        if ("vars".equalsIgnoreCase(variableName)) {
            return Optional.of(this.getMetadata().getVariables());
        }
        return this.getMetadataModel(variableName);
    }

    private Optional<MetadataType> getMetadataModel(String variableName) {
        return DwMetadataUtils.fromOptional(this.getMetadata().getVariables().getFieldByName(variableName));
    }

    public String toString() {
        return "DefaultMetaDataProvider [getMetadata()=" + String.valueOf(this.getMetadata()) + "]";
    }

    @Override
    public boolean isMetadataAvailable() {
        return this.propagationProvider.isPropagationAvailable();
    }

    @Override
    public MetadataEvent getMetadata() {
        return this.computeMetadata(this.defaultMessageRowType, this.propagationProvider);
    }

    @Override
    public Map<String, MetadataType> getGlobalBindings() {
        return this.propagationProvider.getPropagationInfo().getGlobalBindings();
    }

    @Override
    public Map<String, MetadataType> getFunctionBindings() {
        return this.propagationProvider.getPropagationInfo().getFunctionBindings();
    }

    private MetadataEvent computeMetadata(MessageRowType currentRowTypeToReload, IPropagationInfoProvider propagationProvider) {
        Optional<MetadataEvent> definedMetadata = this.getDefinedMetadata(currentRowTypeToReload, enricher -> this.onDefinedCustomMetadata.apply(propagationProvider.getPropagationInfo(), Optional.of(new DwMetadataProviderContext(this.project, (MetadataEventEnricher)enricher.get()))));
        return definedMetadata.isPresent() ? definedMetadata.get() : this.onUndefinedCustomMetadata.apply(propagationProvider.getPropagationInfo());
    }

    private Optional<MetadataEvent> getDefinedMetadata(MessageRowType currentRowTypeToReload, Function<Optional<MetadataEventEnricher>, MetadataEvent> metadataSupplier) {
        Optional<MetadataEvent> definedMetadata = Optional.empty();
        ComponentId componentId = ComponentId.from((IMessageFlowEntity)this.element);
        if (componentId.isDefined()) {
            ITypesManager typesManager = MetadataHelper.getTypesManager(this.project);
            Optional enricher = typesManager.getEnricher(componentId);
            if (currentRowTypeToReload.isOutput()) {
                List configurations = currentRowTypeToReload.loadConfigFrom(enricher);
                if (configurations != null && !configurations.isEmpty()) {
                    MetadataEvent targetMetadata = metadataSupplier.apply(enricher.flatMap(MetadataEnricher::getOutputEnricher));
                    definedMetadata = Optional.of(targetMetadata);
                }
            } else if (this.isInputCustomMetadataDefined(enricher)) {
                MetadataEvent targetMetadata = metadataSupplier.apply(enricher.flatMap(MetadataEnricher::getInputEnricher));
                definedMetadata = Optional.of(targetMetadata);
            }
        }
        return definedMetadata;
    }

    private boolean isInputCustomMetadataDefined(Optional<MetadataEnricher> enricher) {
        return enricher.flatMap(MetadataEnricher::getInputEnricher).map(inputEnricher -> !inputEnricher.isEmpty()).orElse(false);
    }

    static /* synthetic */ MetadataType access$0(MetadataType metadataType, MetadataType metadataType2) {
        return DwMetadataProvider.getEnrichedMetadataType(metadataType, metadataType2);
    }

    public class DwMetadataProviderContext {
        MetadataEventEnricher enricher;
        IMuleProject project;

        public DwMetadataProviderContext(IMuleProject project, MetadataEventEnricher enricher) {
            this.project = project;
            this.enricher = enricher;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum DwMetadataRow {
        PAYLOAD{

            @Override
            protected MetadataType getMetadataType(MetadataEvent event) {
                return event.getMessage().getPayload();
            }

            @Override
            protected MetadataTypeRef getMetadataTypeRef(MetadataEventEnricher enricher) {
                return enricher.getPayload();
            }
        }
        ,
        ATTRIBUTES{

            @Override
            protected MetadataType getMetadataType(MetadataEvent event) {
                return event.getMessage().getAttributes();
            }

            @Override
            protected MetadataTypeRef getMetadataTypeRef(MetadataEventEnricher enricher) {
                return enricher.getAttributes();
            }
        }
        ,
        VARIABLES{

            @Override
            protected MetadataType getMetadataType(MetadataEvent event) {
                throw new UnsupportedOperationException("DwMetadataProvider.DwMetadataRow.VARIABLES.getMetadataType");
            }

            @Override
            protected MetadataTypeRef getMetadataTypeRef(MetadataEventEnricher enricher) {
                throw new UnsupportedOperationException("DwMetadataProvider.DwMetadataRow.VARIABLES.getMetadataTypeRef");
            }

            @Override
            public MetadataType getEnrichedMetadataTypeIfDefined(MetadataEvent event, Optional<DwMetadataProviderContext> context) {
                return DwMetadataProvider.enrichVariables(event.getVariables(), context);
            }

            public ObjectType getMetadataType(MetadataEvent expectedInput, MetadataEvent incoming, Optional<DwMetadataProviderContext> context) {
                return DwMetadataProvider.overlapExpectedInputWithIncomingVariables(expectedInput, incoming, context);
            }
        };


        public MetadataType getMetadataType(MetadataEvent expectedInput, MetadataEvent incoming, Optional<DwMetadataProviderContext> context) {
            MetadataType expectedInputMetadataType = this.getMetadataType(expectedInput);
            MetadataType incomingMetadataType = this.getMetadataType(incoming);
            MetadataType result = DwMetadataProvider.isUndefinedMetadata(expectedInputMetadataType) ? incomingMetadataType : expectedInputMetadataType;
            return this.getEnrichedMetadataTypeIfDefined(context, result);
        }

        public MetadataType getEnrichedMetadataTypeIfDefined(MetadataEvent event, Optional<DwMetadataProviderContext> context) {
            MetadataType type = this.getMetadataType(event);
            return this.getEnrichedMetadataTypeIfDefined(context, type);
        }

        private MetadataType getEnrichedMetadataTypeIfDefined(Optional<DwMetadataProviderContext> context, MetadataType type) {
            return context.flatMap(this::getCustomMetadataType).map(custom -> DwMetadataProvider.getEnrichedMetadataType(custom, type)).orElse(type);
        }

        protected abstract MetadataType getMetadataType(MetadataEvent var1);

        protected abstract MetadataTypeRef getMetadataTypeRef(MetadataEventEnricher var1);

        private Optional<MetadataType> getCustomMetadataType(DwMetadataProviderContext context) {
            MetadataTypeRef ref = this.getMetadataTypeRef(context.enricher);
            if (ref.isNull()) {
                return Optional.empty();
            }
            ITypesManager typesManager = ((MetadataTypesManager)context.project.getProjectComponent(MetadataTypesManager.class)).getTypesManager();
            MetadataKey metadataKey = ToolingMetadataKeyBuilder.newKey((String)ref.getKey()).build();
            return Optional.ofNullable(typesManager.getCustomMetadataType(metadataKey));
        }
    }
}

