/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.datasense;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.mule.metadata.api.model.MetadataType;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.MuleRuntime;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.dfl.ui.datasense.AbstractMetadataTypeDataSenseProvider;
import org.mule.tooling.dfl.ui.datasense.IDataSenseProvider;
import org.mule.tooling.dfl.ui.datasense.UndefinedDataSenseProvider;

public final class DataSenseHolder {
    private Map<String, DataSenseContext> context = new HashMap<String, DataSenseContext>();
    private static DataSenseHolder instance = new DataSenseHolder();

    private DataSenseHolder() {
    }

    public static IDataSenseProvider getCurrentDataSenseProvider(String url) {
        return DataSenseHolder.getContext(url).map(context -> context.getDataSenseProvider()).orElse(new UndefinedDataSenseProvider());
    }

    public static Map<String, MetadataType> getFunctionBindings(IMuleProject muleProject) {
        return DataSenseHolder.instance.context.values().stream().filter(context -> context.project == muleProject && context.dataSenseProvider instanceof AbstractMetadataTypeDataSenseProvider).map(context -> ((AbstractMetadataTypeDataSenseProvider)context.dataSenseProvider).getInputMetadata().getFunctionBindings()).findFirst().orElse(new HashMap());
    }

    private static Optional<DataSenseContext> getContext(String url) {
        return Optional.ofNullable(DataSenseHolder.instance.context.get(url));
    }

    public static void setContext(String url, IDataSenseProvider currentDataSenseProvider, IMuleProject project) {
        DataSenseHolder.instance.context.put(url, new DataSenseContext(currentDataSenseProvider, project));
    }

    public static void removeContext(String url) {
        DataSenseHolder.instance.context.remove(url);
    }

    public static IMuleProject getProject(String url) {
        Optional<IMuleProject> project = DataSenseHolder.getContext(url).map(context -> context.getProject());
        if (!project.isPresent()) {
            IMuleProject muleProject = MuleCorePlugin.getDesignContext().getMuleProject();
            if (muleProject == null) {
                return DataSenseHolder.getAnyMuleProject();
            }
            return muleProject;
        }
        return project.get();
    }

    public static IMuleProject getAnyMuleProject() {
        try {
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            IProject[] projects = workspaceRoot.getProjects();
            int i = 0;
            while (i < projects.length) {
                IProject project = projects[i];
                if (project.isOpen() && project.hasNature("org.mule.tooling.core.muleStudioNature")) {
                    return MuleRuntime.create((IProject)project);
                }
                ++i;
            }
        }
        catch (CoreException ce) {
            ce.printStackTrace();
        }
        return null;
    }

    private static class DataSenseContext {
        private IDataSenseProvider dataSenseProvider;
        private IMuleProject project;

        public DataSenseContext(IDataSenseProvider dataSenseProvider, IMuleProject project) {
            this.dataSenseProvider = dataSenseProvider;
            this.project = project;
        }

        public IDataSenseProvider getDataSenseProvider() {
            return this.dataSenseProvider;
        }

        public IMuleProject getProject() {
            return this.project;
        }
    }
}

