/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.css;

import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.swt.properties.AbstractCSSPropertySWTHandler;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.mule.tooling.ui.widgets.util.ThemeUtils;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;

public abstract class AbstractDataWeaveCSSPropertyHandler
extends AbstractCSSPropertySWTHandler {
    private final PropertyHandler[] handlers;

    protected AbstractDataWeaveCSSPropertyHandler(PropertyHandler ... handlers) {
        this.handlers = handlers;
    }

    protected void applyCSSProperty(Control control, String property, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        PropertyHandler[] propertyHandlerArray = this.handlers;
        int n = this.handlers.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyHandler handler = propertyHandlerArray[n2];
            if (handler.canApply(control, property, value, pseudo)) {
                handler.apply(control, property, value, pseudo, engine);
                return;
            }
            ++n2;
        }
    }

    protected String retrieveCSSProperty(Control control, String property, String pseudo, CSSEngine engine) throws Exception {
        PropertyHandler[] propertyHandlerArray = this.handlers;
        int n = this.handlers.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyHandler handler = propertyHandlerArray[n2];
            if (handler.canRetrieve(control, property, pseudo)) {
                return handler.retrieve(control, property, pseudo, engine);
            }
            ++n2;
        }
        return null;
    }

    protected static interface PropertyHandler {
        public boolean canApply(Control var1, String var2, CSSValue var3, String var4);

        public boolean canRetrieve(Control var1, String var2, String var3);

        public void apply(Control var1, String var2, CSSValue var3, String var4, CSSEngine var5) throws Exception;

        public String retrieve(Control var1, String var2, String var3, CSSEngine var4) throws Exception;
    }

    protected static abstract class SimplePropertyHandler
    implements PropertyHandler {
        private final Class<?> target;
        private final String property;

        SimplePropertyHandler(Class<?> target, String property) {
            this.target = target;
            this.property = property;
        }

        protected Color cssValueToColor(CSSValue value, CSSEngine engine, Display display) throws Exception {
            return ThemeUtils.cssValueToColor((CSSValue)value, (CSSEngine)engine, (Display)display);
        }

        protected String colorToCssValue(Color color, CSSEngine engine) throws Exception {
            return engine.getCSSValueConverter(Color.class).convert((Object)color, engine, null);
        }

        protected float cssValueToFloat(CSSValue value) {
            return ((CSSPrimitiveValue)value).getFloatValue((short)1);
        }

        @Override
        public boolean canApply(Control control, String property, CSSValue value, String pseudo) {
            return this.target.isInstance(control) && this.property.equalsIgnoreCase(property) && value.getCssValueType() == 1;
        }

        @Override
        public boolean canRetrieve(Control control, String property, String pseudo) {
            return this.target.isInstance(control) && this.property.equalsIgnoreCase(property);
        }
    }
}

