/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.contentassist.operators.impl;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.tooling.dfl.ui.contentassist.model.IDFLArrayType;
import org.mule.tooling.dfl.ui.contentassist.model.IDFLLambdaType;
import org.mule.tooling.dfl.ui.contentassist.model.IDFLType;
import org.mule.tooling.dfl.ui.contentassist.model.types.DFLTypeFactory;
import org.mule.tooling.dfl.ui.contentassist.operators.IDFLBinaryOperatorDescriptor;
import org.mule.tooling.dfl.ui.contentassist.operators.IDFLContextPopulator;
import org.mule.tooling.utils.ListHelper;

public class ReduceOperatorDescriptor
implements IDFLBinaryOperatorDescriptor,
IDFLContextPopulator {
    @Override
    public String getName() {
        return "reduce";
    }

    @Override
    public List<List<IDFLType>> getValidParameterTypes() {
        return Arrays.asList(Arrays.asList(DFLTypeFactory.ANY_ARRAY, DFLTypeFactory.ANY_LAMBDA), Arrays.asList(DFLTypeFactory.ANY_OBJECT, DFLTypeFactory.ANY_LAMBDA));
    }

    @Override
    public IDFLType getReturnTypes(IDFLType left, IDFLType right) {
        if (DFLTypeFactory.ANY_LAMBDA.isAssignableFrom(right) && DFLTypeFactory.ANY_ARRAY.isAssignableFrom(left)) {
            IDFLLambdaType lambda = (IDFLLambdaType)right;
            IDFLArrayType array = (IDFLArrayType)left;
            return lambda.getReturnType(array.getType(), (IDFLType)ListHelper.get(lambda.getDefaultValues(), (int)0).or((Object)array.getType()));
        }
        return DFLTypeFactory.UNKNOWN;
    }

    @Override
    public String getLabel() {
        return "Reduce";
    }

    @Override
    public Map<String, IDFLType> populate(IDFLType ... arguments) {
        IDFLType left = arguments[0];
        IDFLType right = arguments[1];
        HashMap<String, IDFLType> result = new HashMap<String, IDFLType>();
        if (DFLTypeFactory.ANY_LAMBDA.isAssignableFrom(right) && DFLTypeFactory.ANY_ARRAY.isAssignableFrom(left)) {
            IDFLLambdaType lambda = (IDFLLambdaType)right;
            IDFLArrayType array = (IDFLArrayType)left;
            result.put(lambda.getParametersNames().get(0), array.getType());
            result.put(lambda.getParametersNames().get(1), (IDFLType)ListHelper.get(lambda.getDefaultValues(), (int)0).or((Object)array.getType()));
        }
        return result;
    }
}

